/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractAstFunctionChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.model.cfg.IBasicBlock;
import org.eclipse.cdt.codan.core.model.cfg.ICfgData;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.codan.internal.core.cfg.ControlFlowGraph;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.resources.IResource;

public class ReturnChecker
extends AbstractAstFunctionChecker {
    public static final String PARAM_IMPLICIT = "implicit";
    public static final String RET_NO_VALUE_ID = "org.eclipse.cdt.codan.checkers.noreturn";
    public static final String RET_ERR_VALUE_ID = "org.eclipse.cdt.codan.checkers.errreturnvalue";
    public static final String RET_NORET_ID = "org.eclipse.cdt.codan.checkers.errnoreturn";
    public static final String RET_LOCAL_ID = "org.eclipse.cdt.codan.checkers.localvarreturn";
    private IType cachedReturnType = null;

    private static boolean isConstructorDestructor(IASTFunctionDefinition func) {
        IBinding method;
        return func instanceof ICPPASTFunctionDefinition && ((method = func.getDeclarator().getName().resolveBinding()) instanceof ICPPConstructor || method instanceof ICPPMethod && ((ICPPMethod)method).isDestructor());
    }

    public boolean isMain(IASTFunctionDefinition func) {
        try {
            char[] functionName = func.getDeclarator().getName().getSimpleID();
            if (CharArrayUtils.equals((char[])functionName, (String)"main")) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    protected void processFunction(IASTFunctionDefinition func) {
        IASTStatement body;
        this.cachedReturnType = null;
        ReturnStmpVisitor visitor = new ReturnStmpVisitor(func);
        func.accept((ASTVisitor)visitor);
        ReturnTypeKind returnKind = this.getReturnTypeKind(func);
        if (returnKind == ReturnTypeKind.NonVoid && !this.isMain(func) && (body = func.getBody()) instanceof IASTCompoundStatement) {
            IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
            if (statements.length > 0) {
                IASTStatement last = statements[statements.length - 1];
                while (last instanceof IASTLabelStatement) {
                    last = ((IASTLabelStatement)last).getNestedStatement();
                }
                if (this.isCompoundStatement(last)) {
                    if (this.endsWithNoExitNode(func)) {
                        this.reportNoRet(func, visitor.hasret);
                    }
                } else if (!this.isFuncExitStatement(last) && !this.isInDeadCode(func, last)) {
                    this.reportNoRet(func, visitor.hasret);
                }
            } else {
                this.reportNoRet(func, false);
            }
        }
    }

    private boolean isInDeadCode(IASTFunctionDefinition func, IASTStatement last) {
        Collection<IBasicBlock> deadBlocks = this.getDeadBlocks(func);
        for (IBasicBlock bb : deadBlocks) {
            if (((ICfgData)bb).getData() != last) continue;
            return true;
        }
        return false;
    }

    public Collection<IBasicBlock> getDeadBlocks(IASTFunctionDefinition func) {
        IControlFlowGraph graph = this.getModelCache().getControlFlowGraph(func);
        return ((ControlFlowGraph)graph).getDeadNodes();
    }

    protected void reportNoRet(IASTFunctionDefinition func, boolean hasRet) {
        if (!(hasRet || this.checkImplicitReturn(RET_NORET_ID) || this.isExplicitReturn(func))) {
            return;
        }
        this.reportProblem(RET_NORET_ID, (IASTNode)func.getDeclSpecifier(), new Object[0]);
    }

    private boolean isCompoundStatement(IASTStatement last) {
        return last instanceof IASTIfStatement || last instanceof IASTWhileStatement || last instanceof IASTDoStatement || last instanceof IASTForStatement || last instanceof IASTSwitchStatement || last instanceof IASTCompoundStatement || last instanceof ICPPASTTryBlockStatement || last instanceof IASTGotoStatement;
    }

    protected boolean isFuncExitStatement(IASTStatement statement) {
        return statement instanceof IASTReturnStatement || CxxAstUtils.isThrowStatement((IASTNode)statement) || CxxAstUtils.isExitStatement((IASTNode)statement);
    }

    protected boolean checkImplicitReturn(String id) {
        IProblem pt = this.getProblemById(id, (IResource)this.getFile());
        return (Boolean)this.getPreference(pt, PARAM_IMPLICIT);
    }

    protected boolean endsWithNoExitNode(IASTFunctionDefinition func) {
        IControlFlowGraph graph = this.getModelCache().getControlFlowGraph(func);
        Iterator exitNodeIterator = graph.getExitNodeIterator();
        while (exitNodeIterator.hasNext()) {
            Collection<IBasicBlock> deadBlocks;
            IExitNode node = (IExitNode)exitNodeIterator.next();
            Object astNode = ((ICfgData)node).getData();
            if (astNode != null || (deadBlocks = this.getDeadBlocks(func)).contains(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExplicitReturn(IASTFunctionDefinition func) {
        IASTDeclSpecifier declSpecifier = func.getDeclSpecifier();
        return !(declSpecifier instanceof IASTSimpleDeclSpecifier) || ((IASTSimpleDeclSpecifier)declSpecifier).getType() != 0;
    }

    private ReturnTypeKind getReturnTypeKind(IASTFunctionDefinition func) {
        if (ReturnChecker.isConstructorDestructor(func)) {
            return ReturnTypeKind.Void;
        }
        IType returnType = this.getReturnType(func);
        if (CPPTemplates.isDependentType((IType)returnType)) {
            return ReturnTypeKind.Unknown;
        }
        return ReturnChecker.isVoid(returnType) ? ReturnTypeKind.Void : ReturnTypeKind.NonVoid;
    }

    private IType getReturnType(IASTFunctionDefinition func) {
        if (this.cachedReturnType == null) {
            IType type;
            this.cachedReturnType = type = SemanticUtil.getNestedType((IType)CxxAstUtils.getReturnType((IASTFunctionDefinition)func), (int)1);
        }
        return this.cachedReturnType;
    }

    private static boolean isVoid(IType type) {
        return type instanceof IBasicType && ((IBasicType)type).getKind() == IBasicType.Kind.eVoid;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        if (problem.getId().equals(RET_NO_VALUE_ID) || problem.getId().equals(RET_NORET_ID)) {
            this.addPreference(problem, PARAM_IMPLICIT, CheckersMessages.ReturnChecker_Param0, Boolean.FALSE);
        }
    }

    private static enum RetType {
        BY_REF,
        BY_PTR;

    }

    class ReturnStmpVisitor
    extends ASTVisitor {
        private final IASTFunctionDefinition func;
        private final ReturnTypeAnalyzer analyzer;
        boolean hasret;

        ReturnStmpVisitor(IASTFunctionDefinition func) {
            IType retType;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.func = func;
            this.hasret = false;
            IBinding binding = func.getDeclarator().getName().resolveBinding();
            this.analyzer = binding instanceof IFunction ? ((retType = SemanticUtil.getNestedType((IType)((IFunction)binding).getType().getReturnType(), (int)1)) instanceof ICPPReferenceType ? new ReturnTypeAnalyzer(RetType.BY_REF) : (retType instanceof IPointerType ? new ReturnTypeAnalyzer(RetType.BY_PTR) : null)) : null;
        }

        RetType getType() {
            if (this.analyzer != null) {
                return this.analyzer.getType();
            }
            return null;
        }

        public int visit(IASTDeclaration element) {
            if (element != this.func) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof ICPPASTLambdaExpression) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTReturnStatement) {
                IASTReturnStatement ret = (IASTReturnStatement)stmt;
                IASTInitializerClause returnValue = ret.getReturnArgument();
                if (returnValue != null) {
                    this.hasret = true;
                }
                if ((returnKind = ReturnChecker.this.getReturnTypeKind(this.func)) == ReturnTypeKind.NonVoid && !ReturnChecker.isConstructorDestructor(this.func)) {
                    if (ReturnChecker.this.checkImplicitReturn(ReturnChecker.RET_NO_VALUE_ID) || ReturnChecker.this.isExplicitReturn(this.func)) {
                        if (returnValue == null) {
                            ReturnChecker.this.reportProblem(ReturnChecker.RET_NO_VALUE_ID, (IASTNode)ret, new Object[0]);
                        } else if (this.analyzer != null) {
                            this.analyzer.visit(returnValue);
                        }
                    }
                } else if (returnKind == ReturnTypeKind.Void && returnValue instanceof IASTExpression var5_6) {
                    IType type = SemanticUtil.getNestedType((IType)expr.getExpressionType(), (int)1);
                    if (ReturnChecker.isVoid(type) || CPPTemplates.isDependentType((IType)type)) {
                        return 1;
                    }
                    ReturnChecker.this.reportProblem(ReturnChecker.RET_ERR_VALUE_ID, (IASTNode)returnValue, new Object[0]);
                }
                return 1;
            }
            return 3;
        }
    }

    private class ReturnTypeAnalyzer {
        private RetType retType;
        private Stack<Integer> innermostOp;

        public ReturnTypeAnalyzer(RetType t) {
            this.retType = t;
            this.innermostOp = new Stack();
        }

        public RetType getType() {
            return this.retType;
        }

        public void visit(IASTInitializerClause expr) {
            if (expr instanceof IASTCastExpression) {
                this.visit((IASTCastExpression)expr);
            } else if (expr instanceof IASTConditionalExpression) {
                this.visit((IASTConditionalExpression)expr);
            } else if (expr instanceof IASTIdExpression) {
                this.visit((IASTIdExpression)expr);
            } else if (expr instanceof IASTUnaryExpression) {
                this.visit((IASTUnaryExpression)expr);
            } else if (expr instanceof IASTFieldReference) {
                this.visit((IASTFieldReference)expr);
            }
        }

        private void visit(IASTFieldReference expr) {
            this.visit((IASTInitializerClause)expr.getFieldOwner());
        }

        private void visit(IASTCastExpression expr) {
            IASTTypeId id = expr.getTypeId();
            IASTDeclarator declarator = id.getAbstractDeclarator();
            IASTPointerOperator[] ptr = declarator.getPointerOperators();
            if (ptr.length > 0 && ptr[0] instanceof ICPPASTReferenceOperator) {
                this.innermostOp.push(5);
            }
            this.visit((IASTInitializerClause)expr.getOperand());
            if (ptr.length > 0 && ptr[0] instanceof ICPPASTReferenceOperator) {
                this.innermostOp.pop();
            }
        }

        private void visit(IASTConditionalExpression expr) {
            this.visit((IASTInitializerClause)expr.getPositiveResultExpression());
            this.visit((IASTInitializerClause)expr.getNegativeResultExpression());
        }

        private void visit(IASTIdExpression expr) {
            IBinding binding = expr.getName().resolveBinding();
            if (binding instanceof IVariable && !(binding instanceof IParameter) && !(binding instanceof ICPPField)) {
                Integer op = null;
                if (!this.innermostOp.empty()) {
                    op = this.innermostOp.peek();
                }
                IType t = ((IVariable)binding).getType();
                if (((IVariable)binding).isStatic()) {
                    return;
                }
                t = SemanticUtil.getNestedType((IType)t, (int)1);
                if (this.retType == RetType.BY_REF && !(t instanceof ICPPReferenceType)) {
                    if (t instanceof IPointerType && op != null && op == 4) {
                        return;
                    }
                    try {
                        IScope scope = binding.getScope();
                        if (scope.getKind() == EScopeKind.eLocal) {
                            ReturnChecker.this.reportProblem(ReturnChecker.RET_LOCAL_ID, (IASTNode)expr, new Object[]{binding.getName()});
                        }
                    }
                    catch (DOMException e) {
                        CodanCheckersActivator.log(e);
                    }
                } else if (this.retType == RetType.BY_PTR && op != null && op == 5) {
                    try {
                        IScope scope = binding.getScope();
                        if (scope.getKind() == EScopeKind.eLocal) {
                            ReturnChecker.this.reportProblem(ReturnChecker.RET_LOCAL_ID, (IASTNode)expr, new Object[]{binding.getName()});
                        }
                    }
                    catch (DOMException e) {
                        CodanCheckersActivator.log(e);
                    }
                }
            }
        }

        private void visit(IASTUnaryExpression expr) {
            this.innermostOp.push(expr.getOperator());
            this.visit((IASTInitializerClause)expr.getOperand());
            this.innermostOp.pop();
        }
    }

    static enum ReturnTypeKind {
        Void,
        NonVoid,
        Unknown;

    }
}

