/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.ISaveTraceDataHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GdbSaveTraceDataCommand
extends AbstractDebugCommand
implements ISaveTraceDataHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbSaveTraceDataCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        final IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IGDBTraceControl.ITraceTargetDMContext.class);
        if (dmc == null) {
            return;
        }
        final String[] fileName = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            String string = this.promptForFileName();
        });
        if (fileName[0] != null) {
            Query<Object> saveTraceDataQuery = new Query<Object>(){

                public void execute(DataRequestMonitor<Object> rm) {
                    IGDBTraceControl traceControl = (IGDBTraceControl)GdbSaveTraceDataCommand.this.fTracker.getService(IGDBTraceControl.class);
                    if (traceControl != null) {
                        traceControl.saveTraceData(dmc, fileName[0], false, rm);
                    } else {
                        rm.done();
                    }
                }
            };
            try {
                this.fExecutor.execute((Runnable)saveTraceDataQuery);
                saveTraceDataQuery.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        final IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IGDBTraceControl.ITraceTargetDMContext.class);
        if (dmc == null) {
            return false;
        }
        Query<Boolean> canSaveQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)GdbSaveTraceDataCommand.this.fTracker.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    traceControl.canSaveTraceData(dmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canSaveQuery);
            return (Boolean)canSaveQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }

    private String promptForFileName() {
        Shell shell = Display.getDefault().getActiveShell();
        if (shell == null) {
            return null;
        }
        FileDialog fd = new FileDialog(shell, 8192);
        return fd.open();
    }
}

