/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.CachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.Log;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static boolean verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    private CachingServiceFactory cachingServiceFactory;
    private ServiceRegistration<?> cachingServiceFactoryRegistration;

    private void registerCachingServiceFactory(BundleContext bundleContext) {
        this.cachingServiceFactory = new CachingServiceFactory(bundleContext);
        this.cachingServiceFactoryRegistration = bundleContext.registerService(ICachingServiceFactory.class.getName(), (Object)this.cachingServiceFactory, null);
        if (Log.isDebugEnabled()) {
            Log.debug("Created and registered SingletonCachingService.");
        }
    }

    private void setDebugEnabled(BundleContext bundleContext) {
        DebugOptions debugOptions;
        ServiceReference debugOptionsReference = bundleContext.getServiceReference(DebugOptions.class.getName());
        if (debugOptionsReference != null && (debugOptions = (DebugOptions)bundleContext.getService(debugOptionsReference)) != null) {
            Log.debugEnabled = debugOptions.getBooleanOption("org.eclipse.equinox.weaving.caching/debug", false);
        }
        if (debugOptionsReference != null) {
            bundleContext.ungetService(debugOptionsReference);
        }
    }

    private boolean shouldRegister() {
        boolean enabled = true;
        try {
            Boolean sharing;
            Class.forName("com.ibm.oti.vm.VM");
            Class<?> sharedClass = Class.forName("com.ibm.oti.shared.Shared");
            Method isSharingEnabledMethod = sharedClass.getMethod("isSharingEnabled", null);
            if (isSharingEnabledMethod != null && (sharing = (Boolean)isSharingEnabledMethod.invoke(null, null)) != null && sharing.booleanValue()) {
                enabled = false;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
        return enabled;
    }

    public void start(BundleContext bundleContext) {
        this.setDebugEnabled(bundleContext);
        if (this.shouldRegister()) {
            if (verbose) {
                System.err.println("[org.eclipse.equinox.weaving.caching] info starting standard caching service ...");
            }
            this.registerCachingServiceFactory(bundleContext);
        } else if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.caching] warning cannot start standard caching service on J9 VM");
        }
    }

    public void stop(BundleContext context) {
        if (this.cachingServiceFactoryRegistration != null) {
            this.cachingServiceFactory.stop();
            this.cachingServiceFactoryRegistration.unregister();
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Shut down and unregistered SingletonCachingService.");
        }
    }
}

