/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.dataviewers.STDataViewersActivator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public class STDataViewersCSVExporter {
    private final AbstractSTViewer stViewer;
    private PrintStream ps = null;
    private ISTDataViewersField[] fields = null;
    private List<Object> expandedElts = null;
    private Comparator<Object> comparator;
    private Object input = null;
    private IContentProvider contentProvider = null;
    private IDialogSettings state = null;
    private IProgressMonitor monitor;
    private String filePath = null;
    private String csvSeparator = null;
    private String csvChildMarker = null;
    private String csvLastChildMarker = null;
    private String csvChildLink = null;
    private String csvNoChildLink = null;
    private String csvLeafMarker = null;
    private String csvNodeMarker = null;
    private boolean expandAll = false;
    private boolean showHiddenColumns = false;
    private boolean exportTreePrefix = false;

    public STDataViewersCSVExporter(AbstractSTViewer stViewer) {
        this.stViewer = stViewer;
        this.ps = System.out;
        this.state = stViewer.getViewerSettings().getSection("csv_exporter_section");
        this.restoreState();
    }

    public void restoreState() {
        if (this.state == null) {
            this.resetState();
            return;
        }
        try {
            this.filePath = this.state.get("csv_exporter_output_file_path");
            if (this.filePath == null) {
                this.resetState();
                return;
            }
            this.csvSeparator = this.state.get("csv_exporter_separator");
            if (this.csvSeparator == null) {
                this.resetState();
                return;
            }
            this.csvChildMarker = this.state.get("csv_exporter_child_marker");
            if (this.csvChildMarker == null) {
                this.resetState();
                return;
            }
            this.csvLastChildMarker = this.state.get("csv_exporter_last_child_marker");
            if (this.csvLastChildMarker == null) {
                this.resetState();
                return;
            }
            this.csvChildLink = this.state.get("csv_exporter_child_link");
            if (this.csvChildLink == null) {
                this.resetState();
                return;
            }
            this.csvNoChildLink = this.state.get("csv_exporter_no_child_link");
            if (this.csvNoChildLink == null) {
                this.resetState();
                return;
            }
            this.csvLeafMarker = this.state.get("csv_exporter_leaf_marker");
            if (this.csvLeafMarker == null) {
                this.resetState();
                return;
            }
            this.csvNodeMarker = this.state.get("csv_exporter_node_marker");
            if (this.csvNodeMarker == null) {
                this.resetState();
                return;
            }
            String temp = this.state.get("csv_exporter_expand_all");
            if (temp == null) {
                this.resetState();
                return;
            }
            this.expandAll = Boolean.parseBoolean(temp);
            temp = this.state.get("csv_exporter_show_hidden_columns");
            if (temp == null) {
                this.resetState();
                return;
            }
            this.showHiddenColumns = Boolean.parseBoolean(temp);
            if (this.isTreeViewerExporter()) {
                temp = this.state.get("csv_exporter_tree_prefix");
                if (temp == null) {
                    this.resetState();
                    return;
                }
                this.exportTreePrefix = Boolean.parseBoolean(temp);
            } else {
                this.exportTreePrefix = false;
            }
        }
        catch (NumberFormatException nfe) {
            Status s = Status.warning((String)("Invalid parameter, resetting configuration!\n" + nfe.getMessage()), (Throwable)nfe);
            this.logStatus((IStatus)s);
            this.resetState();
        }
    }

    public void saveState() {
        if (this.state == null) {
            this.state = this.stViewer.getViewerSettings().addNewSection("csv_exporter_section");
        }
        this.state.put("csv_exporter_output_file_path", this.filePath);
        this.state.put("csv_exporter_separator", this.csvSeparator);
        this.state.put("csv_exporter_child_marker", this.csvChildMarker);
        this.state.put("csv_exporter_last_child_marker", this.csvLastChildMarker);
        this.state.put("csv_exporter_child_link", this.csvChildLink);
        this.state.put("csv_exporter_no_child_link", this.csvNoChildLink);
        this.state.put("csv_exporter_leaf_marker", this.csvLeafMarker);
        this.state.put("csv_exporter_node_marker", this.csvNodeMarker);
        this.state.put("csv_exporter_expand_all", this.expandAll);
        this.state.put("csv_exporter_show_hidden_columns", this.showHiddenColumns);
        if (this.isTreeViewerExporter()) {
            this.state.put("csv_exporter_tree_prefix", this.exportTreePrefix);
        } else {
            this.state.put("csv_exporter_tree_prefix", false);
        }
    }

    public void resetState() {
        this.filePath = "./export.csv";
        this.csvSeparator = ";";
        this.csvChildMarker = "+-";
        this.csvLastChildMarker = "+-";
        this.csvChildLink = "| ";
        this.csvNoChildLink = "  ";
        this.csvLeafMarker = "";
        this.csvNodeMarker = "";
        this.expandAll = true;
        this.showHiddenColumns = true;
        this.exportTreePrefix = this.isTreeViewerExporter();
    }

    private void logStatus(IStatus s) {
        STDataViewersActivator.getDefault().getLog().log(s);
    }

    public void exportTo(String filePath) {
        this.setFilePath(filePath);
        this.export();
    }

    public void exportTo(String filePath, IProgressMonitor monitor) {
        this.setFilePath(filePath);
        this.export(monitor);
    }

    public void export() {
        this.export((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - void declaration
     */
    public void export(IProgressMonitor monitor) {
        this.monitor = monitor;
        monitor.beginTask("Exporting to CSV (file: " + this.getFilePath() + ")", -1);
        this.saveState();
        this.initPrintStream(this.filePath);
        monitor.subTask("collecting viewer's parameters...");
        this.collectViewerParameters();
        this.dumpColumnHeaders();
        if (this.input != null) {
            IContentProvider iContentProvider = this.contentProvider;
            if (iContentProvider instanceof ITreeContentProvider) {
                void treeContentProvider;
                ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)iContentProvider;
                ITreeContentProvider cfr_ignored_0 = (ITreeContentProvider)iContentProvider;
                Object[] topElements = treeContentProvider.getElements(this.input);
                if (topElements != null) {
                    int work = topElements.length;
                    Object[] objectArray = topElements;
                    int n = topElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (treeContentProvider.hasChildren(element)) {
                            work += treeContentProvider.getChildren(element).length;
                        }
                        ++n2;
                    }
                    monitor.beginTask("Exporting to CSV (file: " + this.getFilePath() + ")", work);
                    monitor.subTask("exporting tree data...");
                    int tempWork = 0;
                    int workFloor = topElements.length / 100;
                    if (workFloor == 0) {
                        workFloor = 1;
                    }
                    Arrays.sort(topElements, this.comparator);
                    int i = 0;
                    while (i < topElements.length) {
                        this.dumpTreeData((ITreeContentProvider)treeContentProvider, topElements[i], "", i == topElements.length - 1, true);
                        if (++tempWork >= workFloor) {
                            if (monitor.isCanceled()) {
                                this.ps.close();
                                return;
                            }
                            monitor.worked(tempWork);
                            tempWork = 0;
                        }
                        ++i;
                    }
                    monitor.worked(tempWork);
                }
            } else {
                IContentProvider iContentProvider2 = this.contentProvider;
                if (iContentProvider2 instanceof IStructuredContentProvider) {
                    void structContentProvider;
                    IStructuredContentProvider topElements = (IStructuredContentProvider)iContentProvider2;
                    IStructuredContentProvider cfr_ignored_1 = (IStructuredContentProvider)iContentProvider2;
                    Object[] topElements2 = structContentProvider.getElements(this.input);
                    if (topElements2 != null) {
                        monitor.beginTask("Exporting to CSV (file: " + this.getFilePath() + ")", topElements2.length);
                        monitor.subTask("exporting table data...");
                        int tempWork = 0;
                        int workFloor = topElements2.length / 100;
                        if (workFloor == 0) {
                            workFloor = 1;
                        }
                        Arrays.sort(topElements2, this.comparator);
                        int n = 0;
                        while (n < topElements2.length) {
                            if (n < topElements2.length - 1) {
                                this.dumpNodeData(topElements2[n], this.csvChildMarker);
                            } else {
                                this.dumpNodeData(topElements2[n], this.csvLastChildMarker);
                            }
                            if (++tempWork >= workFloor) {
                                if (monitor.isCanceled()) {
                                    this.ps.close();
                                    return;
                                }
                                monitor.worked(tempWork);
                                tempWork = 0;
                            }
                            ++n;
                        }
                        monitor.worked(tempWork);
                    }
                }
            }
        }
        this.ps.close();
        monitor.done();
        IFile c = STSymbolManager.sharedInstance.findFileFromPath((IPath)new Path(this.getFilePath()));
        if (c != null) {
            try {
                c.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                STDataViewersActivator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private void initPrintStream(String filePath) {
        try {
            File outputFile = new File(filePath);
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            this.ps = new PrintStream(outputFile);
        }
        catch (IOException e) {
            IStatus s = Status.error((String)("Invalid file! Dumping to stdout...\n" + e.getMessage()), (Throwable)e);
            this.logStatus(s);
            this.ps = System.out;
        }
        catch (NullPointerException e) {
            IStatus s = Status.error((String)("File has not been set! Dumping to stdout...\n" + e.getMessage()), (Throwable)e);
            this.logStatus(s);
            this.ps = System.out;
        }
    }

    private void collectViewerParameters() {
        Display.getDefault().syncExec(() -> {
            Item[] unOrdColumns = this.stViewer.getColumns();
            Item[] columns = new Item[unOrdColumns.length];
            int[] columnOrder = this.stViewer.getColumnOrder();
            int i1 = 0;
            while (i1 < unOrdColumns.length) {
                columns[i1] = unOrdColumns[columnOrder[i1]];
                ++i1;
            }
            HashMap<Item, ISTDataViewersField> fieldsMap = new HashMap<Item, ISTDataViewersField>();
            Item[] itemArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                Item column = itemArray[n2];
                fieldsMap.put(column, (ISTDataViewersField)column.getData());
                ++n2;
            }
            this.comparator = new CSVDataComparator(this.stViewer.getTableSorter(), fieldsMap);
            if (!this.showHiddenColumns) {
                int[] columnsState = this.stViewer.getHideShowManager().getColumnsState();
                ArrayList<Item> enabledColumns = new ArrayList<Item>();
                int i2 = 0;
                while (i2 < columnsState.length) {
                    if (columnsState[columnOrder[i2]] == 1) {
                        enabledColumns.add(columns[i2]);
                    }
                    ++i2;
                }
                columns = enabledColumns.toArray(new Item[enabledColumns.size()]);
            }
            this.fields = new ISTDataViewersField[columns.length];
            int i3 = 0;
            while (i3 < columns.length) {
                this.fields[i3] = (ISTDataViewersField)columns[i3].getData();
                ++i3;
            }
            this.input = this.stViewer.getViewer().getInput();
            this.contentProvider = this.stViewer.getViewer().getContentProvider();
            this.expandedElts = new ArrayList<Object>();
            if (!this.expandAll && this.stViewer.getViewer() instanceof TreeViewer) {
                TreeViewer tv = (TreeViewer)this.stViewer.getViewer();
                this.expandedElts = Arrays.asList(tv.getExpandedElements());
            }
        });
    }

    private void dumpColumnHeaders() {
        this.printPrefix("Hierarchy");
        int i = 0;
        while (i < this.fields.length) {
            this.ps.print(this.fields[i].getColumnHeaderText());
            this.printSeparator(i, this.fields.length);
            ++i;
        }
    }

    private void dumpTreeData(ITreeContentProvider tcp, Object element, String prefix, boolean isLastChild, boolean monitoring) {
        Object[] children;
        String childMarker = isLastChild ? this.csvLastChildMarker : this.csvChildMarker;
        boolean isLeaf = !tcp.hasChildren(element);
        String leafMarker = isLeaf ? this.csvLeafMarker : this.csvNodeMarker;
        this.dumpNodeData(element, String.valueOf(prefix) + childMarker + leafMarker);
        if ((this.expandAll || this.expandedElts.contains(element)) && !isLeaf && (children = tcp.getChildren(element)) != null) {
            int tempWork = 0;
            int workFloor = children.length / 100;
            if (workFloor == 0) {
                workFloor = 1;
            }
            Arrays.sort(children, this.comparator);
            int i = 0;
            while (i < children.length) {
                String prefixAdd = isLastChild ? this.csvNoChildLink : this.csvChildLink;
                this.dumpTreeData(tcp, children[i], String.valueOf(prefix) + prefixAdd, i == children.length - 1, false);
                if (this.monitor != null && monitoring && ++tempWork >= workFloor) {
                    this.monitor.worked(tempWork);
                    tempWork = 0;
                }
                ++i;
            }
            if (this.monitor != null && monitoring && tempWork > 0) {
                this.monitor.worked(tempWork);
            }
        }
    }

    private void dumpNodeData(Object element, String prefix) {
        int i = 0;
        while (i < this.fields.length) {
            this.printNode(i, prefix, this.getText(i, element));
            this.printSeparator(i, this.fields.length);
            ++i;
        }
    }

    private void printNode(int col, String prefix, String text) {
        if (col == 0) {
            this.printPrefix(prefix);
        }
        this.ps.print(text);
    }

    private void printPrefix(String prefix) {
        if (this.exportTreePrefix) {
            this.ps.print(prefix);
            this.ps.print(this.csvSeparator);
        }
    }

    private void printSeparator(int i, int length) {
        if (i == length - 1) {
            this.ps.print("\n");
        } else {
            this.ps.print(this.csvSeparator);
        }
    }

    private String getText(int i, Object obj) {
        return this.fields[i].getValue(obj);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getCSVSeparator() {
        return this.csvSeparator;
    }

    public String getCSVChildMarker() {
        return this.csvChildMarker;
    }

    public String getCSVLastChildMarker() {
        return this.csvLastChildMarker;
    }

    public String getCSVChildLink() {
        return this.csvChildLink;
    }

    public String getCSVNoChildLink() {
        return this.csvNoChildLink;
    }

    public String getCSVLeafMarker() {
        return this.csvLeafMarker;
    }

    public String getCSVNodeMarker() {
        return this.csvNodeMarker;
    }

    public boolean getExpandAll() {
        return this.expandAll;
    }

    public boolean getShowHiddenColumns() {
        return this.showHiddenColumns;
    }

    public boolean getExportTreePrefix() {
        return this.exportTreePrefix;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setCSVSeparator(String separator) {
        this.csvSeparator = separator;
    }

    public void setCSVChildMarker(String childMarker) {
        this.csvChildMarker = childMarker;
    }

    public void setCSVLastChildMarker(String lastChildMarker) {
        this.csvLastChildMarker = lastChildMarker;
    }

    public void setCSVChildLink(String childLink) {
        this.csvChildLink = childLink;
    }

    public void setCSVNoChildLink(String noChildLink) {
        this.csvNoChildLink = noChildLink;
    }

    public void setCSVLeafMarker(String leafMarker) {
        this.csvLeafMarker = leafMarker;
    }

    public void setCSVNodeMarker(String nodeMarker) {
        this.csvNodeMarker = nodeMarker;
    }

    public void setExpandAll(boolean expandAll) {
        this.expandAll = expandAll;
    }

    public void setShowHiddenColumns(boolean showHiddenColumns) {
        this.showHiddenColumns = showHiddenColumns;
    }

    public void setExportTreePrefix(boolean exportTreePrefix) {
        this.exportTreePrefix = this.isTreeViewerExporter() ? exportTreePrefix : false;
    }

    public boolean isTreeViewerExporter() {
        return this.stViewer instanceof AbstractSTTreeViewer;
    }

    private static class CSVDataComparator
    extends STDataViewersComparator {
        private final Map<Item, ISTDataViewersField> fieldsMap;

        public CSVDataComparator(STDataViewersComparator other, Map<Item, ISTDataViewersField> fieldsMap) {
            super(other);
            this.fieldsMap = fieldsMap;
        }

        @Override
        protected ISTDataViewersField getField(Item column) {
            return this.fieldsMap.get(column);
        }
    }
}

