/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerContentProvider;

public class LabelProviderUtils {
    public static final String CREATION_DATE_PATTERN = "yyyy-MM-dd";
    public static final String FINISHED_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.sssz";

    public static <K, V> Object reduce(Map<K, List<V>> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (Map.Entry<K, List<V>> entry : elements.entrySet()) {
            result.put(entry.getKey(), LabelProviderUtils.reduce(entry.getValue()));
        }
        return result;
    }

    public static Object reduce(Set<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.toArray()[0];
        }
        return elements.toArray();
    }

    public static Object reduce(List<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return elements;
    }

    public static String toCreatedDate(long created) {
        return LabelProviderUtils.toDate(created, CREATION_DATE_PATTERN);
    }

    public static String toCreatedDate(Date created) {
        return LabelProviderUtils.toDate(created, CREATION_DATE_PATTERN);
    }

    public static String toFinishedDate(Date finished) {
        return LabelProviderUtils.toDate(finished, FINISHED_DATE_PATTERN);
    }

    public static String toDate(Long date, String pattern) {
        long millis = Long.valueOf(date) * 1000L;
        Date d = new Date(millis);
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(d);
    }

    public static String toDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String containerPortMappingToString(IDockerPortMapping portMapping) {
        StringBuilder mappingBuffer = new StringBuilder();
        if (portMapping.getIp() != null && portMapping.getPublicPort() != 0) {
            mappingBuffer.append(portMapping.getIp()).append(':').append(portMapping.getPublicPort()).append("->");
        }
        mappingBuffer.append(portMapping.getPrivatePort()).append('/').append(portMapping.getType());
        return mappingBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        Object object = value;
        if (object instanceof IDockerPortBinding) {
            void binding;
            IDockerPortBinding iDockerPortBinding = (IDockerPortBinding)object;
            IDockerPortBinding cfr_ignored_0 = (IDockerPortBinding)object;
            String hostIp = binding.hostIp() == null || binding.hostIp().isEmpty() ? "<unspecified>" : binding.hostIp();
            String hostPort = binding.hostPort() == null || binding.hostPort().isEmpty() ? "<unspecified>" : binding.hostPort();
            return hostIp + ':' + hostPort;
        }
        return value.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static StyledString getStyledText(Object element) {
        Object object = element;
        if (object instanceof IStructuredSelection) {
            void sse;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)object;
            return LabelProviderUtils.getStyledText(sse.getFirstElement());
        }
        if (element instanceof IDockerConnection) {
            return LabelProviderUtils.getStyledText((IDockerConnection)element);
        }
        if (element instanceof DockerExplorerContentProvider.DockerImagesCategory) {
            return new StyledString(DVMessages.getString("DockerImagesCategory.label"));
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainersCategory) {
            return new StyledString(DVMessages.getString("DockerContainersCategory.label"));
        }
        if (element instanceof IDockerContainer) {
            return LabelProviderUtils.getStyledText((IDockerContainer)element);
        }
        if (element instanceof IDockerImage) {
            return LabelProviderUtils.getStyledText((IDockerImage)element);
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerPortMappingsCategory) {
            return new StyledString(DVMessages.getString("DockerContainerPortMappingsCategory.label"));
        }
        if (element instanceof IDockerPortMapping) {
            return LabelProviderUtils.getStyledText((IDockerPortMapping)element);
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerVolumesCategory) {
            return new StyledString(DVMessages.getString("DockerContainerVolumesCategory.label"));
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerVolume) {
            return LabelProviderUtils.getStyledText((DockerExplorerContentProvider.DockerContainerVolume)element);
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerLinksCategory) {
            return new StyledString(DVMessages.getString("DockerContainerLinksCategory.label"));
        }
        if (element instanceof DockerExplorerContentProvider.DockerContainerLink) {
            return LabelProviderUtils.getStyledText((DockerExplorerContentProvider.DockerContainerLink)element);
        }
        if (element instanceof String) {
            return new StyledString((String)element);
        }
        if (element instanceof DockerExplorerContentProvider.LoadingStub) {
            return new StyledString(DVMessages.getString("Loading.label"));
        }
        return null;
    }

    public static StyledString getStyledText(DockerExplorerContentProvider.DockerContainerLink containerLink) {
        StyledString styledString = new StyledString(containerLink.getContainerName()).append(" (" + containerLink.getContainerAlias() + ")", StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    public static StyledString getStyledText(DockerExplorerContentProvider.DockerContainerVolume containerVolume) {
        StyledString styledString = new StyledString();
        String hostPath = containerVolume.getHostPath();
        if (containerVolume.getHostPath() != null && containerVolume.getContainerPath() != null) {
            styledString.append(hostPath).append(" -> ").append(containerVolume.getContainerPath());
        } else if (containerVolume.getHostPath() == null && containerVolume.getContainerPath() != null) {
            styledString.append(containerVolume.getContainerPath());
        }
        if (containerVolume.getFlags() != null) {
            styledString.append(" (" + containerVolume.getFlags() + ")", StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }

    public static StyledString getStyledText(IDockerPortMapping mapping) {
        StyledString styledString = new StyledString();
        styledString.append(String.valueOf(mapping.getIp()) + ":" + mapping.getPublicPort()).append(" -> ").append(Integer.toString(mapping.getPrivatePort())).append(" (" + mapping.getType() + ")", StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    public static StyledString getStyledText(IDockerContainer dockerContainer) {
        StyledString styledString = new StyledString();
        styledString.append(dockerContainer.name());
        if (dockerContainer.image() != null && !dockerContainer.image().isEmpty()) {
            styledString.append(" (" + dockerContainer.image() + ")", StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }

    public static StyledString getStyledText(IDockerConnection connection) {
        String connectionName = connection.getName() != null && !connection.getName().isEmpty() ? connection.getName() : DVMessages.getString("Connection.unnamed");
        StyledString styledString = new StyledString();
        styledString.append(connectionName);
        if (connection.getUri() != null && !connection.getUri().isEmpty()) {
            styledString.append(" (" + connection.getUri() + ")", StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }

    public static StyledString getStyledText(IDockerImage dockerImage) {
        StyledString result = new StyledString(dockerImage.repo());
        if (!dockerImage.tags().isEmpty()) {
            ArrayList tags = new ArrayList(dockerImage.tags());
            Collections.sort(tags);
            result.append(":");
            result.append(tags.stream().collect(Collectors.joining(", ")), StyledString.COUNTER_STYLER);
        }
        result.append(" (", StyledString.QUALIFIER_STYLER).append(((DockerImage)dockerImage).shortId(), StyledString.QUALIFIER_STYLER).append(')', StyledString.QUALIFIER_STYLER);
        return result;
    }
}

