/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenArtifactIdentifier;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.pde.core.IPluginSourcePathLocator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.TargetPlatformService;

public class MavenPluginSourcePathLocator
implements IPluginSourcePathLocator {
    public IPath locateSource(IPluginBase plugin) {
        File file;
        String installLocation = plugin.getModel().getInstallLocation();
        if (installLocation != null && (file = new File(installLocation)).isFile()) {
            java.nio.file.Path location;
            Collection identify;
            String ext = FilenameUtils.getExtension((String)installLocation);
            String baseName = FilenameUtils.getBaseName((String)installLocation);
            File localFile = new File(file.getParentFile(), String.valueOf(baseName) + "-sources." + ext);
            if (localFile.isFile()) {
                return new Path(localFile.getAbsolutePath());
            }
            ArtifactKey artifact = this.aquireFromTargetState(file);
            if (artifact == null && (identify = MavenArtifactIdentifier.identify((File)file)).size() == 1) {
                artifact = (ArtifactKey)identify.iterator().next();
            }
            if ((location = MavenArtifactIdentifier.resolveSourceLocation((ArtifactKey)artifact, null)) != null) {
                return new Path(location.toFile().getAbsolutePath());
            }
        }
        return null;
    }

    private ArtifactKey aquireFromTargetState(File file) {
        ITargetPlatformService platformService = TargetPlatformService.getDefault();
        try {
            ITargetDefinition targetDefinition = platformService.getWorkspaceTargetDefinition();
            if (targetDefinition != null) {
                ITargetLocation[] iTargetLocationArray = targetDefinition.getTargetLocations();
                int n = iTargetLocationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITargetLocation location = iTargetLocationArray[n2];
                    if (location instanceof MavenTargetLocation var8_9 && (lookupArtifact = targetLocation.lookupArtifact(file)) != null) {
                        return new ArtifactKey(lookupArtifact);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }
}

