/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimatableScrollPane;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextFlowEx;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.richtext.painter.ResourceHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CornerBentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.HTMLCommentParser;
import org.eclipse.papyrus.uml.diagram.common.figure.node.HTMLRenderer;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.papyrus.uml.diagram.common.parser.HTMLCleaner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLCornerBentFigure
extends CornerBentFigure
implements ILabelFigure,
IMultilineEditableFigure {
    private static final String FONT_SIZE_SPAN = "font-size: ";
    private static final String FONT_FAMILY = "font-family: ";
    private static final String COLOR_RGB = "color: rgb(";
    public static final String EXTENSION_ID = "org.eclipse.papyrus.uml.diagram.common.htmlRendererContributor";
    protected boolean useLocalCoordinates = false;
    static final Color THIS_BACK = new Color(null, 248, 249, 214);
    private static final FontData DEFAULT_FONT = new FontData("Arial", 8, 0);
    private static final FontData CODE_SAMPLE_FONT = new FontData("Lucida Console", 8, 0);
    private static final FontData QUOTE_FONT = new FontData("Monotype Corsiva", 10, 0);
    private static final String FONT_NAME = "face";
    private static final String FONT_SIZE = "size";
    protected FlowPage page;
    protected AnimatableScrollPane contentPane;
    protected HTMLRenderer htmlRenderer;
    protected Boolean useHtmlRenderer = null;
    protected int oldWidth = 0;
    protected int oldHeight = 0;
    private final List<List<Styles>> myStyles = new ArrayList<List<Styles>>();
    private FontData currentFontData;
    private String text = "";
    private Stack<Color> colors = new Stack();
    private Set<FontData> cachedFontDatas = new HashSet<FontData>();
    private HTMLLayoutListener htmlLayoutListener;

    public HTMLCornerBentFigure() {
        this.createContents();
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }

    protected void createContents() {
        if (!this.useHtmlRenderer()) {
            this.page = new FlowPage();
            this.page.setForegroundColor(this.getForegroundColor());
            this.add((IFigure)this.page);
        } else {
            if (this.htmlRenderer == null) {
                IConfigurationElement[] config;
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    if ("contributor".equals(e.getName())) {
                        try {
                            Object instance = e.createExecutableExtension("contributor");
                            if (instance instanceof HTMLRenderer) {
                                this.htmlRenderer = (HTMLRenderer)instance;
                                break;
                            }
                        }
                        catch (Exception ex) {
                            Activator.log.warn("Invalid html renderer contribution from: " + e.getContributor());
                        }
                    }
                    ++n2;
                }
            }
            IFigure htmlContent = null;
            if (this.htmlRenderer != null) {
                htmlContent = this.htmlRenderer.getFigure();
            }
            if (htmlContent != null) {
                this.add(htmlContent);
                this.addHTMLLayoutListener();
            } else {
                this.page = new FlowPage();
                this.page.setForegroundColor(this.getForegroundColor());
                this.add((IFigure)this.page);
            }
        }
    }

    private void addHTMLLayoutListener() {
        if (this.htmlLayoutListener == null) {
            this.htmlLayoutListener = new HTMLLayoutListener();
            this.addLayoutListener((LayoutListener)this.htmlLayoutListener);
        }
    }

    private void paintHTML() {
        if (this.htmlRenderer != null) {
            try {
                if (this.isVisible() && Display.getDefault() != null) {
                    int width = this.getClientArea().width;
                    int height = this.getClientArea().height;
                    if (width > 0 && height > 0) {
                        this.htmlRenderer.paintHTML(this.text, width, height, 0, 0);
                    }
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected boolean useLocalCoordinates() {
        return this.useLocalCoordinates;
    }

    public HTMLCornerBentFigure getCornerBentFigure() {
        return this;
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setIcon(Image icon) {
    }

    @Override
    public void setText(String text) {
        if (HTMLCornerBentFigure.equals(text, this.text)) {
            return;
        }
        this.text = text;
        if (!this.useHtmlRenderer() || this.htmlRenderer == null) {
            if (this.page != null) {
                this.page.removeAll();
                this.currentFontData = new FontData("Wingdings", 8, 0);
                this.generateBlockForText(text, this.page);
            }
        } else {
            this.paintHTML();
        }
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2.equals(s1);
    }

    protected void generateBlockForText(String text, FlowPage page) {
        NodeList nodeList = this.generateNodeList("<body>" + text + "</body>");
        this.myStyles.clear();
        if (nodeList.getLength() > 0) {
            this.generateBlocksFromNodeList(nodeList, (BlockFlow)page, new Stack<Styles>());
        } else {
            TextFlowEx textFlow = new TextFlowEx(text);
            page.add((IFigure)textFlow);
        }
    }

    protected void generateBlocksFromNodeList(NodeList nodeList, BlockFlow parentFlow, Stack<Styles> parentStyles) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            short nodeType = node.getNodeType();
            if (nodeType == 3) {
                String text = HTMLCleaner.cleanHTMLTags(node.getNodeValue());
                if (text != null && !text.trim().isEmpty()) {
                    ArrayList<Styles> styles = Collections.list(parentStyles.elements());
                    this.myStyles.add(styles);
                    this.generateTextFromTextNode(text, parentFlow, styles);
                }
            } else {
                try {
                    switch (HTMLTags.valueOf(nodeName)) {
                        case body: {
                            this.generateBlocksFromBodyNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case h3: {
                            this.generateBlocksFromH3Node(node, parentFlow, parentStyles);
                            break;
                        }
                        case h4: {
                            this.generateBlocksFromH4Node(node, parentFlow, parentStyles);
                            break;
                        }
                        case h5: {
                            this.generateBlocksFromH5Node(node, parentFlow, parentStyles);
                            break;
                        }
                        case strong: 
                        case b: {
                            this.generateBlocksFromStrongNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case em: {
                            this.generateBlocksFromItalicNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case s: {
                            this.generateBlocksFromStrikeThroughNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case u: {
                            this.generateBlocksFromUnderlineNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case sub: {
                            break;
                        }
                        case sup: {
                            break;
                        }
                        case blockquote: {
                            break;
                        }
                        case table: {
                            break;
                        }
                        case p: {
                            this.generateBlocksFromParagraphNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case br: {
                            this.generateBlocksFromBRNode(node, parentFlow);
                            break;
                        }
                        case font: {
                            this.generateBlocksForFontNode(node, parentFlow, parentStyles);
                            break;
                        }
                        case span: {
                            this.generateBlocksForSpanNode(node, parentFlow, parentStyles);
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    protected void generateBlocksForSpanNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        NamedNodeMap attributes = node.getAttributes();
        Node namedItem = attributes.getNamedItem("style");
        String nodeValue = namedItem.getNodeValue();
        if (nodeValue.startsWith(COLOR_RGB)) {
            this.colors.push(ResourceHelper.getColor((String)nodeValue));
            styles.push(Styles.color);
            this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
            styles.pop();
            this.colors.pop();
        } else if (nodeValue.startsWith(FONT_FAMILY)) {
            String fontString = nodeValue.substring(FONT_FAMILY.length());
            fontString = fontString.substring(0, fontString.length() - 1);
            String fontName = fontString.split(",")[0];
            String oldFont = Styles.font.getData().get(FONT_NAME) != null ? (String)Styles.font.getData().get(FONT_NAME) : "Segoe UI";
            Styles.font.getData().put(FONT_NAME, fontName);
            styles.push(Styles.font);
            this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
            Styles.font.getData().put(FONT_NAME, oldFont);
            styles.pop();
        } else if (nodeValue.startsWith(FONT_SIZE_SPAN)) {
            String fontSizeString = nodeValue.substring(FONT_SIZE_SPAN.length());
            fontSizeString = fontSizeString.substring(0, fontSizeString.length() - 1).replace("px", "");
            int fontSize = Integer.parseInt(fontSizeString);
            int oldSize = Styles.font.getData().get(FONT_SIZE) != null ? (Integer)Styles.font.getData().get(FONT_SIZE) : -1;
            Styles.font.getData().put(FONT_SIZE, (fontSize - 4) / 2);
            styles.push(Styles.font);
            this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
            if (-1 != oldSize) {
                Styles.font.getData().put(FONT_SIZE, oldSize);
            } else {
                Styles.font.getData().remove(FONT_SIZE);
            }
            styles.pop();
        } else {
            this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        }
    }

    protected void generateBlocksFromUnderlineNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.underline);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    public void setFont(Font f) {
        if (this.page != null) {
            super.setFont(f);
            List<TextFlow> textFlowList = this.findTextFlowChildList((IFigure)this.page);
            int i = 0;
            for (TextFlow nextTextFlow : textFlowList) {
                if (i == this.myStyles.size()) break;
                nextTextFlow.setFont(this.calculateCurrentFont(this.myStyles.get(i)));
                ++i;
            }
        }
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (!(this.useHtmlRenderer() && this.htmlRenderer != null || this.page == null)) {
            this.page.removeAll();
            this.generateBlockForText(this.text, this.page);
        }
    }

    private List<TextFlow> findTextFlowChildList(IFigure parent) {
        ArrayList<TextFlow> result = new ArrayList<TextFlow>();
        for (Object nextFigure : parent.getChildren()) {
            if (!(nextFigure instanceof TextFlow)) {
                result.addAll(this.findTextFlowChildList((IFigure)nextFigure));
                continue;
            }
            result.add((TextFlow)nextFigure);
        }
        return result;
    }

    protected void generateTextFromTextNode(String text, BlockFlow parentFlow, List<Styles> styles) {
        TextFlowEx textFlow = new TextFlowEx(text);
        textFlow.setTextUnderline(this.getUnderLineFromStyles(styles));
        textFlow.setTextStrikeThrough(this.getStrikeThroughFromStyles(styles));
        textFlow.setFont(this.calculateCurrentFont(styles));
        textFlow.setForegroundColor(this.calculateCurrentForeground(styles));
        parentFlow.add((IFigure)textFlow);
    }

    private Color calculateCurrentForeground(List<Styles> styles) {
        Color result = null;
        for (Styles style : styles) {
            switch (style) {
                case color: {
                    result = (Color)this.colors.firstElement();
                    break;
                }
            }
        }
        return result != null ? result : this.getForegroundColor();
    }

    private Font calculateCurrentFont(List<Styles> styles) {
        return this.composeFontWithStyles(this.getDefaultFontData(), styles);
    }

    private boolean getUnderLineFromStyles(List<Styles> styles) {
        boolean result = false;
        for (Styles style : styles) {
            switch (style) {
                case underline: {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private boolean getStrikeThroughFromStyles(List<Styles> styles) {
        boolean result = false;
        for (Styles style : styles) {
            switch (style) {
                case strikeThrough: {
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private FontData getDefaultFontData() {
        boolean quote = false;
        boolean codeSample = false;
        if (codeSample) {
            return CODE_SAMPLE_FONT;
        }
        if (quote) {
            return QUOTE_FONT;
        }
        FontData fromDefaultFigure = this.getCurrentFigureFontData();
        if (fromDefaultFigure == null) {
            return DEFAULT_FONT;
        }
        return fromDefaultFigure;
    }

    private FontData getCurrentFigureFontData() {
        if (this.getFont() == null) {
            return null;
        }
        if (this.getFont().getFontData() == null || this.getFont().getFontData().length == 0) {
            return null;
        }
        return this.getFont().getFontData()[0];
    }

    private Font composeFontWithStyles(FontData defaultFontData, List<Styles> styles) {
        if (styles == null || styles.isEmpty()) {
            return (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)defaultFontData));
        }
        FontData defaultFontDataCopy = FontDescriptor.copy((FontData)defaultFontData);
        int defaultStyle = defaultFontDataCopy.getStyle();
        boolean quote = false;
        boolean codeSample = false;
        for (Styles style : styles) {
            switch (style) {
                case italic: {
                    defaultStyle |= 2;
                    break;
                }
                case strong: {
                    defaultStyle |= 1;
                    break;
                }
                case quote: {
                    quote = true;
                    break;
                }
                case code: {
                    codeSample = true;
                    break;
                }
                case font: {
                    if (Styles.font.getData().get(FONT_NAME) != null) {
                        defaultFontDataCopy.setName((String)Styles.font.getData().get(FONT_NAME));
                    }
                    if (Styles.font.getData().get(FONT_SIZE) == null) break;
                    defaultFontDataCopy.setHeight((Integer)Styles.font.getData().get(FONT_SIZE) * 2 + 4);
                    break;
                }
            }
        }
        defaultFontDataCopy.setStyle(defaultStyle);
        if (codeSample) {
            defaultFontDataCopy = CODE_SAMPLE_FONT;
        } else if (quote) {
            defaultFontDataCopy = QUOTE_FONT;
        }
        return (Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)defaultFontDataCopy));
    }

    protected void generateBlocksFromStrongNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.strong);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    protected void generateBlocksFromItalicNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.italic);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    protected void generateBlocksFromStrikeThroughNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.strikeThrough);
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        styles.pop();
    }

    protected void generateBlocksForFontNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        Node fontNameNode = node.getAttributes().getNamedItem(FONT_NAME);
        Node fontSizeNode = node.getAttributes().getNamedItem(FONT_SIZE);
        String oldFont = "";
        int oldSize = 8;
        if (fontNameNode != null) {
            String fontName = fontNameNode.getNodeValue();
            oldFont = Styles.font.getData().get(FONT_NAME) != null ? (String)Styles.font.getData().get(FONT_NAME) : "Arial";
            Styles.font.getData().put(FONT_NAME, fontName);
            styles.push(Styles.font);
        }
        if (fontSizeNode != null) {
            int fontSize = Integer.parseInt(fontSizeNode.getNodeValue());
            oldSize = Styles.font.getData().get(FONT_SIZE) != null ? (Integer)Styles.font.getData().get(FONT_SIZE) : 2;
            Styles.font.getData().put(FONT_SIZE, fontSize);
            styles.push(Styles.font);
        }
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, parentFlow, styles);
        if (fontNameNode != null) {
            Styles.font.getData().put(FONT_NAME, oldFont);
            styles.pop();
        }
        if (fontSizeNode != null) {
            Styles.font.getData().put(FONT_SIZE, oldSize);
            styles.pop();
        }
    }

    protected void generateBlocksFromH3Node(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.header3);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        styles.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromH4Node(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.header4);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        styles.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromH5Node(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        styles.push(Styles.header5);
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        styles.pop();
        parentFlow.add((IFigure)blockFlow);
    }

    private void debug(NodeList childNodes) {
        int i = 0;
        while (i < childNodes.getLength()) {
            System.err.println("[" + i + "] " + childNodes.item(i).getNodeName());
            ++i;
        }
    }

    protected void generateBlocksFromBodyNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromParagraphNode(Node node, BlockFlow parentFlow, Stack<Styles> styles) {
        BlockFlow blockFlow = new BlockFlow();
        NamedNodeMap attributes = node.getAttributes();
        Node classNode = attributes.getNamedItem("class");
        boolean hasToPop = false;
        if (classNode != null) {
            String classNodeValue = classNode.getNodeValue();
            if ("codeSample".equals(classNodeValue)) {
                hasToPop = true;
                styles.push(Styles.code);
            } else if ("quote".equals(classNodeValue)) {
                styles.push(Styles.quote);
                hasToPop = true;
            }
        }
        NodeList childrenNodes = node.getChildNodes();
        this.generateBlocksFromNodeList(childrenNodes, blockFlow, styles);
        if (hasToPop) {
            styles.pop();
        }
        parentFlow.add((IFigure)blockFlow);
    }

    protected void generateBlocksFromBRNode(Node node, BlockFlow parentFlow) {
        BlockFlow blockFlow = new BlockFlow();
        parentFlow.add((IFigure)blockFlow);
    }

    protected NodeList generateNodeList(String text) {
        return HTMLCommentParser.parse(text);
    }

    @Override
    public Point getEditionLocation() {
        return this.getBounds().getTopLeft();
    }

    private boolean useHtmlRenderer() {
        if (this.useHtmlRenderer == null) {
            this.useHtmlRenderer = false;
            IPreferenceStore store = org.eclipse.papyrus.infra.ui.Activator.getDefault().getPreferenceStore();
            if (store != null) {
                this.useHtmlRenderer = store.getBoolean("useHtmlRenderer");
            }
        }
        return this.useHtmlRenderer;
    }

    private class HTMLLayoutListener
    extends LayoutListener.Stub {
        private HTMLLayoutListener() {
        }

        public void postLayout(IFigure container) {
            if (HTMLCornerBentFigure.this.oldWidth != container.getClientArea().width || HTMLCornerBentFigure.this.oldHeight != container.getClientArea().height) {
                HTMLCornerBentFigure.this.oldWidth = container.getClientArea().width;
                HTMLCornerBentFigure.this.oldHeight = container.getClientArea().height;
                HTMLCornerBentFigure.this.paintHTML();
            }
        }
    }

    protected static enum HTMLTags {
        body(""),
        h3(""),
        h4(""),
        h5(""),
        strong(""),
        b(""),
        em(""),
        s(""),
        u(""),
        sub(""),
        sup(""),
        blockquote(""),
        table(""),
        p(""),
        br(""),
        font(""),
        span("");

        protected String data;

        private HTMLTags(String data) {
            this.data = data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getData() {
            return this.data;
        }
    }

    protected static enum Styles {
        strong,
        header3,
        header4,
        header5,
        underline,
        italic,
        code,
        subscript,
        supscript,
        quote,
        font(new HashMap<String, Object>()),
        strikeThrough,
        color;

        private Map<String, Object> data;

        private Styles() {
            this.data = null;
        }

        private Styles(Map<String, Object> data) {
            this.data = data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

