/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.properties;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.core.sourceform.SourceFormProperties;
import org.eclipse.photran.internal.ui.properties.UIMessages;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FortranSourceFormEditor
extends FieldEditor {
    private static final int COMBO_WIDTH = 250;
    private static final int DEFAULT_COMBO_HEIGHT = 17;
    private static final int COMBO_VERTICAL_PADDING = 5;
    private Table table;
    private Listener measureItemListener = null;

    public FortranSourceFormEditor(String propertyName, String labelText, Composite parent) {
        this.init(propertyName, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.createTableControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 64;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gd);
    }

    private void createTableControl(Composite parent) {
        this.table = new Table(parent, 2560);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int i = 0;
        while (i < 2) {
            new TableColumn(this.table, 0);
            ++i;
        }
        this.table.getColumn(0).setText(UIMessages.FortranSourceFormEditor_FileNameOrExtensionColumnLabel);
        this.table.getColumn(1).setText(UIMessages.FortranSourceFormEditor_SourceFormColumnLabel);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doLoad() {
        if (this.table != null) {
            this.populateTable(SourceFormProperties.parseValue((String)this.getPreferenceStore().getString(this.getPreferenceName())));
        }
    }

    protected void doLoadDefault() {
        if (this.table != null) {
            this.populateTable(SourceFormProperties.parseValue((String)this.getPreferenceStore().getDefaultString(this.getPreferenceName())));
        }
    }

    private void populateTable(Map<String, String> prefValue) {
        this.table.removeAll();
        Control[] controlArray = this.table.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Combo) {
                c.dispose();
            }
            ++n2;
        }
        Combo combo = null;
        for (String spec : prefValue.keySet()) {
            combo = this.addItem(spec, prefValue.get(spec));
        }
        this.table.getColumn(0).pack();
        this.table.getColumn(1).setWidth(250);
        if (this.measureItemListener == null) {
            this.table.addListener(41, this.createMeasureItemListener(combo));
        }
    }

    private Listener createMeasureItemListener(Combo combo) {
        final int comboHeight = combo == null ? 17 : Math.max(combo.getSize().y, 17);
        this.measureItemListener = new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, comboHeight + 5);
            }
        };
        return this.measureItemListener;
    }

    private Combo addItem(String spec, String sourceFormDescription) {
        final TableItem item = new TableItem(this.table, 0);
        item.setText(new String[]{spec, sourceFormDescription});
        final Combo combo = new Combo((Composite)this.table, 0x800800);
        for (String sourceForm : SourceForm.allSourceForms()) {
            combo.add(sourceForm);
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                item.setText(1, combo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        combo.setText(sourceFormDescription);
        int index = combo.indexOf(sourceFormDescription);
        if (index >= 0) {
            combo.select(index);
        }
        TableEditor editor = new TableEditor(this.table);
        editor.grabVertical = true;
        editor.grabHorizontal = true;
        editor.minimumWidth = 250;
        editor.setEditor((Control)combo, item, 1);
        return combo;
    }

    protected void doStore() {
        TreeMap<String, String> prefValue = new TreeMap<String, String>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            prefValue.put(item.getText(0), item.getText(1));
            ++n2;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), SourceFormProperties.unparseValue(prefValue));
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }
}

