/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.core.utils.PropertyChangeProvider;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.FsClipboardTransfer;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;
import org.eclipse.ui.PlatformUI;

public class FsClipboard
extends PropertyChangeProvider {
    final Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
    final FsClipboardCache clipboardCache = new FsClipboardCache();

    public boolean isCutOp() {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(FsClipboard.this.clipboard.getContents((Transfer)FsClipboardTransfer.getInstance()));
            }
        };
        this.exec(runnable);
        FsClipboardContent content = (FsClipboardContent)object.get();
        return content != null && content.operation == 0;
    }

    public boolean isCopyOp() {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(FsClipboard.this.clipboard.getContents((Transfer)FsClipboardTransfer.getInstance()));
            }
        };
        this.exec(runnable);
        FsClipboardContent content = (FsClipboardContent)object.get();
        return content != null && content.operation == 1;
    }

    public boolean isEmpty() {
        if (this.clipboardCache.isCacheValid()) {
            return this.clipboardCache.isClipboardEmpty();
        }
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(FsClipboard.this.clipboard.getContents((Transfer)FsClipboardTransfer.getInstance()));
            }
        };
        this.exec(runnable);
        FsClipboardContent content = (FsClipboardContent)object.get();
        boolean empty = content == null || content.files.isEmpty();
        this.clipboardCache.setClipboardEmpty(empty);
        return empty;
    }

    public List<IFSTreeNode> getFiles() {
        final AtomicReference object = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                object.set(FsClipboard.this.clipboard.getContents((Transfer)FsClipboardTransfer.getInstance()));
            }
        };
        this.exec(runnable);
        FsClipboardContent content = (FsClipboardContent)object.get();
        return content.files;
    }

    public void cutFiles(List<IFSTreeNode> files) {
        Assert.isNotNull(files);
        final FsClipboardContent content = new FsClipboardContent(0, files);
        final FsClipboardTransfer transfer = FsClipboardTransfer.getInstance();
        transfer.setContent(content);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FsClipboard.this.clipboardCache.invalidateCache();
                FsClipboard.this.clipboard.setContents(new Object[]{content}, new Transfer[]{transfer});
                PropertyChangeEvent event = new PropertyChangeEvent(this, "cut", null, null);
                FsClipboard.this.firePropertyChange(event);
            }
        };
        this.exec(runnable);
    }

    public void copyFiles(List<IFSTreeNode> files) {
        Assert.isNotNull(files);
        final FsClipboardContent content = new FsClipboardContent(1, files);
        final FsClipboardTransfer transfer = FsClipboardTransfer.getInstance();
        transfer.setContent(content);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FsClipboard.this.clipboardCache.invalidateCache();
                FsClipboard.this.clipboard.setContents(new Object[]{content}, new Transfer[]{transfer});
                PropertyChangeEvent event = new PropertyChangeEvent(this, "copy", null, null);
                FsClipboard.this.firePropertyChange(event);
            }
        };
        this.exec(runnable);
    }

    public void clear() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FsClipboard.this.clipboardCache.invalidateCache();
                FsClipboard.this.clipboard.clearContents();
                PropertyChangeEvent event = new PropertyChangeEvent(this, "clear", null, null);
                FsClipboard.this.firePropertyChange(event);
            }
        };
        this.exec(runnable);
    }

    private void exec(Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            DisplayUtil.safeSyncExec((Runnable)runnable);
        }
    }

    public void dispose() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!FsClipboard.this.clipboard.isDisposed()) {
                    try {
                        FsClipboard.this.clipboard.dispose();
                    }
                    catch (SWTException sWTException) {
                        // empty catch block
                    }
                }
            }
        };
        this.exec(runnable);
    }

    public final Clipboard getSystemClipboard() {
        return this.clipboard;
    }

    private static class FsClipboardCache {
        private boolean cacheValid = false;
        private boolean clipboardEmpty = true;

        public boolean isCacheValid() {
            return this.cacheValid;
        }

        public void invalidateCache() {
            this.cacheValid = false;
        }

        public boolean isClipboardEmpty() {
            return this.clipboardEmpty;
        }

        public void setClipboardEmpty(boolean empty) {
            this.clipboardEmpty = empty;
            this.cacheValid = true;
        }
    }

    static class FsClipboardContent {
        public static final int CUT = 0;
        public static final int COPY = 1;
        public final int operation;
        public final List<IFSTreeNode> files;

        public FsClipboardContent(int operation, List<IFSTreeNode> files) {
            Assert.isTrue((operation == 0 || operation == 1 ? 1 : 0) != 0);
            this.operation = operation;
            Assert.isNotNull(files);
            this.files = files;
        }
    }
}

