/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.gef.GefMessages;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.SetAlignmentAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.SetGrabAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDimensionInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridImages;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class RowHeaderEditPart<C extends IControlInfo>
extends DimensionHeaderEditPart<C> {
    public RowHeaderEditPart(IGridLayoutInfo<C> layout, GridRowInfo<C> row, Figure containerFigure) {
        super(layout, row, containerFigure);
    }

    protected Figure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(IColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.right(), r.y);
                graphics.drawLine(r.x, r.bottom() - 1, r.right(), r.bottom() - 1);
                String title = "" + (1 + RowHeaderEditPart.this.m_dimension.getIndex());
                Dimension textExtents = graphics.getTextExtent(title);
                if (r.height < 3 + textExtents.height + 3) {
                    return;
                }
                int titleTop = r.y + (r.height - textExtents.height) / 2;
                int titleBottom = titleTop + textExtents.height;
                int x = r.x + (r.width - textExtents.width) / 2;
                graphics.setForegroundColor(IColorConstants.black);
                graphics.drawText(title, x, titleTop);
                try {
                    Integer alignmentValue = RowHeaderEditPart.this.m_dimension.getAlignment();
                    if (alignmentValue != null && titleTop - r.y > 13) {
                        int alignment = alignmentValue;
                        Image image = alignment == 128 ? this.getImage("top.gif") : (alignment == 0x1000000 ? this.getImage("center.gif") : (alignment == 1024 ? this.getImage("bottom.gif") : this.getImage("fill.gif")));
                        int y = r.y + 2;
                        this.drawCentered(graphics, image, y);
                    }
                    if (RowHeaderEditPart.this.m_dimension.getGrab() && titleBottom + 3 + 7 + 3 < r.bottom()) {
                        Image image = this.getImage("grow.gif");
                        this.drawCentered(graphics, image, r.bottom() - 3 - image.getBounds().height);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            private Image getImage(String name) {
                return GridImages.getImage("v/" + name);
            }

            private void drawCentered(Graphics graphics, Image image, int y) {
                int x = (this.getBounds().width - image.getBounds().width) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        int index = this.m_dimension.getIndex();
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval interval = gridInfo.getRowIntervals()[index];
        Rectangle bounds = new Rectangle(0, interval.begin(), ((GraphicalEditPart)this.getParent()).getFigure().getSize().width, interval.length() + 1);
        bounds.performTranslate(0, this.getOffset().y);
        this.getFigure().setBounds(bounds);
    }

    public void buildContextMenu(IMenuManager manager) {
        manager.add(new SetGrabAction(this, GefMessages.RowHeaderEditPart_grabExcessSpace, GridImages.getImageDescriptor("v/menu/grow.gif")));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_top, GridImages.getImageDescriptor("v/menu/top.gif"), 128));
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_center, GridImages.getImageDescriptor("v/menu/center.gif"), 0x1000000));
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_bottom, GridImages.getImageDescriptor("v/menu/bottom.gif"), 1024));
        manager.add(new SetAlignmentAction(this, GefMessages.RowHeaderEditPart_fill, GridImages.getImageDescriptor("h/menu/fill.gif"), 4));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new DimensionHeaderAction<C>(this, GefMessages.RowHeaderEditPart_delete, GridImages.getImageDescriptor("v/menu/delete.gif")){

            @Override
            protected void run(GridDimensionInfo<C> dimension) throws Exception {
                RowHeaderEditPart.this.m_layout.command_deleteRow(dimension.getIndex(), true);
            }
        });
    }
}

