/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core.configure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.autotools.core.configure.BinConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.ConfigureMessages;
import org.eclipse.cdt.internal.autotools.core.configure.ConfigureOptionCategory;
import org.eclipse.cdt.internal.autotools.core.configure.ConfigureTool;
import org.eclipse.cdt.internal.autotools.core.configure.FlagConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.FlagValueConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.InternalConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.MultiArgConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.StringConfigureOption;
import org.eclipse.cdt.internal.autotools.core.configure.VariableConfigureOption;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class AutotoolsConfiguration
implements IAConfiguration {
    private static Option[] configOpts = new Option[]{new Option("configure", 5), new Option("general", 0), new Option("configdir", 3), new Option("cache-file", "cache_file", 2), new Option("help", 1), new Option("no-create", "no_create", 1), new Option("quiet", 1), new Option("version", 1), new Option("platform", 0), new Option("host", 2), new Option("build", 2), new Option("target", 2), new Option("directories", 0), new Option("prefix", 2), new Option("exec-prefix", "exec_prefix", 2), new Option("libdir", 2), new Option("bindir", 2), new Option("sbindir", 2), new Option("includedir", 2), new Option("datadir", 2), new Option("sysconfdir", 2), new Option("infodir", 2), new Option("mandir", 2), new Option("srcdir", 2), new Option("localstatedir", 2), new Option("sharedstatedir", 2), new Option("libexecdir", 2), new Option("oldincludedir", 2), new Option("filenames", 0), new Option("program-prefix", "program_prefix", 2), new Option("program-suffix", "program_suffix", 2), new Option("program-transform-name", "program_transform_name", 2), new Option("cat_envvar", 0), new Option("env_vars", 8), new Option("features", 0), new Option("enable-maintainer-mode", "enable_maintainer_mode", 1), new Option("CFLAGS", "cflags", "CFLAGS|CXXFLAGS", 6), new Option("cflags-debug", "cflags_debug", 7), new Option("cflags-gprof", "cflags_gprof", 7), new Option("cflags-gcov", "cflags_gcov", 7), new Option("user", 4), new Option("autogen", "autogen", "autogen.sh", 5), new Option("options", 0), new Option("autogenOpts", 4)};
    private static Option[] toolList;
    private String id;
    private boolean isDirty;
    private boolean isParmsDirty;
    private IProject project;
    private Map<String, IConfigureOption> configOptions;
    private ArrayList<String> configParms = new ArrayList();

    public AutotoolsConfiguration(String name) {
        this(null, name, true);
    }

    public AutotoolsConfiguration(IProject project, String name) {
        this(project, name, true);
    }

    private AutotoolsConfiguration(IProject project, String name, boolean initialize) {
        this.id = name;
        this.project = project;
        this.configOptions = new HashMap<String, IConfigureOption>();
        if (initialize) {
            this.initConfigOptions();
        }
        this.isParmsDirty = true;
    }

    private void initConfigOptions() {
        ICConfigurationDescription cfgd;
        ArrayList<Option> tools = new ArrayList<Option>();
        FlagConfigureOption lastFlag = null;
        IConfiguration configuration = null;
        IBuildObjectProperties buildProperties = null;
        if (this.project != null && (configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)(cfgd = CoreModel.getDefault().getProjectDescription(this.project).getConfigurationById(this.id)))) != null) {
            buildProperties = configuration.getBuildProperties();
        }
        int i = 0;
        while (i < configOpts.length) {
            Option opt = configOpts[i];
            String defaultValue = opt.getDefaultValue();
            int type = opt.type;
            switch (type) {
                case 1: {
                    BinConfigureOption b = new BinConfigureOption(opt.name, opt.transformedName, this);
                    if (defaultValue != null) {
                        b.setValue(defaultValue);
                    }
                    this.configOptions.put(opt.name, b);
                    break;
                }
                case 2: {
                    StringConfigureOption s = new StringConfigureOption(opt.name, opt.transformedName, this);
                    if (defaultValue != null) {
                        s.setValue(defaultValue);
                    }
                    this.configOptions.put(opt.name, s);
                    break;
                }
                case 3: {
                    InternalConfigureOption io = new InternalConfigureOption(opt.name, opt.transformedName, this);
                    if (defaultValue != null) {
                        io.setValue(defaultValue);
                    }
                    this.configOptions.put(opt.name, io);
                    break;
                }
                case 4: {
                    MultiArgConfigureOption m = new MultiArgConfigureOption(opt.name, opt.transformedName, this);
                    if (buildProperties != null && opt.name.equals("user") && buildProperties.containsValue("org.eclipse.cdt.build.core.buildType", "org.eclipse.linuxtools.cdt.autotools.core.buildType.debug")) {
                        defaultValue = "CFLAGS='-g -O0'";
                        try {
                            if (this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                                defaultValue = String.valueOf(defaultValue) + " CXXFLAGS='-g -O0'";
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    if (defaultValue != null) {
                        m.setValue(defaultValue);
                    }
                    this.configOptions.put(opt.name, m);
                    break;
                }
                case 5: {
                    tools.add(opt);
                    ConfigureTool t = new ConfigureTool(opt.name, opt.transformedName, this);
                    if (defaultValue != null) {
                        t.setValue(defaultValue);
                    }
                    this.configOptions.put(opt.name, t);
                    break;
                }
                case 0: {
                    this.configOptions.put(opt.name, new ConfigureOptionCategory(opt.name));
                    break;
                }
                case 6: {
                    FlagConfigureOption f = new FlagConfigureOption(opt.name, opt.transformedName, this);
                    if (defaultValue != null) {
                        f.setValue(defaultValue);
                    }
                    lastFlag = f;
                    this.configOptions.put(opt.name, f);
                    break;
                }
                case 7: {
                    FlagValueConfigureOption fv = new FlagValueConfigureOption(opt.name, opt.transformedName, this, ConfigureMessages.getParameter(opt.transformedName));
                    if (defaultValue != null) {
                        fv.setValue(defaultValue);
                    }
                    lastFlag.addChild(opt.name);
                    this.configOptions.put(opt.name, fv);
                    break;
                }
                case 8: {
                    VariableConfigureOption v = new VariableConfigureOption(opt.name, opt.transformedName, this);
                    if (defaultValue != null) {
                        v.setValue(defaultValue);
                    }
                    this.configOptions.put(opt.name, v);
                }
            }
            ++i;
        }
        toolList = tools.toArray(new Option[tools.size()]);
    }

    public static Option[] getOptionList() {
        return (Option[])configOpts.clone();
    }

    public static Option[] getChildOptions(String name) {
        ArrayList<Option> options = new ArrayList<Option>();
        int i = 0;
        while (i < configOpts.length) {
            Option opt = configOpts[i];
            if (opt.getName().equals(name)) {
                if (opt.getType() == 0) {
                    j = i + 1;
                    while (j < configOpts.length) {
                        o = configOpts[j];
                        type = o.getType();
                        if (type == 0 || type == 5) {
                            return options.toArray(new Option[options.size()]);
                        }
                        options.add(o);
                        ++j;
                    }
                } else if (opt.getType() == 5) {
                    j = i + 1;
                    while (j < configOpts.length) {
                        o = configOpts[j];
                        type = o.getType();
                        if (type == 0) {
                            options.add(o);
                        } else if (type == 5) {
                            return options.toArray(new Option[options.size()]);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return options.toArray(new Option[options.size()]);
    }

    public static Option[] getTools() {
        return (Option[])toolList.clone();
    }

    @Override
    public IConfigureOption getOption(String name) {
        return this.configOptions.get(name);
    }

    @Override
    public IAConfiguration copy() {
        return this.copy(this.id);
    }

    @Override
    public IAConfiguration copy(String newId) {
        AutotoolsConfiguration cfg = new AutotoolsConfiguration(this.project, newId, false);
        Collection<IConfigureOption> oldValues = this.configOptions.values();
        for (IConfigureOption opt : oldValues) {
            cfg.configOptions.put(opt.getName(), opt.copy(cfg));
        }
        if (this.getId().equals(newId)) {
            cfg.setDirty(this.isDirty());
        } else {
            cfg.setDirty(true);
        }
        return cfg;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean value) {
        this.isDirty = value;
        if (this.isDirty) {
            this.isParmsDirty = true;
        }
    }

    @Override
    public Map<String, IConfigureOption> getOptions() {
        return this.configOptions;
    }

    @Override
    public String getToolParameters(String name) {
        StringBuilder buf = new StringBuilder();
        Option[] options = AutotoolsConfiguration.getChildOptions(name);
        int i = 0;
        while (i < options.length) {
            IConfigureOption option = this.getOption(options[i].getName());
            if (option.getType() == 0) {
                Option[] childOptions = AutotoolsConfiguration.getChildOptions(option.getName());
                int j = 0;
                while (j < childOptions.length) {
                    IConfigureOption childOption = this.getOption(childOptions[j].getName());
                    String parameter = childOption.getParameter();
                    if (!parameter.isEmpty()) {
                        buf.append(' ').append(parameter);
                    }
                    ++j;
                }
            } else {
                String parameter = option.getParameter();
                if (!parameter.isEmpty()) {
                    buf.append(' ').append(parameter);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public List<String> getToolArgs(String name) {
        if (this.isParmsDirty) {
            this.configParms = new ArrayList();
            Option[] options = AutotoolsConfiguration.getChildOptions(name);
            int i = 0;
            while (i < options.length) {
                IConfigureOption option = this.getOption(options[i].getName());
                if (option.getType() == 0) {
                    Option[] childOptions = AutotoolsConfiguration.getChildOptions(option.getName());
                    int j = 0;
                    while (j < childOptions.length) {
                        IConfigureOption childOption = this.getOption(childOptions[j].getName());
                        List<String> parameters = childOption.getParameters();
                        this.configParms.addAll(parameters);
                        ++j;
                    }
                } else {
                    List<String> parameters = option.getParameters();
                    this.configParms.addAll(parameters);
                }
                ++i;
            }
        }
        return this.configParms;
    }

    @Override
    public void setOption(String name, String value) {
        IConfigureOption option = this.configOptions.get(name);
        if (option != null && !option.getValue().equals(value)) {
            option.setValue(value);
            this.setDirty(true);
        }
    }

    @Override
    public void setConfigToolDirectory(String configToolDirectory) {
        this.setOption("configdir", configToolDirectory);
    }

    @Override
    public String getConfigToolDirectory() {
        IConfigureOption option = this.configOptions.get("configdir");
        return option.getValue();
    }

    @Override
    public void setDefaultOptions() {
        this.initConfigOptions();
    }

    public static class Option {
        private String name;
        private String transformedName;
        private String superClassId;
        private int type;
        private String defaultValue;

        public Option(String name, int type) {
            this(name, name, type);
        }

        public Option(String name, String transformedName, int type) {
            this.name = name;
            this.transformedName = transformedName;
            this.type = type;
        }

        public Option(String name, String transformedName, String defaultValue, int type) {
            this.name = name;
            this.transformedName = transformedName;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public Option(String name, String transformedName, String defaultValue, String superClassId, int type) {
            this.name = name;
            this.transformedName = transformedName;
            this.type = type;
            this.defaultValue = defaultValue;
            this.superClassId = superClassId;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getSuperClassId() {
            return this.superClassId;
        }

        public String getDescription() {
            return ConfigureMessages.getConfigureDescription(this.transformedName);
        }

        public String getToolTip() {
            return ConfigureMessages.getConfigureTip(this.transformedName);
        }
    }
}

