/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.admin.CDOAdminClientManager;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.admin.CDOAdminClientUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.NotAuthenticatedException;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MasterRepositoryController {
    private static final Image REPOSITORY_IMAGE = OM.getImage("icons/repository.gif");
    private static final Image EMPTY_IMAGE = OM.getImage("icons/empty.gif");
    private static final Image OK_IMAGE = OM.getImage("icons/ok.gif");
    private static final Image ERROR_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private static final int VALIDATING_WIDTH = 120;
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            MasterRepositoryController.this.dispose();
        }
    };
    private IListener adminListener = new IListener(){

        public void notifyEvent(IEvent event) {
            ViewerUtil.refresh((StructuredViewer)MasterRepositoryController.this.repositoryTableViewer, null);
        }
    };
    private IListener adminManagerListener = new ContainerEventAdapter<CDOAdminClient>(){

        protected void onAdded(IContainer<CDOAdminClient> container, CDOAdminClient admin) {
            admin.addListener(MasterRepositoryController.this.adminListener);
        }

        protected void onRemoved(IContainer<CDOAdminClient> container, CDOAdminClient admin) {
            admin.removeListener(MasterRepositoryController.this.adminListener);
        }
    };
    private CDOAdminClientManager adminManager;
    private IManagedContainer container;
    private Composite parent;
    private Text hostText;
    private ValidatingText portText;
    private TableViewer repositoryTableViewer;
    private ValidatingText repositoryNameText;
    private Label userNameLabel;
    private Text userNameText;
    private Label passwordLabel;
    private Text passwordText;
    private String connectorDescription;
    private String repositoryName;
    private String userName;
    private String password;
    private boolean authenticating;
    private CDORepository.VersioningMode versioningMode;
    private CDORepository.IDGeneration idGeneration;

    public MasterRepositoryController(Composite parent) {
        this.parent = parent;
        this.container = ContainerUtil.createPluginContainer();
        LifecycleUtil.activate((Object)this.container);
        this.adminManager = CDOAdminClientUtil.createAdminManager((IManagedContainer)this.container);
        this.adminManager.addListener(this.adminManagerListener);
        LifecycleUtil.activate((Object)this.adminManager);
        AbstractRepositoryPage.createLabel(parent, "Host:");
        this.hostText = new Text(parent, 2048);
        this.hostText.setText("localhost");
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        AbstractRepositoryPage.createLabel(parent, "Port:");
        this.portText = new HostValidatingText(parent);
        this.portText.setText("2036");
        this.hostText.addModifyListener((ModifyListener)this.portText);
        AbstractRepositoryPage.createLabel(parent, "Repositories:");
        this.repositoryTableViewer = new TableViewer(parent, 2052);
        this.repositoryTableViewer.setContentProvider((IContentProvider)new AdminContentProvider());
        this.repositoryTableViewer.setLabelProvider((IBaseLabelProvider)new AdminLabelProvider());
        this.repositoryTableViewer.setInput((Object)this.adminManager);
        this.repositoryTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.repositoryTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CDOAdminClientRepository adminRepository = (CDOAdminClientRepository)selection.getFirstElement();
                if (adminRepository != null) {
                    MasterRepositoryController.this.repositoryNameText.setText(adminRepository.getName());
                    MasterRepositoryController.this.repositoryNameText.modifyText(false);
                }
            }
        });
        AbstractRepositoryPage.createLabel(parent, "Repository name:");
        this.repositoryNameText = new RepositoryValidatingText(parent);
        this.userNameLabel = AbstractRepositoryPage.createLabel(parent, "User name:");
        this.userNameText = new Text(parent, 2048);
        this.userNameText.setLayoutData((Object)MasterRepositoryController.createWidthGridData());
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MasterRepositoryController.this.userName = MasterRepositoryController.this.userNameText.getText();
                MasterRepositoryController.this.repositoryNameText.modifyText(true);
            }
        });
        this.passwordLabel = AbstractRepositoryPage.createLabel(parent, "Password:");
        this.passwordText = new Text(parent, 0x400800);
        this.passwordText.setLayoutData((Object)MasterRepositoryController.createWidthGridData());
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MasterRepositoryController.this.password = MasterRepositoryController.this.passwordText.getText();
                MasterRepositoryController.this.repositoryNameText.modifyText(true);
            }
        });
        this.portText.modifyText(false);
        this.repositoryNameText.modifyText(false);
        parent.addDisposeListener(this.disposeListener);
    }

    public final String getConnectorDescription() {
        return this.connectorDescription;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public final boolean isAuthenticating() {
        return this.authenticating;
    }

    public final IPasswordCredentials getCredentials() {
        if (this.userNameText.isEnabled() && !StringUtil.isEmpty((String)this.userName)) {
            return new PasswordCredentials(this.userName, this.password);
        }
        return null;
    }

    public final CDORepository.VersioningMode getVersioningMode() {
        return this.versioningMode;
    }

    public final CDORepository.IDGeneration getIDGeneration() {
        return this.idGeneration;
    }

    public final boolean isValid() {
        return this.portText.isValid() && this.repositoryNameText.isValid();
    }

    public void dispose() {
        this.parent.removeDisposeListener(this.disposeListener);
        if (this.container != null) {
            this.repositoryNameText.cancelValidation();
            this.portText.cancelValidation();
            LifecycleUtil.deactivate((Object)this.adminManager);
            this.adminManager = null;
            this.container.deactivate();
            this.container = null;
        }
    }

    protected void validateController() {
        if (this.repositoryNameText != null && !this.repositoryNameText.isDisposed()) {
            this.repositoryName = this.repositoryNameText.getText();
        }
    }

    protected void showCredentials(final boolean show) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!MasterRepositoryController.this.parent.isDisposed()) {
                    MasterRepositoryController.this.userNameLabel.setEnabled(show);
                    MasterRepositoryController.this.userNameText.setEnabled(show);
                    MasterRepositoryController.this.passwordLabel.setEnabled(show);
                    MasterRepositoryController.this.passwordText.setEnabled(show);
                }
            }
        });
    }

    private static GridData createWidthGridData() {
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = 120;
        return gridData;
    }

    private final class AdminContentProvider
    implements IStructuredContentProvider {
        private AdminContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (MasterRepositoryController.this.connectorDescription != null) {
                CDOAdminClient[] cDOAdminClientArray = MasterRepositoryController.this.adminManager.getConnections();
                int n = cDOAdminClientArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOAdminClient admin = cDOAdminClientArray[n2];
                    String url = admin.getURL();
                    if (url.equals("tcp://" + MasterRepositoryController.this.connectorDescription)) {
                        return admin.getRepositories();
                    }
                    ++n2;
                }
            }
            return ContainerItemProvider.NO_ELEMENTS;
        }
    }

    private final class AdminLabelProvider
    extends LabelProvider {
        private AdminLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CDOAdminClientRepository) {
                return REPOSITORY_IMAGE;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof CDOAdminClientRepository) {
                CDOAdminClientRepository adminRepository = (CDOAdminClientRepository)element;
                return adminRepository.getName();
            }
            return super.getText(element);
        }
    }

    private final class HostValidatingText
    extends ValidatingText {
        public HostValidatingText(Composite parent) {
            super(parent);
        }

        @Override
        protected String getValidationInfo() {
            MasterRepositoryController.this.connectorDescription = null;
            String host = MasterRepositoryController.this.hostText.getText();
            if (host.length() == 0) {
                return null;
            }
            String port = this.getText();
            if (port.length() == 0) {
                port = "2036";
            }
            return String.valueOf(host) + ":" + port;
        }

        @Override
        protected String validate(String validationInfo) throws Exception {
            InetAddress addr;
            String[] tokens = validationInfo.split(":");
            String host = tokens[0];
            String port = tokens[1];
            try {
                addr = InetAddress.getByName(host);
            }
            catch (Exception ex) {
                throw new Exception("Unknown host");
            }
            try {
                new InetSocketAddress(addr, Integer.parseInt(port));
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("Invalid port");
            }
            MasterRepositoryController.this.connectorDescription = validationInfo;
            return "Valid address";
        }

        @Override
        protected void finished(boolean valid) {
            MasterRepositoryController.this.repositoryNameText.modifyText(false);
            if (valid && MasterRepositoryController.this.connectorDescription != null) {
                MasterRepositoryController.this.adminManager.addConnection("tcp://" + MasterRepositoryController.this.connectorDescription);
            }
            ViewerUtil.refresh((StructuredViewer)MasterRepositoryController.this.repositoryTableViewer, null);
        }
    }

    private final class RepositoryValidatingText
    extends ValidatingText {
        public RepositoryValidatingText(Composite parent) {
            super(parent);
        }

        @Override
        protected String getValidationInfo() {
            if (MasterRepositoryController.this.connectorDescription == null) {
                return null;
            }
            String repositoryName = this.getText();
            if (repositoryName.length() == 0) {
                return null;
            }
            return repositoryName;
        }

        @Override
        protected String validate(String repositoryName) throws Exception {
            String string;
            CDONet4jSession session = null;
            MasterRepositoryController.this.authenticating = false;
            MasterRepositoryController.this.versioningMode = null;
            MasterRepositoryController.this.idGeneration = null;
            try {
                IConnector connector = this.getConnector();
                PasswordCredentialsProvider credentialsProvider = new PasswordCredentialsProvider(MasterRepositoryController.this.userName, MasterRepositoryController.this.password){

                    public IPasswordCredentials getCredentials() {
                        ((RepositoryValidatingText)RepositoryValidatingText.this).MasterRepositoryController.this.authenticating = true;
                        return super.getCredentials();
                    }
                };
                try {
                    CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
                    config.setConnector(connector);
                    config.setRepositoryName(repositoryName);
                    config.setCredentialsProvider((IPasswordCredentialsProvider)credentialsProvider);
                    session = config.openNet4jSession();
                    if (session != null && session.isClosed()) {
                        session = null;
                    }
                }
                catch (NotAuthenticatedException ex) {
                    MasterRepositoryController.this.authenticating = true;
                }
                catch (Exception ex) {
                    session = null;
                }
                if (session == null) {
                    MasterRepositoryController.this.showCredentials(true);
                    if (MasterRepositoryController.this.authenticating) {
                        throw new Exception("Authentication failed");
                    }
                    throw new Exception("Repository unreachable");
                }
                MasterRepositoryController.this.showCredentials(MasterRepositoryController.this.authenticating);
                CDORepositoryInfo repositoryInfo = session.getRepositoryInfo();
                MasterRepositoryController.this.versioningMode = CDORepository.VersioningMode.from((CDORepositoryInfo)repositoryInfo);
                MasterRepositoryController.this.idGeneration = CDORepository.IDGeneration.from((CDORepositoryInfo)repositoryInfo);
                String message = MasterRepositoryController.this.versioningMode.toString();
                if (MasterRepositoryController.this.versioningMode == CDORepository.VersioningMode.Branching && MasterRepositoryController.this.idGeneration == CDORepository.IDGeneration.UUID) {
                    message = String.valueOf(message) + ", Replicable";
                }
                string = message;
            }
            catch (Throwable throwable) {
                LifecycleUtil.deactivate(session);
                throw throwable;
            }
            LifecycleUtil.deactivate((Object)session);
            return string;
        }

        private IConnector getConnector() throws Exception {
            IConnector connector = null;
            try {
                connector = Net4jUtil.getConnector((IManagedContainer)MasterRepositoryController.this.container, (String)"tcp", (String)MasterRepositoryController.this.connectorDescription);
            }
            catch (Exception ex) {
                connector = null;
            }
            if (connector == null) {
                throw new Exception("Host unreachable");
            }
            return connector;
        }
    }

    private abstract class ValidatingText
    extends Composite
    implements ModifyListener {
        private Text text;
        private Label imageLabel;
        private Label statusLabel;
        private boolean valid;
        private ValidationThread validationThread;

        public ValidatingText(Composite parent) {
            super(parent, 0);
            this.setLayoutData(new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayout((Layout)layout);
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)MasterRepositoryController.createWidthGridData());
            this.text.addModifyListener((ModifyListener)this);
            this.imageLabel = new Label((Composite)this, 0);
            this.statusLabel = new Label((Composite)this, 0);
            this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        public final String getText() {
            return this.text.getText();
        }

        public final void setText(String text) {
            this.text.setText(text);
        }

        public final boolean isValid() {
            return this.valid;
        }

        public void cancelValidation() {
            this.valid = false;
            if (this.validationThread != null) {
                this.validationThread.cancel();
                this.validationThread = null;
            }
        }

        public void modifyText(ModifyEvent e) {
            this.modifyText(true);
        }

        public void modifyText(boolean delay) {
            MasterRepositoryController.this.validateController();
            this.imageLabel.setImage(EMPTY_IMAGE);
            this.statusLabel.setText("");
            this.cancelValidation();
            MasterRepositoryController.this.parent.getDisplay().timerExec(delay ? 400 : 0, new Runnable(){

                @Override
                public void run() {
                    if (!((ValidatingText)ValidatingText.this).MasterRepositoryController.this.parent.isDisposed()) {
                        String validationInfo = ValidatingText.this.getValidationInfo();
                        if (validationInfo != null) {
                            ValidatingText.this.validationThread = new ValidationThread(validationInfo);
                            ValidatingText.this.validationThread.start();
                        } else {
                            ValidatingText.this.finished(false);
                        }
                    }
                }
            });
        }

        protected abstract String getValidationInfo();

        protected abstract String validate(String var1) throws Exception;

        protected void finished(boolean valid) {
        }

        private final class ValidationThread
        extends Thread {
            private final String validationInfo;
            private boolean canceled;

            public ValidationThread(String validationInfo) {
                super("Host Validator");
                this.setDaemon(true);
                this.validationInfo = validationInfo;
            }

            public void cancel() {
                this.canceled = true;
                this.interrupt();
            }

            @Override
            public void run() {
                this.updateLabels(null, false);
                String message = null;
                ValidatingText.this.valid = false;
                try {
                    message = ValidatingText.this.validate(this.validationInfo);
                    if (!this.canceled) {
                        ValidatingText.this.valid = true;
                    }
                }
                catch (Exception ex) {
                    message = ex.getMessage();
                }
                if (this.canceled) {
                    return;
                }
                this.updateLabels(message, ValidatingText.this.valid);
            }

            private void updateLabels(final String message, final boolean valid) {
                Display display = ((ValidatingText)ValidatingText.this).MasterRepositoryController.this.parent.getDisplay();
                if (!((ValidatingText)ValidatingText.this).MasterRepositoryController.this.parent.isDisposed()) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (message != null) {
                                    ((ValidationThread)ValidationThread.this).ValidatingText.this.imageLabel.setImage(valid ? OK_IMAGE : ERROR_IMAGE);
                                    ((ValidationThread)ValidationThread.this).ValidatingText.this.statusLabel.setText(message);
                                    ValidatingText.this.finished(valid);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            MasterRepositoryController.this.validateController();
                        }
                    });
                }
            }
        }
    }
}

