/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.fontname;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.dot.internal.language.fontname.Stretch;
import org.eclipse.gef.dot.internal.language.fontname.Style;
import org.eclipse.gef.dot.internal.language.fontname.Weight;

public enum PostScriptFontAlias {
    AVANTGARDE_BOOK("AvantGarde-Book", Family.AVANTGARDE_FAMILY, Weight.BOOK, null, null),
    AVANTGARDE_BOOKOBLIQUE("AvantGarde-BookOblique", Family.AVANTGARDE_FAMILY, Weight.BOOK, Style.OBLIQUE, null),
    AVANTGARDE_DEMI("AvantGarde-Demi", Family.AVANTGARDE_FAMILY, Weight.SEMILIGHT, null, null),
    AVANTGARDE_DEMIOBLIQUE("AvantGarde-DemiOblique", Family.AVANTGARDE_FAMILY, Weight.SEMILIGHT, Style.OBLIQUE, null),
    BOOKMAN_DEMI("Bookman-Demi", Family.BOOKMAN_FAMILY, Weight.SEMILIGHT, null, null),
    BOOKMAN_DEMIITALIC("Bookman-DemiItalic", Family.BOOKMAN_FAMILY, Weight.SEMILIGHT, Style.ITALIC, null),
    BOOKMAN_LIGHT("Bookman-Light", Family.BOOKMAN_FAMILY, Weight.LIGHT, null, null),
    BOOKMAN_LIGHTITALIC("Bookman-LightItalic", Family.BOOKMAN_FAMILY, Weight.LIGHT, Style.ITALIC, null),
    COURIER("Courier", Family.COURIER_FAMILY, null, null, null),
    COURIER_BOLD("Courier-Bold", Family.COURIER_FAMILY, Weight.BOLD, null, null),
    COURIER_BOLDOBLIQUE("Courier-BoldOblique", Family.COURIER_FAMILY, Weight.BOLD, Style.OBLIQUE, null),
    COURIER_OBLIQUE("Courier-Oblique", Family.COURIER_FAMILY, null, Style.OBLIQUE, null),
    HELVETICA("Helvetica", Family.HELVETICA_FAMILY, null, null, null),
    HELVETICA_BOLD("Helvetica-Bold", Family.HELVETICA_FAMILY, Weight.BOLD, null, null),
    HELVETICA_BOLDOBLIQUE("Helvetica-BoldOblique", Family.HELVETICA_FAMILY, Weight.BOLD, Style.OBLIQUE, null),
    HELVETICA_NARROW("Helvetica-Narrow", Family.HELVETICA_FAMILY, null, null, Stretch.CONDENSED),
    HELVETICA_NARROW_BOLD("Helvetica-Narrow-Bold", Family.HELVETICA_FAMILY, Weight.BOLD, null, Stretch.CONDENSED),
    HELVETICA_NARROW_BOLDOBLIQUE("Helvetica-Narrow-BoldOblique", Family.HELVETICA_FAMILY, Weight.BOLD, Style.OBLIQUE, Stretch.CONDENSED),
    HELVETICA_NARROW_OBLIQUE("Helvetica-Narrow-Oblique", Family.HELVETICA_FAMILY, null, Style.OBLIQUE, Stretch.CONDENSED),
    HELVETICA_OBLIQUE("Helvetica-Oblique", Family.HELVETICA_FAMILY, null, Style.OBLIQUE, null),
    NEWCENTURYSCHLBK_BOLD("NewCenturySchlbk-Bold", Family.NEWCENTURYSCHLBK_FAMILY, Weight.BOLD, null, null),
    NEWCENTURYSCHLBK_BOLDITALIC("NewCenturySchlbk-BoldItalic", Family.NEWCENTURYSCHLBK_FAMILY, Weight.BOLD, Style.ITALIC, null),
    NEWCENTURYSCHLBK_ITALIC("NewCenturySchlbk-Italic", Family.NEWCENTURYSCHLBK_FAMILY, null, Style.ITALIC, null),
    NEWCENTURYSCHLBK_ROMAN("NewCenturySchlbk-Roman", Family.NEWCENTURYSCHLBK_FAMILY, Weight.NORMAL, null, null),
    PALATINO_BOLD("Palatino-Bold", Family.PALATINO_FAMILY, Weight.BOLD, null, null),
    PALATINO_BOLDITALIC("Palatino-BoldItalic", Family.PALATINO_FAMILY, Weight.BOLD, Style.ITALIC, null),
    PALATINO_ITALIC("Palatino-Italic", Family.PALATINO_FAMILY, null, Style.ITALIC, null),
    PALATINO_ROMAN("Palatino-Roman", Family.PALATINO_FAMILY, Weight.NORMAL, null, null),
    SYMBOL("Symbol", Family.SYMBOL_FAMILY, null, null, null),
    TIMES_BOLD("Times-Bold", Family.TIMES_FAMILY, Weight.BOLD, null, null),
    TIMES_BOLDITALIC("Times-BoldItalic", Family.TIMES_FAMILY, Weight.BOLD, Style.ITALIC, null),
    TIMES_ITALIC("Times-Italic", Family.TIMES_FAMILY, null, Style.ITALIC, null),
    TIMES_ROMAN("Times-Roman", Family.TIMES_FAMILY, null, null, null),
    ZAPFCHANCERY_MEDIUMITALIC("ZapfChancery-MediumItalic", Family.CHANCERY_FAMILY, Weight.MEDIUM, Style.ITALIC, null),
    ZAPFDINGBATS("ZapfDingbats", Family.DINGBATS_FAMILY, null, null, null);

    private final String literal;
    private final Family family;
    private final Weight weight;
    private final Style style;
    private final Stretch stretch;

    private PostScriptFontAlias(String literal, Family family, Weight weight, Style style, Stretch stretch) {
        this.literal = literal;
        this.family = family;
        this.weight = weight;
        this.style = style;
        this.stretch = stretch;
    }

    public Family getFamily() {
        return this.family;
    }

    public Weight getWeight() {
        return this.weight;
    }

    public Style getStyle() {
        return this.style;
    }

    public Stretch getStretch() {
        return this.stretch;
    }

    public String toString() {
        return this.literal;
    }

    public static enum Family {
        AVANTGARDE_FAMILY("AvantGarde", "URW Gothic L", "Charcoal", "Nimbus Sans L", "Verdana", "Helvetica", "Bitstream Vera Sans", "DejaVu Sans", "Liberation Sans", "Luxi Sans", "FreeSans", "sans"),
        BOOKMAN_FAMILY("Bookman", "URW Bookman L", "Times New Roman", "Times", "Nimbus Roman No9 L", "Bitstream Vera Serif", "DejaVu Serif", "Liberation Serif", "Luxi Serif", "FreeSerif", "serif"),
        COURIER_FAMILY("Courier", "Nimbus Mono L", "Inconsolata", "Courier New", "Bitstream Vera Sans Mono", "DejaVu Sans Mono", "Liberation Mono", "Luxi Mono", "FreeMono", "monospace"),
        HELVETICA_FAMILY("Helvetica", "Nimbus Sans L", "Arial", "Verdana", "Bitstream Vera Sans", "DejaVu Sans", "Liberation Sans", "Luxi Sans", "FreeSans", "sans"),
        NEWCENTURYSCHLBK_FAMILY("NewCenturySchlbk", "URW Bookman L", "Times New Roman", "Times", "Georgia", "Bitstream Vera Serif", "DejaVu Serif", "Liberation Serif", "Luxi Serif", "FreeSerif", "serif"),
        PALATINO_FAMILY("Palatino", "Times New Roman", "Times", "Nimbus Roman No9 L", "Norasi", "Rekha", "Bitstream Vera Serif", "DejaVu Serif", "Liberation Serif", "Luxi Serif", "FreeSerif", "serif"),
        SYMBOL_FAMILY("Symbol", "Impact", "Copperplate Gothic Std", "Cooper Std", "Bauhaus Std", "fantasy"),
        TIMES_FAMILY("Times", "Nimbus Roman No9 L", "Times New Roman", "Charcoal", "Bitstream Vera Serif", "DejaVu Serif", "Liberation Serif", "Luxi Serif", "FreeSerif", "serif"),
        CHANCERY_FAMILY("ZapfChancery", "URW Chancery L", "Charcoal", "Times New Roman", "Times", "Nimbus Roman No9 L", "Bitstream Vera Serif", "DejaVu Serif", "Liberation Serif", "Luxi Serif", "FreeSerif", "serif"),
        DINGBATS_FAMILY("ZapfDingbats", "Dingbats", "Impact", "Copperplate Gothic Std", "Cooper Std", "Bauhaus Std", "fantasy");

        private final List<String> families;

        private Family(String ... families) {
            this.families = Arrays.asList(families);
        }

        public List<String> getFamilies() {
            return this.families;
        }
    }
}

