/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.recordlabel.Field;
import org.eclipse.gef.dot.internal.language.recordlabel.FieldID;
import org.eclipse.gef.dot.internal.language.recordlabel.RLabel;
import org.eclipse.gef.dot.internal.language.recordlabel.RecordlabelPackage;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotRecordLabelValidator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DotRecordLabelValidator
extends AbstractDotRecordLabelValidator {
    public static final String ISSUE_CODE_PREFIX = "org.eclipse.gef.dot.internal.language.dotRecordLabel.";
    public static final String PORT_NAME_DUPLICATE = "org.eclipse.gef.dot.internal.language.dotRecordLabel.PortNameDuplicate";
    public static final String PORT_NAME_NOT_SET = "org.eclipse.gef.dot.internal.language.dotRecordLabel.PortNameNotSet";

    @Check
    public void checkPortNameIsNotNull(FieldID fieldID) {
        if (!fieldID.isPortNamed()) {
            return;
        }
        String name = fieldID.getPort();
        if (name == null) {
            this.warning("Port unnamed: port cannot be referenced", (EStructuralFeature)RecordlabelPackage.Literals.FIELD_ID__PORT, PORT_NAME_NOT_SET, new String[0]);
        }
    }

    @Check
    public void checkMultiplePortsNotSameName(RLabel label) {
        if (label.eContainer() instanceof Field) {
            return;
        }
        HashMultimap fieldsMappedToPortname = HashMultimap.create();
        Iterable allPortsWithNames = IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)label, FieldID.class), field -> field.getPort() != null);
        for (FieldID field2 : allPortsWithNames) {
            fieldsMappedToPortname.put((Object)field2.getPort(), (Object)field2);
        }
        Iterable allMisnamedPorts = Iterables.concat((Iterable)IterableExtensions.filter(fieldsMappedToPortname.asMap().values(), collection -> collection.size() > 1));
        for (FieldID misnamedPort : allMisnamedPorts) {
            this.error("Port name not unique: " + misnamedPort.getPort(), misnamedPort, (EStructuralFeature)RecordlabelPackage.eINSTANCE.getFieldID_Port(), PORT_NAME_DUPLICATE, new String[0]);
        }
    }
}

