/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.annotations.OSGiAnnotationsClasspathContributor;
import org.eclipse.pde.internal.core.bnd.TargetRepository;
import org.eclipse.pde.internal.core.natures.BndProject;

public class BndProjectManager {
    private static final String DELIMITER = ",";
    private static final String TRUE = "true";
    private static Workspace workspace;

    public static Optional<Project> getBndProject(IProject project) throws Exception {
        File projectFolder;
        IPath projectPath;
        if (BndProject.isBndProject(project) && (projectPath = project.getLocation()) != null && (projectFolder = projectPath.toFile()) != null) {
            Project bnd = new Project(BndProjectManager.getWorkspace(), projectFolder, new File(projectFolder, "pde.bnd"));
            bnd.setBase(projectFolder);
            BndProjectManager.setupProject(bnd, project);
            return Optional.of(bnd);
        }
        return Optional.empty();
    }

    private static void setupProject(Project bnd, IProject project) throws CoreException {
        IPath base = project.getFullPath();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            ArrayList<String> src = new ArrayList<String>(1);
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 3) {
                    src.add(cpe.getPath().makeRelativeTo(base).toString());
                }
                ++n2;
            }
            String outputLocation = javaProject.getOutputLocation().makeRelativeTo(base).toString();
            bnd.setProperty("src", src.stream().collect(Collectors.joining(DELIMITER)));
            bnd.setProperty("bin", outputLocation);
            bnd.setProperty("target-dir", outputLocation);
        }
        String buildPath = bnd.getProperty("-buildpath");
        Stream<String> enhnacedBuildPath = OSGiAnnotationsClasspathContributor.annotations().map(p -> p.getPluginBase().getId());
        if (buildPath != null) {
            enhnacedBuildPath = Stream.concat(Stream.of(buildPath), enhnacedBuildPath);
        }
        bnd.setProperty("-buildpath", enhnacedBuildPath.collect(Collectors.joining(DELIMITER)));
    }

    static synchronized Workspace getWorkspace() throws Exception {
        if (workspace == null) {
            Throwable throwable = null;
            Object var1_2 = null;
            try (Processor run = new Processor();){
                run.setProperty("-standalone", TRUE);
                IPath path = PDECore.getDefault().getStateLocation().append("cnf");
                workspace = Workspace.createStandaloneWorkspace((Processor)run, (URI)path.toFile().toURI());
                workspace.addBasicPlugin((Object)TargetRepository.getTargetRepository());
                workspace.refresh();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return workspace;
    }

    static void publishContainerEntries(List<IClasspathEntry> entries, Collection<Container> containers, boolean isTest) {
        for (Container container : containers) {
            File file;
            Container.TYPE type = container.getType();
            if (type == Container.TYPE.PROJECT || !(file = container.getFile()).exists()) continue;
            IPath path = IPath.fromOSString((String)file.getAbsolutePath());
            IClasspathAttribute[] attributes = isTest ? new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"test", (String)TRUE)} : new IClasspathAttribute[]{};
            entries.add(JavaCore.newLibraryEntry((IPath)path, null, (IPath)IPath.ROOT, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attributes, (boolean)false));
        }
    }

    public static List<IClasspathEntry> getClasspathEntries(Project project, IWorkspaceRoot root) throws Exception {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        for (Project dep : project.getBuildDependencies()) {
            IContainer[] containers;
            File base = dep.getBase();
            IContainer[] iContainerArray = containers = root.findContainersForLocation(IPath.fromOSString((String)base.getAbsolutePath()));
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (container instanceof IProject) {
                    IProject p = (IProject)container;
                    entries.add(JavaCore.newProjectEntry((IPath)p.getFullPath()));
                }
                ++n2;
            }
        }
        BndProjectManager.publishContainerEntries(entries, project.getBootclasspath(), false);
        BndProjectManager.publishContainerEntries(entries, project.getBuildpath(), false);
        BndProjectManager.publishContainerEntries(entries, project.getClasspath(), false);
        BndProjectManager.publishContainerEntries(entries, project.getTestpath(), true);
        return entries;
    }
}

