/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.view;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.IArtifact;
import org.eclipse.ptp.pldt.mpi.analysis.view.ArtifactWithParent;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MPIArtifactMarkingVisitor
extends ArtifactMarkingVisitor {
    protected static final boolean traceOn = false;

    public MPIArtifactMarkingVisitor(String markerID) {
        super(markerID);
    }

    public String getMarkerID() {
        return this.markerID_;
    }

    public boolean visitFile(IResource resource, Artifact[] artifacts) {
        try {
            int numArtifacts = this.artifactManager_.getArtifacts().length;
            String fn = resource.getProjectRelativePath().toString();
            if (artifacts != null) {
                this.createMarkers(resource, fn, artifacts);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void createArtifactMarker(IResource resource, Artifact artifact, String fn) throws CoreException {
        Map attrs = this.createCommonMarkerAttrs(resource, artifact, fn);
        attrs.put("message", artifact.getShortName());
        ArtifactWithParent awp = (ArtifactWithParent)artifact;
        attrs.put("parentID", new Integer(awp.getParentID()));
        attrs.put("myID", new Integer(awp.getMyID()));
        attrs.put("myName", awp.getMyName());
        attrs.put("myIndex", new Integer(awp.getIndex()));
        MarkerUtilities.createMarker((IResource)resource, (Map)attrs, (String)this.markerID_);
        this.artifactManager_.addArtifactToHash((IArtifact)artifact);
    }
}

