/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.policies;

import java.util.Iterator;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.events.IEditPolicyListener;
import org.eclipse.wb.gef.core.requests.Request;

public abstract class EditPolicy {
    public static final String SELECTION_ROLE = "Selection Feedback";
    public static final String LAYOUT_ROLE = "LayoutEditPolicy";
    private EditPart m_host;
    private boolean m_isActive;
    private EventListenerList m_eventTable;

    public void activate() {
        this.m_isActive = true;
        this.fireActivate();
    }

    public void deactivate() {
        this.fireDeactivate();
        this.m_isActive = false;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public void dispose() {
    }

    public EditPart getHost() {
        return this.m_host;
    }

    public void setHost(EditPart host) {
        this.m_host = host;
    }

    public Command getCommand(Request request) {
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        return null;
    }

    public boolean understandsRequest(Request request) {
        return false;
    }

    public void performRequest(Request request) {
    }

    public void showSourceFeedback(Request request) {
    }

    public void eraseSourceFeedback(Request request) {
    }

    public void showTargetFeedback(Request request) {
    }

    public void eraseTargetFeedback(Request request) {
    }

    public void addEditPolicyListener(IEditPolicyListener listener) {
        this.getEnsureEventTable().addListener(IEditPolicyListener.class, (Object)listener);
    }

    public void removeEditPolicyListener(IEditPolicyListener listener) {
        this.getEnsureEventTable().removeListener(IEditPolicyListener.class, (Object)listener);
    }

    public <L> Iterator<L> getListeners(Class<L> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }

    protected EventListenerList getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventListenerList();
        }
        return this.m_eventTable;
    }

    private void fireActivate() {
        Iterator<IEditPolicyListener> listeners = this.getListeners(IEditPolicyListener.class);
        if (listeners != null) {
            listeners.forEachRemaining(listener -> listener.activatePolicy(this));
        }
    }

    private void fireDeactivate() {
        Iterator<IEditPolicyListener> listeners = this.getListeners(IEditPolicyListener.class);
        if (listeners != null) {
            listeners.forEachRemaining(listener -> listener.deactivatePolicy(this));
        }
    }

    protected final Object getHostModel() {
        return this.getHost().getModel();
    }
}

