/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.linux;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.swt.VisualDataMockupProvider;
import org.eclipse.wb.os.OSSupport;

public abstract class OSSupportLinux<H extends Number>
extends OSSupport {
    private static final Color TITLE_BORDER_COLOR_DARKEST;
    private static final Color TITLE_BORDER_COLOR_DARKER;
    protected static final OSSupport INSTANCE;
    private Map<H, Control> m_controlsRegistry;
    private boolean m_eclipseToggledOnTop;
    private Shell m_eclipseShell;

    static {
        System.loadLibrary("wbp3");
        TITLE_BORDER_COLOR_DARKEST = DrawUtils.getShiftedColor((Color)IColorConstants.titleBackground, (int)-24);
        TITLE_BORDER_COLOR_DARKER = DrawUtils.getShiftedColor((Color)IColorConstants.titleBackground, (int)-16);
        INSTANCE = new Impl64();
    }

    private void prepareScreenshot(Shell shell) throws Exception {
        this.createRegistry();
        this.registerControl((Control)shell);
        this.registerByHandle((Control)shell, "shellHandle");
    }

    private void createRegistry() {
        this.m_controlsRegistry = Maps.newHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private void registerControl(Control control) throws Exception {
        Point size = control.getSize();
        if (size.x == 0 || size.y == 0) {
            return;
        }
        this.registerByHandle(control, "fixedHandle");
        this.registerByHandle(control, "handle");
        control.setData("WBP_IMAGE", null);
        Control control2 = control;
        if (control2 instanceof Composite) {
            void composite;
            Composite composite2 = (Composite)control2;
            Composite cfr_ignored_0 = (Composite)control2;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.registerControl(child);
                ++n2;
            }
        }
    }

    private void registerByHandle(Control control, String handleName) throws Exception {
        H handle = this.getHandleValue(control, handleName);
        if (handle != null) {
            this.m_controlsRegistry.put(handle, control);
        }
    }

    private Shell getShell(Object controlObject) {
        Assert.instanceOf(Control.class, (Object)controlObject);
        Control control = (Control)controlObject;
        return control.getShell();
    }

    public void beginShot(Object controlObject) {
        Shell shell = this.layoutShell(controlObject);
        if (!this.isWorkaroundsDisabled()) {
            OSSupportLinux._begin_shot(this.getShellHandle(shell));
            try {
                ReflectionUtils.invokeMethod((Object)shell, (String)"adjustTrim()", (Object[])new Object[0]);
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
            this.m_eclipseShell = DesignerPlugin.getShell();
            if (this.m_eclipseShell != null) {
                this.m_eclipseToggledOnTop = OSSupportLinux._toggle_above(this.getShellHandle(this.m_eclipseShell), false);
            }
        }
        shell.setLocation(10000, 10000);
        shell.setVisible(true);
    }

    public void endShot(Object controlObject) {
        super.endShot(controlObject);
        Shell shell = this.getShell(controlObject);
        if (!this.isWorkaroundsDisabled()) {
            OSSupportLinux._end_shot(this.getShellHandle(shell));
            if (this.m_eclipseShell != null) {
                OSSupportLinux._toggle_above(this.getShellHandle(this.m_eclipseShell), this.m_eclipseToggledOnTop);
            }
        }
    }

    public void makeShots(Object controlObject) throws Exception {
        Shell shell = this.getShell(controlObject);
        this.makeShots0(shell);
    }

    private void makeShots0(Shell shell) throws Exception {
        this.prepareScreenshot(shell);
        HashSet disposeImages = Sets.newHashSet();
        this.makeShot(shell, (handle, image) -> {
            Control imageForControl = this.m_controlsRegistry.get(handle);
            if (imageForControl == null || !this.bindImage(imageForControl, (Image)image)) {
                disposeImages.add(image);
            }
        });
        for (Image image2 : disposeImages) {
            image2.dispose();
        }
    }

    private boolean bindImage(final Control control, final Image image) {
        return (Boolean)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                if (control.getData("WBP_NEED_IMAGE") != null && control.getData("WBP_IMAGE") == null) {
                    control.setData("WBP_IMAGE", (Object)image);
                    return true;
                }
                return false;
            }
        });
    }

    public Image makeShot(Control control) throws Exception {
        Shell shell = this.getShell(control);
        shell.setLocation(10000, 10000);
        shell.setVisible(true);
        Rectangle controlBounds = control.getBounds();
        if (controlBounds.width == 0 || controlBounds.height == 0) {
            return null;
        }
        try {
            Image image = this.makeShot(shell, null);
            return image;
        }
        finally {
            shell.setVisible(false);
        }
    }

    protected abstract Image makeShot(Shell var1, BiConsumer<H, Image> var2);

    private Rectangle getWidgetBounds(Object widget) {
        H widgetHandle = this.getHandleValue(widget, "handle");
        int[] sizes = new int[4];
        OSSupportLinux._getWidgetBounds(widgetHandle, sizes);
        return new Rectangle(sizes[0], sizes[1], sizes[2], sizes[3]);
    }

    protected H getShellHandle(Shell shell) {
        H widgetHandle = this.getHandleValue(shell, "fixedHandle");
        if (widgetHandle == null) {
            widgetHandle = this.getHandleValue(shell, "shellHandle");
        }
        return widgetHandle;
    }

    private static boolean isGtk4() {
        try {
            return ReflectionUtils.getFieldBoolean(OSSupportLinux.class.getClassLoader().loadClass("org.eclipse.swt.internal.gtk.GTK"), (String)"GTK4");
        }
        catch (ReflectiveOperationException e) {
            DesignerPlugin.log((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void gdkThreadsEnter() {
        OSSupportLinux.gdk("gdk_threads_enter()", new Object[0]);
    }

    private static void gdkThreadsLeave() {
        OSSupportLinux.gdk("gdk_threads_leave()", new Object[0]);
    }

    protected abstract H getHandleValue(Object var1, String var2);

    protected abstract Image createImage0(H var1) throws Exception;

    private Image createImage(H imageHandle) throws Exception {
        Image image = this.createImage0(imageHandle);
        Image newImage = new Image(null, image.getImageData());
        image.dispose();
        return newImage;
    }

    public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
        H handle = this.getHandleValue(menu, "handle");
        H imageHandle = OSSupportLinux._fetchMenuVisualData(handle, bounds);
        return this.createImage(imageHandle);
    }

    public Image getMenuBarVisualData(Menu menu, List<Rectangle> bounds) {
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            bounds.add(this.getWidgetBounds(item));
            ++i;
        }
        return null;
    }

    public final Rectangle getMenuBarBounds(Menu menu) {
        Rectangle bounds = this.getWidgetBounds(menu);
        Shell shell = menu.getShell();
        Point p = shell.toControl(shell.getLocation());
        p.x = -p.x;
        p.y = -p.y - bounds.height;
        return new Rectangle(p.x, p.y, bounds.width, bounds.height);
    }

    public final int getDefaultMenuBarHeight() {
        return 24;
    }

    public final Rectangle getTabItemBounds(Object tabItem) {
        return this.getWidgetBounds(tabItem);
    }

    private boolean isWorkaroundsDisabled() {
        return Boolean.parseBoolean(System.getProperty("__wbp.linux.disableScreenshotWorkarounds"));
    }

    public void setAlpha(Shell shell, int alpha) {
        OSSupportLinux._setAlpha(this.getShellHandle(shell), alpha);
    }

    public int getAlpha(Shell shell) {
        return OSSupportLinux._getAlpha(this.getShellHandle(shell));
    }

    public boolean isPlusMinusTreeClick(Tree tree, int x, int y) {
        return OSSupportLinux._isPlusMinusTreeClick(this.getHandleValue(tree, "handle"), x, y);
    }

    public void runAwt(Runnable job) {
        Display display = Display.getCurrent();
        try {
            if (display != null && !OSSupportLinux.isGtk4()) {
                OSSupportLinux.gdkThreadsLeave();
            }
            super.runAwt(job);
        }
        finally {
            if (display != null && !OSSupportLinux.isGtk4()) {
                OSSupportLinux.gdkThreadsEnter();
            }
        }
    }

    private static native <H extends Number> boolean _isPlusMinusTreeClick(H var0, int var1, int var2);

    private static native <H extends Number> void _setAlpha(H var0, int var1);

    private static native <H extends Number> int _getAlpha(H var0);

    private static native <H extends Number> void _getWidgetBounds(H var0, int[] var1);

    private static native <H extends Number> H _fetchMenuVisualData(H var0, int[] var1);

    private static native <H extends Number> boolean _toggle_above(H var0, boolean var1);

    private static native <H extends Number> boolean _begin_shot(H var0);

    private static native <H extends Number> boolean _end_shot(H var0);

    @Deprecated
    private static native <H extends Number> void _gdk_window_process_updates(H var0, boolean var1);

    private static native <H extends Number> boolean _gdk_window_is_visible(H var0);

    private static native <H extends Number> void _gdk_window_get_geometry(H var0, int[] var1, int[] var2, int[] var3, int[] var4);

    private static native <H extends Number> H _gtk_widget_get_window(H var0);

    protected static final <T> T gdk(String methodSignature, Object ... args) {
        return OSSupportLinux.swt("org.eclipse.swt.internal.gtk.GDK", methodSignature, args);
    }

    protected static final <T> T gtk(String methodSignature, Object ... args) {
        return OSSupportLinux.swt("org.eclipse.swt.internal.gtk.GTK", methodSignature, args);
    }

    private static final <T> T swt(String fullClassName, String methodSignature, Object ... args) {
        return (T)ExecutionUtils.runObject(() -> ReflectionUtils.invokeMethod(OSSupportLinux.class.getClassLoader().loadClass(fullClassName), (String)methodSignature, (Object[])args));
    }

    private static final class Impl64
    extends OSSupportLinux<Long> {
        private final VisualDataMockupProvider mockupProvider = new VisualDataMockupProvider();

        private Impl64() {
        }

        @Override
        protected Long getHandleValue(Object widget, String fieldName) {
            long value = ReflectionUtils.getFieldLong((Object)widget, (String)fieldName);
            if (value != 0L) {
                return value;
            }
            return null;
        }

        @Override
        public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
            return this.mockupProvider.mockMenuPopupVisualData(menu, bounds);
        }

        @Override
        protected Image createImage0(Long imageHandle) throws Exception {
            return (Image)ReflectionUtils.invokeMethod2(Image.class, (String)"gtk_new", Device.class, Integer.TYPE, Long.TYPE, Long.TYPE, null, (Object)0, (Object)imageHandle, (Object)0);
        }

        protected Image getImageSurface(Shell shell, Long window, BiConsumer<Long, Image> callback) {
            if (!OSSupportLinux._gdk_window_is_visible(window)) {
                return null;
            }
            int[] x = new int[1];
            int[] y = new int[1];
            int[] width = new int[1];
            int[] height = new int[1];
            OSSupportLinux._gdk_window_get_geometry(window, x, y, width, height);
            OSSupportLinux._gdk_window_process_updates(window, true);
            long[] widget = new long[1];
            Impl64.gdk("gdk_window_get_user_data(long,long[])", window, widget);
            Image image = this.getImageSurface(shell, (Long)widget[0], new Rectangle(x[0], y[0], width[0], height[0]));
            if (callback != null) {
                callback.accept(widget[0], image);
            }
            return image;
        }

        private Image getImageSurface(Shell shell, Long widget, Rectangle surface) {
            if (shell.getDisplay().findWidget(widget.longValue()) instanceof Shell) {
                return this.getImageSurface(shell);
            }
            return this.getImageSurface(shell, surface);
        }

        private Image getImageSurface(Shell shell) {
            Image image = new Image((Device)shell.getDisplay(), shell.getBounds());
            Point location = shell.getLocation();
            GC gc = new GC((Drawable)shell.getDisplay());
            gc.copyArea(image, location.x, location.y);
            gc.dispose();
            return image;
        }

        private Image getImageSurface(Shell shell, Rectangle surface) {
            Rectangle visibleSurface = shell.getClientArea().intersection(surface);
            if (visibleSurface.width <= 0 || visibleSurface.height <= 0) {
                return new Image((Device)shell.getDisplay(), 1, 1);
            }
            Point location = shell.toDisplay(visibleSurface.x, visibleSurface.y);
            Image image = new Image((Device)shell.getDisplay(), visibleSurface);
            GC gc = new GC((Drawable)shell.getDisplay());
            gc.copyArea(image, location.x, location.y);
            gc.dispose();
            return image;
        }

        private Image traverse(Shell shell, Long window, BiConsumer<Long, Image> callback) {
            Image image = this.getImageSurface(shell, window, callback);
            if (image == null) {
                return null;
            }
            Long children = (Long)Impl64.gdk("gdk_window_get_children(long)", window);
            int length = (Integer)Impl64.gtk("g_list_length(long)", children);
            int i = 0;
            while (i < length) {
                Long childWindow = (Long)Impl64.gtk("g_list_nth_data(long,int)", children, i);
                Image childImage = this.traverse(shell, childWindow, callback);
                if (childImage != null && callback == null) {
                    childImage.dispose();
                }
                ++i;
            }
            Impl64.gtk("g_list_free(long)", children);
            return image;
        }

        @Override
        protected Image makeShot(Shell shell, BiConsumer<Long, Image> callback) {
            return this.traverse(shell, OSSupportLinux._gtk_widget_get_window((Long)this.getShellHandle(shell)), callback);
        }
    }
}

