/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

public class RefactoringScopeFactory {
    private static void addReferencingProjects(IJavaScriptProject focus, Set projects) throws JavaScriptModelException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IIncludePathEntry entry;
            IJavaScriptProject candidate = JavaScriptCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferencing(IJavaScriptProject focus, Set projects) throws CoreException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IIncludePathEntry entry;
            IJavaScriptProject candidate = JavaScriptCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferenced(IJavaScriptProject focus, Set projects) throws CoreException {
        IProject[] referencedProjects = focus.getProject().getReferencedProjects();
        int i = 0;
        while (i < referencedProjects.length) {
            IIncludePathEntry entry;
            IJavaScriptProject candidate = JavaScriptCore.create((IProject)referencedProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(focus, candidate)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                }
            }
            ++i;
        }
    }

    public static IJavaScriptSearchScope create(IJavaScriptElement javaElement) throws JavaScriptModelException {
        return RefactoringScopeFactory.create(javaElement, true);
    }

    public static IJavaScriptSearchScope create(IJavaScriptElement javaElement, boolean considerVisibility) throws JavaScriptModelException {
        IMember member;
        if (considerVisibility & javaElement instanceof IMember && JdtFlags.isPrivate(member = (IMember)javaElement)) {
            if (member.getJavaScriptUnit() != null) {
                return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{member.getJavaScriptUnit()});
            }
            return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{member});
        }
        return RefactoringScopeFactory.create(javaElement.getJavaScriptProject());
    }

    private static IJavaScriptSearchScope create(IJavaScriptProject javaProject) throws JavaScriptModelException {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])RefactoringScopeFactory.getAllScopeElements(javaProject), (boolean)false);
    }

    public static IJavaScriptSearchScope create(IMember[] members) throws JavaScriptModelException {
        Assert.isTrue((members != null && members.length > 0 ? 1 : 0) != 0);
        IMember candidate = members[0];
        int visibility = RefactoringScopeFactory.getVisibility(candidate);
        int i = 1;
        while (i < members.length) {
            int mv = RefactoringScopeFactory.getVisibility(members[i]);
            if (mv > visibility) {
                visibility = mv;
                candidate = members[i];
            }
            ++i;
        }
        return RefactoringScopeFactory.create((IJavaScriptElement)candidate);
    }

    public static IJavaScriptSearchScope createReferencedScope(IJavaScriptElement[] javaElements) {
        HashSet<IJavaScriptProject> projects = new HashSet<IJavaScriptProject>();
        int i = 0;
        while (i < javaElements.length) {
            projects.add(javaElements[i].getJavaScriptProject());
            ++i;
        }
        IJavaScriptProject[] prj = projects.toArray(new IJavaScriptProject[projects.size()]);
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])prj, (boolean)true);
    }

    public static IJavaScriptSearchScope createReferencedScope(IJavaScriptElement[] javaElements, int includeMask) {
        HashSet<IJavaScriptProject> projects = new HashSet<IJavaScriptProject>();
        int i = 0;
        while (i < javaElements.length) {
            projects.add(javaElements[i].getJavaScriptProject());
            ++i;
        }
        IJavaScriptProject[] prj = projects.toArray(new IJavaScriptProject[projects.size()]);
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])prj, (int)includeMask);
    }

    public static IJavaScriptSearchScope createRelatedProjectsScope(IJavaScriptProject project, int includeMask) throws CoreException {
        IJavaScriptProject[] projects = RefactoringScopeFactory.getRelatedProjects(project);
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])projects, (int)includeMask);
    }

    private static IJavaScriptElement[] getAllScopeElements(IJavaScriptProject project) throws JavaScriptModelException {
        Collection sourceRoots = RefactoringScopeFactory.getAllSourceRootsInProjects(RefactoringScopeFactory.getReferencingProjects(project));
        return sourceRoots.toArray(new IPackageFragmentRoot[sourceRoots.size()]);
    }

    private static Collection getAllSourceRootsInProjects(Collection projects) throws JavaScriptModelException {
        ArrayList result = new ArrayList();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            result.addAll(RefactoringScopeFactory.getSourceRoots((IJavaScriptProject)it.next()));
        }
        return result;
    }

    private static IIncludePathEntry getReferencingClassPathEntry(IJavaScriptProject referencingProject, IJavaScriptProject referencedProject) throws JavaScriptModelException {
        IIncludePathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IIncludePathEntry[] classpath = referencingProject.getResolvedIncludepath(true);
        int i = 0;
        while (i < classpath.length) {
            IIncludePathEntry entry = classpath[i];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++i;
        }
        return result;
    }

    private static IJavaScriptProject[] getRelatedProjects(IJavaScriptProject focus) throws CoreException {
        HashSet<IJavaScriptProject> projects = new HashSet<IJavaScriptProject>();
        RefactoringScopeFactory.addRelatedReferencing(focus, projects);
        RefactoringScopeFactory.addRelatedReferenced(focus, projects);
        projects.add(focus);
        return projects.toArray(new IJavaScriptProject[projects.size()]);
    }

    private static Collection getReferencingProjects(IJavaScriptProject focus) throws JavaScriptModelException {
        HashSet<IJavaScriptProject> projects = new HashSet<IJavaScriptProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private static List getSourceRoots(IJavaScriptProject javaProject) throws JavaScriptModelException {
        ArrayList<IPackageFragmentRoot> elements = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isArchive()) {
                elements.add(root);
            }
            ++i;
        }
        return elements;
    }

    private static int getVisibility(IMember member) throws JavaScriptModelException {
        if (JdtFlags.isPrivate(member)) {
            return 0;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 1;
        }
        return 4;
    }

    private RefactoringScopeFactory() {
    }
}

