/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.AbstractModelElementRenameChange;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameSourceModuleChange
extends AbstractModelElementRenameChange {
    public RenameSourceModuleChange(RefactoringDescriptor descriptor, ISourceModule unit, String newName, String comment) {
        this(descriptor, ResourceUtil.getResource((ISourceModule)unit).getFullPath(), unit.getElementName(), newName, comment, -1L);
        Assert.isTrue((!unit.isReadOnly() ? 1 : 0) != 0, (String)"compilation unit must not be read-only");
    }

    private RenameSourceModuleChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        super(descriptor, resourcePath, oldName, newName, comment, stampToRestore);
    }

    @Override
    protected IPath createNewPath() {
        if (this.getResourcePath().getFileExtension() != null) {
            return this.getResourcePath().removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) throws ModelException {
        return new RenameSourceModuleChange(null, this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        ISourceModule cu = (ISourceModule)this.getModifiedElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }

    public String getName() {
        return MessageFormat.format(RefactoringCoreMessages.RenameSourceModuleChange_name, this.getOldName(), this.getNewName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 7);
    }
}

