/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.Category;
import org.eclipse.mylyn.internal.tasks.ui.ConnectorBrand;
import org.eclipse.mylyn.internal.tasks.ui.IBrandManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.DisconnectRepositoryAction;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;

public class TaskRepositoryLabelProvider
implements ILabelProvider {
    public Image getColumnImage(Object obj, int index) {
        if (index == 0) {
            return this.getImage(obj);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Image getImage(Object object) {
        if (object instanceof Category) {
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.CATEGORY);
        }
        Object object2 = object;
        if (object2 instanceof AbstractRepositoryConnector) {
            void repositoryConnector;
            AbstractRepositoryConnector abstractRepositoryConnector = (AbstractRepositoryConnector)object2;
            AbstractRepositoryConnector cfr_ignored_0 = (AbstractRepositoryConnector)object2;
            Image image = this.getBrandManager().getDefaultBrandingIcon(repositoryConnector.getConnectorKind());
            if (image != null) {
                return image;
            }
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY);
        }
        Object object3 = object;
        if (object3 instanceof ConnectorBrand) {
            void connectorBrand;
            ConnectorBrand image = (ConnectorBrand)object3;
            ConnectorBrand cfr_ignored_1 = (ConnectorBrand)object3;
            Image image2 = this.getBrandManager().getBrandingIcon(connectorBrand.getConnector().getConnectorKind(), connectorBrand.getBrandId());
            if (image2 != null) {
                return image2;
            }
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY);
        }
        if (object instanceof TaskRepository) {
            if (((TaskRepository)object).isOffline()) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_OFFLINE);
            }
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getText(Object object) {
        Object object2 = object;
        if (object2 instanceof TaskRepository) {
            void repository;
            TaskRepository taskRepository = (TaskRepository)object2;
            TaskRepository cfr_ignored_0 = (TaskRepository)object2;
            StringBuilder label = new StringBuilder();
            label.append(repository.getRepositoryLabel());
            if (repository.isOffline()) {
                label.append(" [" + DisconnectRepositoryAction.LABEL + "]");
            }
            return label.toString();
        }
        if (object instanceof AbstractRepositoryConnector) {
            return ((AbstractRepositoryConnector)object).getLabel();
        }
        Object object3 = object;
        if (object3 instanceof ConnectorBrand) {
            void connectorBrand;
            ConnectorBrand label = (ConnectorBrand)object3;
            ConnectorBrand cfr_ignored_1 = (ConnectorBrand)object3;
            return this.getBrandManager().getConnectorLabel(connectorBrand.getConnector(), connectorBrand.getBrandId());
        }
        if (object instanceof Category) {
            return ((Category)object).getLabel();
        }
        return null;
    }

    protected IBrandManager getBrandManager() {
        return TasksUiPlugin.getDefault().getBrandManager();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

