/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.logger.RuntimeLoggerInterpreterImpl;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;

public final class InterpretationContext {
    private List<String> variables;
    private final RuntimeLoggerInterpreterImpl implementation;

    private InterpretationContext(RuntimeLoggerInterpreter interpreter) {
        if (!(interpreter instanceof RuntimeLoggerInterpreterImpl)) {
            throw new UnsupportedOperationException("This context can only operate on specific implementation.");
        }
        this.implementation = (RuntimeLoggerInterpreterImpl)interpreter;
    }

    public RuntimeLoggerInterpreter getInterpreter() {
        return this.implementation;
    }

    public void setVariable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        this.variables.add(name);
        this.implementation.getDecorated().setVariable(name, value);
    }

    public void setVariables(Map<String, ? extends Object> values) {
        values.forEach((key, value) -> this.setVariable((String)key, value));
    }

    public void setLogError(boolean log) {
        this.implementation.setLogError(log);
    }

    private void close() {
        if (this.variables != null) {
            this.variables.forEach(it -> this.implementation.getDecorated().unSetVariable(it));
        }
        this.setLogError(true);
    }

    public static void with(RuntimeLoggerInterpreter interpreter, Consumer<InterpretationContext> task) {
        try (InterpretationContext ctx = new InterpretationContext(interpreter);){
            task.accept(ctx);
        }
    }

    public static <T> T with(RuntimeLoggerInterpreter interpreter, Function<InterpretationContext, T> task) {
        try (InterpretationContext ctx = new InterpretationContext(interpreter);){
            T t = task.apply(ctx);
            return t;
        }
    }

    public static void with(IInterpreter interpreter, Consumer<InterpretationContext> task) {
        InterpretationContext.with(RuntimeLoggerManager.INSTANCE.decorate(interpreter), task);
    }

    public static <T> T with(IInterpreter interpreter, Function<InterpretationContext, T> task) {
        return InterpretationContext.with(RuntimeLoggerManager.INSTANCE.decorate(interpreter), task);
    }

    public static void with(EObject context, Consumer<InterpretationContext> task) {
        InterpretationContext.with(InterpreterUtil.getInterpreter(context), task);
    }

    public static <T> T with(EObject context, Function<InterpretationContext, T> task) {
        return InterpretationContext.with(InterpreterUtil.getInterpreter(context), task);
    }
}

