/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace;

import java.nio.ByteOrder;
import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.CtfCoreLoggerUtil;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonPreambleMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.Messages;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.ByteOrderParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace.UUIDParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace.VersionNumberParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TraceDeclarationParser
extends AbstractScopedCommonTreeParser {
    public static final TraceDeclarationParser INSTANCE = new TraceDeclarationParser();

    private TraceDeclarationParser() {
    }

    @Override
    public CTFTrace parse(ICTFMetadataNode traceDecl, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        CTFTrace trace = ((Param)param).fTrace;
        DeclarationScope scope = ((Param)param).fCurrentScope;
        if (traceDecl instanceof JsonPreambleMetadataNode) {
            int version = ((JsonPreambleMetadataNode)traceDecl).getVersion();
            if (version != 2) {
                throw new ParseException("invalid version of trace");
            }
            trace.setMajor(version);
            UUID uuid = ((JsonPreambleMetadataNode)traceDecl).getUuid();
            if (uuid != null) {
                TraceDeclarationParser.uuidIsConsistent(trace, uuid);
            }
        } else if (traceDecl instanceof CTFAntlrMetadataNode) {
            ICTFMetadataNode leftNode = traceDecl.getChild(0);
            ICTFMetadataNode rightNode = traceDecl.getChild(1);
            List<ICTFMetadataNode> leftStrings = leftNode.getChildren();
            if (!TsdlUtils.isAnyUnaryString(leftStrings.get(0))) {
                throw new ParseException("Left side of CTF assignment must be a string");
            }
            String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
            if (left.equals("major")) {
                if (trace.majorIsSet()) {
                    throw new ParseException("major is already set");
                }
                trace.setMajor(VersionNumberParser.INSTANCE.parse(rightNode, null));
            } else if (left.equals("minor")) {
                if (trace.minorIsSet()) {
                    throw new ParseException("minor is already set");
                }
                trace.setMinor(VersionNumberParser.INSTANCE.parse(rightNode, null));
            } else if (left.equals("uuid")) {
                UUID uuid = UUIDParser.INSTANCE.parse(rightNode, null);
                TraceDeclarationParser.uuidIsConsistent(trace, uuid);
            } else if (left.equals("byte_order")) {
                ByteOrder byteOrder = ByteOrderParser.INSTANCE.parse(rightNode, new ByteOrderParser.Param(trace));
                if (trace.getByteOrder() != null) {
                    if (trace.getByteOrder() != byteOrder) {
                        throw new ParseException("Endianness mismatch. Magic number byte order is " + String.valueOf(trace.getByteOrder()) + " but metadata byte order is " + String.valueOf(byteOrder));
                    }
                } else {
                    trace.setByteOrder(byteOrder);
                    DeclarationScope currentScope = scope;
                    for (String type : currentScope.getTypeNames()) {
                        IDeclaration d = currentScope.lookupType(type);
                        if (d instanceof IntegerDeclaration) {
                            TraceDeclarationParser.addByteOrder(byteOrder, currentScope, type, (IntegerDeclaration)d);
                            continue;
                        }
                        if (d instanceof FloatDeclaration) {
                            TraceDeclarationParser.addByteOrder(byteOrder, currentScope, type, (FloatDeclaration)d);
                            continue;
                        }
                        if (d instanceof EnumDeclaration) {
                            TraceDeclarationParser.addByteOrder(byteOrder, currentScope, type, (EnumDeclaration)d);
                            continue;
                        }
                        if (!(d instanceof StructDeclaration)) continue;
                        this.setAlign(currentScope, (StructDeclaration)d, byteOrder);
                    }
                }
            } else if (left.equals("packet.header")) {
                if (trace.packetHeaderIsSet()) {
                    throw new ParseException("packet.header already defined");
                }
                ICTFMetadataNode typeSpecifier = rightNode.getChild(0);
                if (!CTFParser.tokenNames[117].equals(typeSpecifier.getType())) {
                    throw new ParseException("packet.header expects a type specifier");
                }
                IDeclaration packetHeaderDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(trace, null, null, scope));
                if (!(packetHeaderDecl instanceof StructDeclaration)) {
                    throw new ParseException("packet.header expects a struct");
                }
                trace.setPacketHeader((StructDeclaration)packetHeaderDecl);
            } else {
                CtfCoreLoggerUtil.logWarning(Messages.IOStructGen_UnknownTraceAttributeWarning + " " + left);
            }
        }
        return trace;
    }

    public static void uuidIsConsistent(CTFTrace trace, UUID uuid) throws ParseException {
        if (trace.uuidIsSet()) {
            if (trace.getUUID().compareTo(uuid) != 0) {
                throw new ParseException("UUID mismatch. Packet uuid is " + String.valueOf(trace.getUUID()) + " but metadata uuid is " + String.valueOf(uuid));
            }
        } else {
            trace.setUUID(uuid);
        }
    }

    private static void addByteOrder(ByteOrder byteOrder, DeclarationScope parentScope, String name, IntegerDeclaration decl) throws ParseException {
        if (!decl.isByteOrderSet()) {
            IntegerDeclaration newI = IntegerDeclaration.createDeclaration(decl.getLength(), decl.isSigned(), decl.getBase(), byteOrder, decl.getEncoding(), decl.getClock(), decl.getAlignment(), null);
            parentScope.replaceType(name, newI);
        }
    }

    private static void addByteOrder(ByteOrder byteOrder, DeclarationScope parentScope, String name, EnumDeclaration decl) throws ParseException {
        if (!decl.isByteOrderSet()) {
            IntegerDeclaration containerType = decl.getContainerType();
            EnumDeclaration newEnum = new EnumDeclaration(IntegerDeclaration.createDeclaration(containerType.getLength(), containerType.isSigned(), containerType.getBase(), byteOrder, containerType.getEncoding(), containerType.getClock(), containerType.getAlignment(), null), decl.getLookupTable());
            parentScope.replaceType(name, newEnum);
        }
    }

    private static void addByteOrder(ByteOrder byteOrder, DeclarationScope parentScope, String name, FloatDeclaration decl) throws ParseException {
        if (!decl.isByteOrderSet()) {
            FloatDeclaration newFloat = new FloatDeclaration(decl.getExponent(), decl.getMantissa(), byteOrder, decl.getAlignment());
            parentScope.replaceType(name, newFloat);
        }
    }

    private void setAlign(DeclarationScope parentScope, StructDeclaration sd, ByteOrder byteOrder) throws ParseException {
        for (String s : sd.getFieldsList()) {
            IntegerDeclaration decl;
            IDeclaration d = sd.getField(s);
            if (d instanceof StructDeclaration) {
                this.setAlign(parentScope, (StructDeclaration)d, byteOrder);
                continue;
            }
            if (d instanceof VariantDeclaration) {
                this.setAlign(parentScope, (VariantDeclaration)d, byteOrder);
                continue;
            }
            if (!(d instanceof IntegerDeclaration) || (decl = (IntegerDeclaration)d).getByteOrder() == byteOrder) continue;
            IntegerDeclaration newI = IntegerDeclaration.createDeclaration(decl.getLength(), decl.isSigned(), decl.getBase(), byteOrder, decl.getEncoding(), decl.getClock(), decl.getAlignment(), null);
            sd.addField(s, newI);
        }
    }

    private void setAlign(DeclarationScope parentScope, VariantDeclaration vd, ByteOrder byteOrder) throws ParseException {
        for (String s : vd.getFields().keySet()) {
            IDeclaration d = vd.getFields().get(s);
            if (d instanceof StructDeclaration) {
                this.setAlign(parentScope, (StructDeclaration)d, byteOrder);
                continue;
            }
            if (!(d instanceof IntegerDeclaration)) continue;
            IntegerDeclaration decl = (IntegerDeclaration)d;
            IntegerDeclaration newI = IntegerDeclaration.createDeclaration(decl.getLength(), decl.isSigned(), decl.getBase(), byteOrder, decl.getEncoding(), decl.getClock(), decl.getAlignment(), null);
            vd.getFields().put(s, newI);
        }
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fCurrentScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope currentScope) {
            this.fTrace = trace;
            this.fCurrentScope = currentScope;
        }
    }
}

