/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.communication.timeless;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.PhasedSelector;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public class SingletonCommunicationGroup
extends CommunicationGroup {
    private Mailbox mailbox;

    public SingletonCommunicationGroup(CommunicationTracker tracker, Node representative, int identifier) {
        super(tracker, representative, identifier);
    }

    @Override
    public void deliverMessages() {
        this.mailbox.deliverAll(PhasedSelector.DEFAULT);
    }

    @Override
    public boolean isEmpty() {
        return this.mailbox == null;
    }

    @Override
    public void notifyHasMessage(Mailbox mailbox, MessageSelector kind) {
        if (kind == PhasedSelector.DEFAULT) {
            this.mailbox = mailbox;
            if (!this.isEnqueued) {
                this.tracker.activateUnenqueued(this);
            }
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + kind);
        }
    }

    @Override
    public void notifyLostAllMessages(Mailbox mailbox, MessageSelector kind) {
        if (kind != PhasedSelector.DEFAULT) {
            throw new IllegalArgumentException("Unsupported message kind " + kind);
        }
        this.mailbox = null;
        this.tracker.deactivate(this);
    }

    @Override
    public Map<MessageSelector, Collection<Mailbox>> getMailboxes() {
        if (this.mailbox != null) {
            return Collections.singletonMap(PhasedSelector.DEFAULT, Collections.singleton(this.mailbox));
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isRecursive() {
        return false;
    }
}

