/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.snapping.BaselineComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentAttachmentInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.ContainerSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.IndentedComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoints;
import org.eclipse.wb.internal.core.utils.Debug;
import org.eclipse.wb.internal.core.utils.Pair;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class PlacementsSupport {
    private final IVisualDataProvider m_visualDataProvider;
    private final IFeedbackProxy m_feedbackProxy;
    private final List<IAbstractComponentInfo> m_allWidgets;
    private List<IAbstractComponentInfo> m_operatingWidgets;
    private SnapPoints m_snapPoints;
    private final PlacementInfo m_x = new PlacementInfo();
    private final PlacementInfo m_y = new PlacementInfo();
    private Rectangle m_bounds;
    private final Map<IAbstractComponentInfo, Rectangle> m_newModelBounds = new HashMap<IAbstractComponentInfo, Rectangle>();
    private final Map<IAbstractComponentInfo, Rectangle> m_oldModelBounds = new HashMap<IAbstractComponentInfo, Rectangle>();
    private final Map<IAbstractComponentInfo, Integer[]> m_effectiveAlignments = new HashMap<IAbstractComponentInfo, Integer[]>();
    private final IAbsoluteLayoutCommands m_layoutCommands;
    private int m_resizeDirection;
    private boolean m_isCreating;
    private boolean m_adjustingAttached;

    public PlacementsSupport(IVisualDataProvider visualDataProvider, IFeedbackProxy feedbackProxy, IAbsoluteLayoutCommands layout, List<? extends IAbstractComponentInfo> allWidgets) {
        this.m_visualDataProvider = visualDataProvider;
        this.m_feedbackProxy = feedbackProxy;
        this.m_layoutCommands = layout;
        this.m_snapPoints = new SnapPoints(visualDataProvider, feedbackProxy, allWidgets);
        this.m_allWidgets = new ArrayList<IAbstractComponentInfo>(allWidgets);
    }

    private PlacementsSupport(IAbstractComponentInfo widget, IVisualDataProvider visualDataProvider, IAbsoluteLayoutCommands layoutCommands, List<? extends IAbstractComponentInfo> remainingWidgets) {
        this(visualDataProvider, null, layoutCommands, remainingWidgets);
        this.m_bounds = PlacementUtils.getTranslatedBounds(visualDataProvider, widget);
        this.m_operatingWidgets = List.of(widget);
    }

    public Rectangle getBounds() {
        return this.m_bounds.getCopy();
    }

    public void drag(Point location, IAbstractComponentInfo widget, Rectangle widgetBounds, int resizeDirection) {
        this.m_resizeDirection = resizeDirection;
        this.m_isCreating = widget.getModelBounds() == null;
        this.m_bounds = widgetBounds.getCopy();
        this.m_operatingWidgets = List.of(widget);
        this.m_snapPoints.processBounds(this, location, this.m_operatingWidgets, resizeDirection);
        this.m_newModelBounds.put(widget, this.m_bounds.getCopy());
    }

    public void drag(Point location, List<IAbstractComponentInfo> widgets, Rectangle widgetsUnionBounds, List<Rectangle> relativeBounds) {
        this.drag(location, widgets, widgetsUnionBounds, relativeBounds, 0);
    }

    public void drag(Point location, List<IAbstractComponentInfo> widgets, Rectangle widgetsUnionBounds, List<Rectangle> relativeBounds, int resizeDirection) {
        this.m_resizeDirection = resizeDirection;
        this.setOperatingWidgets(widgets);
        Assert.isTrue(widgets.size() == relativeBounds.size());
        this.m_bounds = widgetsUnionBounds.getCopy();
        this.m_snapPoints.processBounds(this, location, this.m_operatingWidgets, resizeDirection);
        int i = 0;
        while (i < widgets.size()) {
            IAbstractComponentInfo widget = widgets.get(i);
            Rectangle relativeRect = relativeBounds.get(i);
            Rectangle modelBounds = this.m_bounds.getTranslated(relativeRect.x, relativeRect.y);
            modelBounds.setSize(relativeRect.getSize());
            if (this.isResizing()) {
                if (PlacementUtils.hasHorizontalResizeSide(resizeDirection)) {
                    modelBounds.setRight(this.m_bounds.right());
                }
                if (PlacementUtils.hasVerticalResizeSide(resizeDirection)) {
                    modelBounds.setBottom(this.m_bounds.bottom());
                }
            }
            this.m_newModelBounds.put(widget, modelBounds);
            ++i;
        }
    }

    public void commit() throws Exception {
        this.doCommit();
        this.cleanup();
    }

    public void commitAdd() throws Exception {
        this.doCommit();
        this.addWidgets();
        this.cleanup();
    }

    public void delete(List<IAbstractComponentInfo> widgets) throws Exception {
        this.setOperatingWidgets(widgets);
        this.preprocess();
        this.postprocess();
        this.removeWidgets(widgets);
        this.cleanup();
    }

    public void clearFeedbacks() {
        this.m_snapPoints.removeFeedbacks();
    }

    public void cleanup() {
        this.m_operatingWidgets = null;
        this.m_resizeDirection = 0;
        this.m_x.cleanup();
        this.m_y.cleanup();
        this.m_newModelBounds.clear();
        this.m_oldModelBounds.clear();
        this.m_effectiveAlignments.clear();
        this.clearFeedbacks();
    }

    void doDrag(int[] mouseMoveDirection, SnapPoint[] snappedPoints) {
        PlacementInfo xPlacement = this.getPlacementInfoX();
        xPlacement.setDirection(mouseMoveDirection[0]);
        this.setAttachmentType(xPlacement, snappedPoints[0]);
        this.checkAttachedToWidget(xPlacement, snappedPoints[0]);
        this.findNeighbors(xPlacement, true);
        this.findOverlappings(xPlacement, true);
        PlacementInfo yPlacement = this.getPlacementInfoY();
        yPlacement.setDirection(mouseMoveDirection[1]);
        this.setAttachmentType(yPlacement, snappedPoints[1]);
        this.checkAttachedToWidget(yPlacement, snappedPoints[1]);
        this.findNeighbors(yPlacement, false);
        this.findOverlappings(yPlacement, false);
    }

    private void findNeighbors() {
        this.findNeighbors(this.getPlacementInfoX(), true);
        this.findNeighbors(this.getPlacementInfoY(), false);
    }

    private void checkAttachedToWidget(PlacementInfo placement, SnapPoint snapPoint) {
        if (placement.getAttachmentType() == PlacementInfo.AttachmentTypes.Component) {
            ComponentSnapPoint componentSnapPoint = (ComponentSnapPoint)snapPoint;
            placement.setAttachedToWidget(componentSnapPoint.getComponent());
            int direction = placement.getDirection();
            if (componentSnapPoint.getGap() != 0) {
                boolean isNeighbor;
                boolean bl = isNeighbor = !PlacementUtils.isLeadingSide(componentSnapPoint.getSide()) == (direction == 0);
                if (isNeighbor) {
                    placement.getNeighbors()[direction] = componentSnapPoint.getComponent();
                    placement.getDistances()[direction] = componentSnapPoint.getGap();
                }
            }
        } else if (placement.getAttachmentType() == PlacementInfo.AttachmentTypes.ComponentWithOffset) {
            int direction = placement.getDirection();
            IndentedComponentSnapPoint componentSnapPoint = (IndentedComponentSnapPoint)snapPoint;
            placement.setAttachedToWidget(componentSnapPoint.getComponent());
            placement.getDistances()[direction] = 10;
        } else if (placement.getAttachmentType() == PlacementInfo.AttachmentTypes.Baseline) {
            placement.setAttachedToWidget(((ComponentSnapPoint)snapPoint).getComponent());
        }
    }

    private void findOverlappings(PlacementInfo placement, boolean isHorizontal) {
        Transposer t = new Transposer(!isHorizontal);
        Rectangle componentsBounds = t.t(this.m_bounds.getCopy());
        Interval componentsWidth = new Interval(componentsBounds.x, componentsBounds.width);
        int componentsWidthCenter = componentsWidth.center();
        Interval componentsHeight = new Interval(componentsBounds.y, componentsBounds.height);
        List<IAbstractComponentInfo>[] overlappings = placement.getOverlappings();
        int[] distances = placement.getDistances();
        List<IAbstractComponentInfo> remainingComponents = this.getRemainingWidgets();
        for (IAbstractComponentInfo component : remainingComponents) {
            Interval childComponentWidth;
            Rectangle childComponentBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, component));
            Interval childComponentHeight = new Interval(childComponentBounds.y, childComponentBounds.height);
            if (!componentsHeight.intersects(childComponentHeight) || !(childComponentWidth = new Interval(childComponentBounds.x, childComponentBounds.width)).intersects(componentsWidth)) continue;
            Interval intersection = componentsWidth.getIntersection(childComponentWidth);
            int distance = -intersection.length();
            int childComponentCenter = childComponentWidth.center();
            int direction = childComponentCenter > componentsWidthCenter ? 1 : 0;
            overlappings[direction].add(component);
            if (distances[direction] <= distance) continue;
            distances[direction] = distance;
        }
    }

    private void findNeighbors(PlacementInfo placement, boolean isHorizontal) {
        this.findNeighbor(0, placement, isHorizontal);
        this.findNeighbor(1, placement, isHorizontal);
    }

    private void findNeighbor(int direction, PlacementInfo placement, boolean isHorizontal) {
        IAbstractComponentInfo[] neighbors = placement.getNeighbors();
        int[] distances = placement.getDistances();
        if (neighbors[direction] == null) {
            Transposer t = new Transposer(!isHorizontal);
            Rectangle widgetsBounds = t.t(this.m_bounds.getCopy());
            Interval widgetsWidth = new Interval(widgetsBounds.x, widgetsBounds.width);
            Interval widgetsHeight = new Interval(widgetsBounds.y, widgetsBounds.height);
            List<IAbstractComponentInfo> remainingWidgets = this.getRemainingWidgets();
            for (IAbstractComponentInfo widget : remainingWidgets) {
                int distance;
                Interval possibleNeighborWidth;
                Rectangle possibleNeighborBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget));
                Interval possibleNeighborHeight = new Interval(possibleNeighborBounds.y, possibleNeighborBounds.height);
                if (!widgetsHeight.intersects(possibleNeighborHeight) || (possibleNeighborWidth = new Interval(possibleNeighborBounds.x, possibleNeighborBounds.width)).intersects(widgetsWidth)) continue;
                if (direction == 0 && possibleNeighborWidth.isLeadingOf(widgetsWidth)) {
                    distance = widgetsWidth.distance(possibleNeighborWidth.end());
                    if (distances[direction] <= distance) continue;
                    distances[direction] = distance;
                    neighbors[direction] = widget;
                    continue;
                }
                if (direction != 1 || !possibleNeighborWidth.isTrailingOf(widgetsWidth) || distances[direction] <= (distance = widgetsWidth.distance(possibleNeighborWidth.begin()))) continue;
                distances[direction] = distance;
                neighbors[direction] = widget;
            }
            if (neighbors[direction] == null && placement.getAttachmentType() != PlacementInfo.AttachmentTypes.ComponentWithOffset) {
                Dimension containerSize = t.t(this.m_visualDataProvider.getContainerSize());
                distances[direction] = direction == 0 ? widgetsWidth.begin() : containerSize.width - widgetsWidth.end();
            }
        }
    }

    private void setAttachmentType(PlacementInfo placement, SnapPoint snapPoint) {
        if (snapPoint != null) {
            if (snapPoint instanceof BaselineComponentSnapPoint) {
                placement.setAttachmentType(PlacementInfo.AttachmentTypes.Baseline);
                return;
            }
            if (snapPoint instanceof IndentedComponentSnapPoint) {
                placement.setAttachmentType(PlacementInfo.AttachmentTypes.ComponentWithOffset);
                return;
            }
            if (snapPoint instanceof ComponentSnapPoint) {
                placement.setAttachmentType(PlacementInfo.AttachmentTypes.Component);
                return;
            }
            if (snapPoint instanceof ContainerSnapPoint) {
                placement.setAttachmentType(PlacementInfo.AttachmentTypes.Container);
                return;
            }
        }
        placement.setAttachmentType(PlacementInfo.AttachmentTypes.Free);
    }

    private void doCommit() throws Exception {
        this.preprocess();
        if (this.isResizing()) {
            if (this.isCreating()) {
                this.place();
            }
            IAbstractComponentInfo widget = this.m_operatingWidgets.get(0);
            this.resize(widget);
        } else {
            this.place();
        }
        this.postprocess();
    }

    private void place() throws Exception {
        if (this.m_operatingWidgets.size() > 1) {
            this.placeMultipleWidgets();
        } else {
            this.placeSingleWidget();
        }
    }

    private void placeMultipleWidgets() throws Exception {
        for (IAbstractComponentInfo widget : this.m_operatingWidgets) {
            this.placeSingleWidget(widget, true);
            this.placeSingleWidget(widget, false);
        }
    }

    private boolean isAttachedWithinOperatingWidgets(IAbstractComponentInfo widget, int side) throws Exception {
        if (this.m_adjustingAttached) {
            return false;
        }
        IAbstractComponentInfo attachedToWidget = this.m_layoutCommands.getAttachedToWidget(widget, side);
        return attachedToWidget != null && this.m_operatingWidgets.contains(attachedToWidget);
    }

    private void placeSingleWidget() throws Exception {
        IAbstractComponentInfo widget = this.m_operatingWidgets.get(0);
        this.placeSingleWidget(widget, true);
        this.placeSingleWidget(widget, false);
    }

    private void placeSingleWidget(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        PlacementInfo placementInfo = this.getPlacementInfo(isHorizontal);
        if (!this.isOverlapped(isHorizontal)) {
            if (placementInfo.getAttachedToWidget() == null) {
                this.placeFreely(widget, placementInfo, isHorizontal);
            } else {
                this.placeAttachedToWidget(widget, placementInfo, isHorizontal);
            }
        } else {
            Debug.println("move overlapping");
        }
    }

    private void placeAttachedToWidget(IAbstractComponentInfo widget, PlacementInfo placementInfo, boolean isHorizontal) throws Exception {
        IAbstractComponentInfo attachedToWidget = placementInfo.getAttachedToWidget();
        int direction = placementInfo.getDirection();
        int side = PlacementUtils.getSide(isHorizontal, direction == 0);
        int oppositeSide = PlacementUtils.getOppositeSide(side);
        boolean isAttachedOpposite = this.m_layoutCommands.isAttached(widget, side) && this.m_layoutCommands.isAttached(widget, oppositeSide);
        this.m_layoutCommands.detach(widget, side);
        if (attachedToWidget == placementInfo.getNeighbors()[direction]) {
            this.m_layoutCommands.attachWidgetSequientially(widget, attachedToWidget, side, placementInfo.getDistances()[direction]);
        } else if (PlacementInfo.AttachmentTypes.Baseline == placementInfo.getAttachmentType()) {
            this.m_layoutCommands.attachWidgetBaseline(widget, attachedToWidget);
        } else {
            int distance = placementInfo.getAttachmentType() == PlacementInfo.AttachmentTypes.ComponentWithOffset ? placementInfo.getDistances()[direction] : 0;
            this.m_layoutCommands.attachWidgetParallelly(widget, attachedToWidget, side, distance);
        }
        if (isAttachedOpposite) {
            this.m_layoutCommands.adjustAttachmentOffset(widget, oppositeSide, this.getMoveDelta(widget, isHorizontal));
        } else if (PlacementInfo.AttachmentTypes.Baseline == placementInfo.getAttachmentType()) {
            this.m_layoutCommands.detach(widget, 32);
        } else {
            this.m_layoutCommands.detach(widget, oppositeSide);
        }
    }

    private void placeFreely(IAbstractComponentInfo widget, PlacementInfo placementInfo, boolean isHorizontal) throws Exception {
        int[] distances = placementInfo.getDistances();
        int alignment = distances[1] < distances[0] ? 1 : 0;
        this.placeFreelyUsingAlignment(widget, placementInfo, isHorizontal, alignment);
    }

    private void placeFreelyUsingAlignment(IAbstractComponentInfo widget, PlacementInfo placementInfo, boolean isHorizontal, int alignment) throws Exception {
        boolean isAttachedBothSides;
        int[] distances = placementInfo.getDistances();
        int side = PlacementUtils.getSide(isHorizontal, alignment == 0);
        int oppositeSide = PlacementUtils.getOppositeSide(side);
        boolean bl = isAttachedBothSides = this.m_layoutCommands.isAttached(widget, side) && this.m_layoutCommands.isAttached(widget, oppositeSide);
        if (!this.isAttachedWithinOperatingWidgets(widget, side)) {
            this.m_layoutCommands.detach(widget, side);
            IAbstractComponentInfo[] neighbors = placementInfo.getNeighbors();
            int distance = distances[alignment] + this.getWidgetRelativeDistance(widget, isHorizontal, alignment == 0);
            if (neighbors[alignment] == null) {
                this.m_layoutCommands.attachAbsolute(widget, side, distance);
            } else {
                this.m_layoutCommands.attachWidgetSequientially(widget, neighbors[alignment], side, distance);
            }
        }
        if (this.m_adjustingAttached && this.isResizing()) {
            return;
        }
        if (isAttachedBothSides) {
            this.m_layoutCommands.adjustAttachmentOffset(widget, oppositeSide, this.getMoveDelta(widget, isHorizontal));
        } else if (!this.isAttachedWithinOperatingWidgets(widget, oppositeSide)) {
            this.m_layoutCommands.detach(widget, oppositeSide);
        }
    }

    private int getMoveDelta(IAbstractComponentInfo widget, boolean isHorizontal) {
        Rectangle movedBounds = this.m_newModelBounds.get(widget);
        Rectangle originalBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget);
        return isHorizontal ? movedBounds.x - originalBounds.x : movedBounds.y - originalBounds.y;
    }

    private int getWidgetRelativeDistance(IAbstractComponentInfo widget, boolean isHorizontal, boolean isLeading) {
        if (this.m_operatingWidgets.size() > 1 && !this.m_adjustingAttached) {
            if (isHorizontal) {
                if (isLeading) {
                    return this.m_newModelBounds.get((Object)widget).x - this.m_bounds.x;
                }
                return this.m_bounds.right() - this.m_newModelBounds.get(widget).right();
            }
            if (isLeading) {
                return this.m_newModelBounds.get((Object)widget).y - this.m_bounds.y;
            }
            return this.m_bounds.bottom() - this.m_newModelBounds.get(widget).bottom();
        }
        return 0;
    }

    private PlacementInfo findNeighborsOfWidget(IAbstractComponentInfo widget, boolean isHorizontal) {
        PlacementsSupport placementsSupport = new PlacementsSupport(widget, this.m_visualDataProvider, this.m_layoutCommands, this.getNonDeletedWidgets());
        placementsSupport.findNeighbors();
        return placementsSupport.getPlacementInfo(isHorizontal);
    }

    private void resize(IAbstractComponentInfo widget) throws Exception {
        if (PlacementUtils.hasHorizontalResizeSide(this.m_resizeDirection)) {
            this.resizeWidget(widget, true);
        }
        if (PlacementUtils.hasVerticalResizeSide(this.m_resizeDirection)) {
            this.resizeWidget(widget, false);
        }
    }

    private void resizeWidget(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        PlacementInfo placementInfo = this.getPlacementInfo(isHorizontal);
        int side = PlacementUtils.extractResizingSide(isHorizontal, this.m_resizeDirection);
        int resizeDelta = this.getResizeDelta(side, widget, isHorizontal);
        int oppositeSide = PlacementUtils.getOppositeSide(side);
        boolean isAttachedResizingSide = this.m_layoutCommands.isAttached(widget, side);
        boolean isAttachedOppositeSide = this.m_layoutCommands.isAttached(widget, oppositeSide);
        if (!this.isOverlapped(isHorizontal)) {
            if (placementInfo.getAttachedToWidget() == null) {
                if (isAttachedResizingSide && isAttachedOppositeSide) {
                    this.adjustAttachmentOffsetOnResize(widget, side, resizeDelta);
                } else if (placementInfo.getAttachmentType() == PlacementInfo.AttachmentTypes.Container && !this.isCreating() && !isAttachedResizingSide) {
                    this.m_layoutCommands.attachAbsolute(widget, side, placementInfo.getDistances()[placementInfo.getDirection()]);
                } else {
                    this.m_layoutCommands.setExplicitSize(widget, isAttachedResizingSide ? side : oppositeSide, side, resizeDelta);
                    if (isAttachedResizingSide && !this.isCreating()) {
                        this.adjustAttachmentOffsetOnResize(widget, side, resizeDelta);
                    }
                }
            } else {
                IAbstractComponentInfo attachedToWidget = placementInfo.getAttachedToWidget();
                int direction = placementInfo.getDirection();
                int distance = placementInfo.getDistances()[direction];
                if (attachedToWidget == placementInfo.getNeighbors()[direction]) {
                    this.m_layoutCommands.attachWidgetSequientially(widget, attachedToWidget, side, distance);
                } else {
                    distance = placementInfo.getAttachmentType() == PlacementInfo.AttachmentTypes.ComponentWithOffset ? placementInfo.getDistances()[direction] : 0;
                    this.m_layoutCommands.attachWidgetParallelly(widget, attachedToWidget, side, distance);
                }
                if (!isAttachedOppositeSide) {
                    this.m_layoutCommands.setExplicitSize(widget, isAttachedResizingSide ? side : oppositeSide, side, resizeDelta);
                }
            }
        } else {
            Debug.println("resize overlapping");
        }
    }

    private void adjustAttachmentOffsetOnResize(IAbstractComponentInfo widget, int side, int resizeDelta) throws Exception {
        if (!PlacementUtils.isTrailingSide(side)) {
            resizeDelta = -resizeDelta;
        }
        this.m_layoutCommands.adjustAttachmentOffset(widget, side, resizeDelta);
    }

    private int getResizeDelta(int side, IAbstractComponentInfo widget, boolean isHorizontal) {
        Rectangle changedBounds = this.m_newModelBounds.get(widget);
        Rectangle originalBounds = this.m_oldModelBounds.get(widget);
        Dimension originalSize = originalBounds != null ? originalBounds.getSize() : widget.getPreferredSize();
        int resizeDelta = isHorizontal ? changedBounds.width - originalSize.width : changedBounds.height - originalSize.height;
        return resizeDelta;
    }

    private int getEffectiveAlignment(IAbstractComponentInfo component, boolean isHorizontal) {
        return this.m_effectiveAlignments.get(component)[isHorizontal ? 0 : 1];
    }

    private void preprocess() throws Exception {
        for (IAbstractComponentInfo widget : this.m_allWidgets) {
            int horizontal = this.findEffectiveAlignment(widget, true);
            int vertical = this.findEffectiveAlignment(widget, false);
            this.m_effectiveAlignments.put(widget, new Integer[]{horizontal, vertical});
            this.m_oldModelBounds.put(widget, PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget));
        }
    }

    private int findEffectiveAlignment(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        boolean isTrailing;
        boolean isLeading = this.isAlignedToSide(widget, isHorizontal ? 1 : 8);
        if (!(isLeading ^ (isTrailing = this.isAlignedToSide(widget, isHorizontal ? 4 : 32)))) {
            PlacementInfo placementInfo = this.findNeighborsOfWidget(widget, isHorizontal);
            int[] distances = placementInfo.getDistances();
            return distances[0] < distances[1] ? 0 : 1;
        }
        return isLeading ? 0 : 1;
    }

    private boolean isAlignedToSide(IAbstractComponentInfo widget, int side) throws Exception {
        IAbstractComponentInfo attachedTo;
        while ((attachedTo = this.m_layoutCommands.getAttachedToWidget(widget, side)) != null) {
            widget = attachedTo;
        }
        return this.m_layoutCommands.isAttached(widget, side);
    }

    private List<IAbstractComponentInfo> getRemainingWidgets() {
        return (List)CollectionUtils.subtract(this.m_allWidgets, this.m_operatingWidgets);
    }

    private List<IAbstractComponentInfo> getNonDeletedWidgets() {
        if (!CollectionUtils.isEmpty(this.m_operatingWidgets) && this.m_operatingWidgets.get(0).isDeleting()) {
            return this.getRemainingWidgets();
        }
        return new ArrayList<IAbstractComponentInfo>(this.m_allWidgets);
    }

    private PlacementInfo getPlacementInfoX() {
        return this.m_x;
    }

    private PlacementInfo getPlacementInfoY() {
        return this.m_y;
    }

    private PlacementInfo getPlacementInfo(boolean isHorizontal) {
        return isHorizontal ? this.m_x : this.m_y;
    }

    private boolean isResizing() {
        return this.m_resizeDirection != 0;
    }

    private boolean isCreating() {
        return this.m_isCreating;
    }

    private boolean isOverlapped(boolean isHorizontal) {
        PlacementInfo placementInfo = this.getPlacementInfo(isHorizontal);
        int[] distances = placementInfo.getDistances();
        return distances[0] < 0 || distances[1] < 0;
    }

    private void setOperatingWidgets(List<? extends IAbstractComponentInfo> widgets) {
        this.m_operatingWidgets = List.copyOf(widgets);
    }

    private void addWidgets() {
        for (IAbstractComponentInfo widget : this.m_operatingWidgets) {
            if (this.m_allWidgets.contains(widget)) continue;
            this.m_allWidgets.add(widget);
        }
        this.m_snapPoints = new SnapPoints(this.m_visualDataProvider, this.m_feedbackProxy, this.m_allWidgets);
    }

    private void removeWidgets(List<IAbstractComponentInfo> widgets) {
        for (IAbstractComponentInfo widget : widgets) {
            this.m_allWidgets.remove(widget);
        }
        this.m_snapPoints = new SnapPoints(this.m_visualDataProvider, this.m_feedbackProxy, this.m_allWidgets);
    }

    Rectangle getInternalBounds() {
        return this.m_bounds;
    }

    public void align(List<? extends IAbstractComponentInfo> widgets, boolean isHorizontal, int side) throws Exception {
        this.setOperatingWidgets(widgets);
        this.preprocess();
        IAbstractComponentInfo sampleWidget = widgets.get(0);
        int i = 1;
        while (i < widgets.size()) {
            IAbstractComponentInfo aligningWidget = widgets.get(i);
            PlacementInfo placementInfo = this.preparePlacementInfoAligning(sampleWidget, aligningWidget, isHorizontal, side);
            this.placeAttachedToWidget(aligningWidget, placementInfo, isHorizontal);
            ++i;
        }
        this.postprocess();
        this.cleanup();
    }

    private PlacementInfo preparePlacementInfoAligning(IAbstractComponentInfo sampleWidget, IAbstractComponentInfo widget, boolean isHorizontal, int side) {
        PlacementInfo placementInfo = new PlacementInfo();
        placementInfo.setAttachedToWidget(sampleWidget);
        int direction = PlacementUtils.getSidePosition(side);
        placementInfo.setAttachmentType(PlacementInfo.AttachmentTypes.Component);
        placementInfo.setDirection(direction);
        Transposer t = new Transposer(!isHorizontal);
        Rectangle sampleBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, sampleWidget));
        Rectangle aligningBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget));
        switch (side) {
            case 2: {
                int distance;
                placementInfo.setAttachmentType(PlacementInfo.AttachmentTypes.ComponentWithOffset);
                placementInfo.getDistances()[direction] = distance = sampleBounds.width / 2 - aligningBounds.width / 2;
                aligningBounds.x += distance;
                break;
            }
            case 1: 
            case 8: {
                aligningBounds.x = sampleBounds.x;
                break;
            }
            case 4: 
            case 32: {
                aligningBounds.x = sampleBounds.right() - aligningBounds.width;
                break;
            }
        }
        this.m_newModelBounds.put(widget, t.t(aligningBounds));
        return placementInfo;
    }

    public void replicateSize(List<? extends IAbstractComponentInfo> widgets, boolean isHorizontal) throws Exception {
        IAbstractComponentInfo widget;
        this.setOperatingWidgets(widgets);
        this.preprocess();
        IAbstractComponentInfo sampleWidget = widgets.get(0);
        int sampleSize = PlacementUtils.getSize(sampleWidget, isHorizontal);
        int i = 1;
        while (i < widgets.size()) {
            widget = widgets.get(i);
            int widgetSize = PlacementUtils.getSize(widget, isHorizontal);
            int resizeDelta = sampleSize - widgetSize;
            int leadingSide = PlacementUtils.getSide(isHorizontal, true);
            int trailingSide = PlacementUtils.getSide(isHorizontal, false);
            boolean isAttachedLeadingSide = this.m_layoutCommands.isAttached(widget, leadingSide);
            boolean isAttachedTrailingSide = this.m_layoutCommands.isAttached(widget, trailingSide);
            if (isAttachedLeadingSide && isAttachedTrailingSide) {
                this.m_layoutCommands.adjustAttachmentOffset(widget, trailingSide, resizeDelta);
            } else if (isAttachedLeadingSide && !isAttachedTrailingSide) {
                this.m_layoutCommands.setExplicitSize(widget, leadingSide, trailingSide, resizeDelta);
            } else if (!isAttachedLeadingSide && isAttachedTrailingSide) {
                this.m_layoutCommands.setExplicitSize(widget, trailingSide, leadingSide, resizeDelta);
            } else {
                this.m_layoutCommands.attachAbsolute(widget, leadingSide, 0);
                this.m_layoutCommands.setExplicitSize(widget, leadingSide, trailingSide, resizeDelta);
            }
            ++i;
        }
        i = 1;
        while (i < widgets.size()) {
            widget = widgets.get(i);
            this.m_operatingWidgets = List.of(widget);
            this.postprocess();
            ++i;
        }
        this.cleanup();
    }

    public void center(List<? extends IAbstractComponentInfo> widgets, boolean isHorizontal) throws Exception {
        this.setOperatingWidgets(widgets);
        this.preprocess();
        for (IAbstractComponentInfo iAbstractComponentInfo : widgets) {
            this.centerWidget(iAbstractComponentInfo, isHorizontal);
        }
        this.cleanup();
    }

    private void centerWidget(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        Transposer t = new Transposer(!isHorizontal);
        Rectangle widgetBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget));
        Dimension containerSize = t.t(this.m_visualDataProvider.getContainerSize());
        int position = (containerSize.width - widgetBounds.width) / 2;
        Point newPosition = new Point(position, widgetBounds.y);
        this.m_operatingWidgets = List.of(widget);
        this.moveTo(widget, t.t(newPosition));
    }

    private int calcDirection(int p1, int p2) {
        return p1 >= p2 ? 0 : 1;
    }

    /*
     * WARNING - void declaration
     */
    public void distributeSpace(List<? extends IAbstractComponentInfo> widgets, boolean isHorizontal) throws Exception {
        int x;
        Transposer t = new Transposer(!isHorizontal);
        Dimension clientArea = t.t(this.m_visualDataProvider.getContainerSize());
        int widgetsWidth = 0;
        for (IAbstractComponentInfo iAbstractComponentInfo : widgets) {
            widgetsWidth += t.t((Rectangle)PlacementUtils.getTranslatedBounds((IVisualDataProvider)this.m_visualDataProvider, (IAbstractComponentInfo)iAbstractComponentInfo)).width;
        }
        Collections.sort(widgets, (widget1, widget2) -> transposer.t((Rectangle)PlacementUtils.getTranslatedBounds((IVisualDataProvider)this.m_visualDataProvider, (IAbstractComponentInfo)widget1)).x - transposer.t((Rectangle)PlacementUtils.getTranslatedBounds((IVisualDataProvider)this.m_visualDataProvider, (IAbstractComponentInfo)widget2)).x);
        int widgetsLength = widgets.size();
        if (DesignerPlugin.isCtrlPressed() && widgetsLength > 2) {
            Rectangle rectangle = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widgets.get(0)));
            Rectangle rightBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widgets.get(widgetsLength - 1)));
            int totalWidth = rightBounds.right() - rectangle.x;
            int n = (totalWidth - widgetsWidth) / (widgetsLength - 1);
            x = rectangle.x;
        } else {
            int n;
            x = n = (clientArea.width - widgetsWidth) / (widgetsLength + 1);
        }
        for (IAbstractComponentInfo iAbstractComponentInfo : widgets) {
            void var6_11;
            Rectangle widgetBounds = t.t(PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, iAbstractComponentInfo));
            this.m_operatingWidgets = List.of(iAbstractComponentInfo);
            this.moveTo(iAbstractComponentInfo, t.t(new Point(x, widgetBounds.y)));
            x += widgetBounds.width;
            x += var6_11;
        }
    }

    private void moveTo(IAbstractComponentInfo widget, Point position) throws Exception {
        Rectangle widgetBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget);
        this.m_bounds = new Rectangle(position, widgetBounds.getSize());
        this.doDrag(new int[]{this.calcDirection(widgetBounds.x, position.x), this.calcDirection(widgetBounds.y, position.y)}, new SnapPoint[2]);
        this.m_newModelBounds.put(widget, this.m_bounds);
        this.commit();
    }

    public void setAlignment(IAbstractComponentInfo widget, int side) throws Exception {
        this.setOperatingWidgets(List.of(widget));
        this.preprocess();
        boolean isHorizontal = PlacementUtils.isHorizontalSide(side);
        int oppositeSide = PlacementUtils.getOppositeSide(side);
        boolean attachedSide = this.m_layoutCommands.isAttached(widget, side);
        boolean attachedOppositeSide = this.m_layoutCommands.isAttached(widget, oppositeSide);
        if (!attachedSide) {
            PlacementInfo placementInfo = this.findNeighborsOfWidget(widget, isHorizontal);
            this.placeFreelyUsingAlignment(widget, placementInfo, isHorizontal, PlacementUtils.getSidePosition(side));
        }
        if (attachedOppositeSide) {
            this.m_layoutCommands.detach(widget, oppositeSide);
            this.m_layoutCommands.setExplicitSize(widget, side, oppositeSide, 0);
        }
        this.postprocess();
        this.cleanup();
    }

    public void setResizeable(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        this.setOperatingWidgets(List.of(widget));
        this.preprocess();
        int leadingSide = PlacementUtils.getSide(isHorizontal, true);
        int trailingSide = PlacementUtils.getSide(isHorizontal, false);
        boolean attachedLeading = this.m_layoutCommands.isAttached(widget, leadingSide);
        boolean attachedTrailing = this.m_layoutCommands.isAttached(widget, trailingSide);
        PlacementInfo placementInfo = this.findNeighborsOfWidget(widget, isHorizontal);
        if (!attachedLeading) {
            this.attachSide(widget, placementInfo, leadingSide);
        }
        if (!attachedTrailing) {
            this.attachSide(widget, placementInfo, trailingSide);
        }
        this.postprocess();
        this.cleanup();
    }

    private void attachSide(IAbstractComponentInfo widget, PlacementInfo placementInfo, int side) throws Exception {
        IAbstractComponentInfo[] neighbors = placementInfo.getNeighbors();
        int sidePosition = PlacementUtils.getSidePosition(side);
        int distance = placementInfo.getDistances()[sidePosition];
        if (neighbors[sidePosition] == null) {
            this.m_layoutCommands.attachAbsolute(widget, side, distance);
        } else {
            this.m_layoutCommands.attachWidgetSequientially(widget, neighbors[sidePosition], side, distance);
        }
    }

    private void applyNewBounds() {
        for (IAbstractComponentInfo widget : this.m_operatingWidgets) {
            Rectangle newBounds = this.m_newModelBounds.get(widget);
            if (newBounds == null) continue;
            widget.setModelBounds(newBounds.getTranslated(this.m_visualDataProvider.getClientAreaOffset()));
        }
    }

    private void postprocess() throws Exception {
        this.applyNewBounds();
        this.keepWidgetsPositions();
        this.resolveCyclicReferences();
    }

    private void keepWidgetsPositions() throws Exception {
        List<ComponentAttachmentInfo> affectedWidgets = this.findAffectedWidgets();
        for (ComponentAttachmentInfo attachmentInfo : affectedWidgets) {
            IAbstractComponentInfo source = attachmentInfo.getSource();
            int side = attachmentInfo.getAlignment();
            boolean isHorizontal = PlacementUtils.isHorizontalSide(side);
            PlacementInfo placementInfo = this.findNeighborsOfWidget(source, isHorizontal);
            this.placeFreelyUsingAlignment2(source, placementInfo, isHorizontal, this.getEffectiveAlignment(source, isHorizontal));
        }
    }

    private void placeFreelyUsingAlignment2(IAbstractComponentInfo widget, PlacementInfo placementInfo, boolean isHorizontal, int alignment) throws Exception {
        int side = PlacementUtils.getSide(isHorizontal, alignment == 0);
        int oppositeSide = PlacementUtils.getOppositeSide(side);
        boolean isResizeable = this.isResizeable(widget, isHorizontal);
        this.m_layoutCommands.detach(widget, side);
        this.attachSide(widget, placementInfo, side);
        this.m_layoutCommands.detach(widget, oppositeSide);
        if (isResizeable) {
            this.attachSide(widget, placementInfo, oppositeSide);
        }
    }

    private boolean isResizeable(IAbstractComponentInfo widget, boolean isHorizontal) throws Exception {
        int side = PlacementUtils.getSide(isHorizontal, true);
        int oppositeSide = PlacementUtils.getOppositeSide(side);
        return this.m_layoutCommands.isAttached(widget, side) && this.m_layoutCommands.isAttached(widget, oppositeSide);
    }

    private List<ComponentAttachmentInfo> findAffectedWidgets() throws Exception {
        ArrayList<ComponentAttachmentInfo> attached = new ArrayList<ComponentAttachmentInfo>();
        List<IAbstractComponentInfo> remainingWidgets = this.getRemainingWidgets();
        for (IAbstractComponentInfo remainingWidget : remainingWidgets) {
            for (IAbstractComponentInfo operatingWidget : this.m_operatingWidgets) {
                this.checkAttached(remainingWidget, operatingWidget, attached, 1);
                this.checkAttached(remainingWidget, operatingWidget, attached, 4);
                this.checkAttached(remainingWidget, operatingWidget, attached, 8);
                this.checkAttached(remainingWidget, operatingWidget, attached, 32);
            }
        }
        return attached;
    }

    private boolean checkAttached(IAbstractComponentInfo widget, IAbstractComponentInfo targetWidget, List<ComponentAttachmentInfo> attachedList, int side) throws Exception {
        if (this.isAttachedToWidget(widget, targetWidget, side)) {
            attachedList.add(new ComponentAttachmentInfo(widget, targetWidget, side));
            return true;
        }
        return false;
    }

    private boolean isAttachedToWidget(IAbstractComponentInfo widget, IAbstractComponentInfo targetWidget, int side) throws Exception {
        return this.m_layoutCommands.getAttachedToWidget(widget, side) == targetWidget;
    }

    private void resolveCyclicReferences() throws Exception {
        this.resolveCyclicReferences(true);
        this.resolveCyclicReferences(false);
    }

    private void resolveCyclicReferences(boolean isHorizontal) throws Exception {
        List<ComponentAttachmentInfo> cyclicList = this.detectCyclicReferences(isHorizontal);
        while (!cyclicList.isEmpty()) {
            ComponentAttachmentInfo attachment = this.findReferenceToResolve(cyclicList, this.getCyclicPair(cyclicList));
            if (attachment == null) continue;
            this.resolveReference(attachment);
        }
    }

    private void resolveReference(ComponentAttachmentInfo attachment) throws Exception {
        int side = attachment.getAlignment();
        IAbstractComponentInfo widget = attachment.getSource();
        boolean isLeading = PlacementUtils.isLeadingSide(side);
        boolean isHorizontal = PlacementUtils.isHorizontalSide(side);
        Transposer t = new Transposer(!isHorizontal);
        Dimension containerSize = t.t(this.m_visualDataProvider.getContainerSize());
        Rectangle translatedBounds = PlacementUtils.getTranslatedBounds(this.m_visualDataProvider, widget);
        Interval widgetSize = isHorizontal ? translatedBounds.getHorizontalInterval() : translatedBounds.getVerticalInterval();
        int distance = isLeading ? widgetSize.begin() : containerSize.width - widgetSize.end();
        this.m_layoutCommands.attachAbsolute(widget, side, distance);
    }

    private ComponentAttachmentInfo findReferenceToResolve(List<ComponentAttachmentInfo> cyclicList, Pair<ComponentAttachmentInfo, ComponentAttachmentInfo> pair) {
        if (!this.m_operatingWidgets.contains(pair.getLeft().getSource())) {
            return pair.getLeft();
        }
        return pair.getRight();
    }

    private Pair<ComponentAttachmentInfo, ComponentAttachmentInfo> getCyclicPair(List<ComponentAttachmentInfo> cyclicList) {
        ComponentAttachmentInfo first = cyclicList.get(0);
        ComponentAttachmentInfo second = null;
        int i = 1;
        while (i < cyclicList.size()) {
            ComponentAttachmentInfo next = cyclicList.get(i);
            if (first.getSource() == next.getTarget() && next.getSource() == first.getTarget()) {
                second = next;
                break;
            }
            ++i;
        }
        cyclicList.remove(first);
        cyclicList.remove(second);
        return new Pair<ComponentAttachmentInfo, Object>(first, second);
    }

    private List<ComponentAttachmentInfo> detectCyclicReferences(boolean isHorizontal) throws Exception {
        ArrayList<ComponentAttachmentInfo> cyclicList = new ArrayList<ComponentAttachmentInfo>();
        List<IAbstractComponentInfo> widgets = this.getNonDeletedWidgets();
        for (IAbstractComponentInfo widget : widgets) {
            IAbstractComponentInfo attachedLeading = this.m_layoutCommands.getAttachedToWidget(widget, PlacementUtils.getSide(isHorizontal, true));
            IAbstractComponentInfo attachedTrailing = this.m_layoutCommands.getAttachedToWidget(widget, PlacementUtils.getSide(isHorizontal, false));
            this.traverseAttachedWidgets(cyclicList, new HashSet<IAbstractComponentInfo>(), attachedLeading, widget, isHorizontal);
            this.traverseAttachedWidgets(cyclicList, new HashSet<IAbstractComponentInfo>(), attachedTrailing, widget, isHorizontal);
        }
        return cyclicList;
    }

    private void traverseAttachedWidgets(List<ComponentAttachmentInfo> cyclicList, Set<IAbstractComponentInfo> visitedWidgets, IAbstractComponentInfo widget, IAbstractComponentInfo targetWidget, boolean isHorizontal) throws Exception {
        if (widget == null) {
            return;
        }
        if (visitedWidgets.contains(widget)) {
            return;
        }
        visitedWidgets.add(widget);
        int trailingSide = PlacementUtils.getSide(isHorizontal, false);
        int leadingSide = PlacementUtils.getSide(isHorizontal, true);
        IAbstractComponentInfo attachedLeading = this.m_layoutCommands.getAttachedToWidget(widget, leadingSide);
        IAbstractComponentInfo attachedTrailing = this.m_layoutCommands.getAttachedToWidget(widget, trailingSide);
        if (attachedLeading == targetWidget) {
            cyclicList.add(new ComponentAttachmentInfo(widget, targetWidget, leadingSide));
            return;
        }
        if (attachedTrailing == targetWidget) {
            cyclicList.add(new ComponentAttachmentInfo(widget, targetWidget, trailingSide));
            return;
        }
        this.traverseAttachedWidgets(cyclicList, visitedWidgets, attachedLeading, targetWidget, isHorizontal);
        this.traverseAttachedWidgets(cyclicList, visitedWidgets, attachedTrailing, targetWidget, isHorizontal);
    }
}

