/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class WSDLLocatorAdapter
implements WSDLLocator {
    private static final Map localSchemas = new HashMap();
    private final String baseURI;
    private final EntityResolver entityResolver;
    private String latestImportURI;

    WSDLLocatorAdapter(String baseURI, EntityResolver entityResolver) {
        this.baseURI = baseURI;
        this.entityResolver = entityResolver;
    }

    private InputSource getInputSource(String uri) {
        URL localSchema = (URL)localSchemas.get(uri);
        if (localSchema != null) {
            InputSource is;
            try {
                is = new InputSource(localSchema.openStream());
            }
            catch (IOException ex) {
                return null;
            }
            is.setSystemId(uri);
            return is;
        }
        try {
            InputSource is = this.entityResolver.resolveEntity(null, uri);
            return is != null ? is : new InputSource(uri);
        }
        catch (SAXException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public InputSource getBaseInputSource() {
        return this.getInputSource(this.baseURI);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        if (parentLocation == null) {
            this.latestImportURI = importLocation;
        } else {
            try {
                this.latestImportURI = new URI(parentLocation).resolve(importLocation).toString();
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        return this.getInputSource(this.latestImportURI);
    }

    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    public void close() {
    }

    static {
        localSchemas.put("http://www.w3.org/2001/xml.xsd", WSDLLocatorAdapter.class.getResource("xml.xsd"));
        localSchemas.put("http://schemas.xmlsoap.org/soap/encoding/", WSDLLocatorAdapter.class.getResource("soap-encoding.xsd"));
    }
}

