/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

final class AsmLabelRule
implements IRule {
    protected IWordDetector fDetector;
    protected IToken fLabelToken;
    protected IToken fDefaultToken;

    AsmLabelRule(IWordDetector detector, IToken labelToken, IToken defaultToken) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)labelToken);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fLabelToken = labelToken;
        this.fDefaultToken = defaultToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c)) {
            int count = 1;
            do {
                c = scanner.read();
                ++count;
            } while (this.fDetector.isWordPart((char)c));
            if (c == 58) {
                return this.fLabelToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                while (count-- > 0) {
                    scanner.unread();
                }
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

