/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.SimpleSet;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;

public class IndexSelector {
    IDLTKSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;
    IPath[] containerPaths;
    private boolean mixinOnly = false;

    public IndexSelector(IDLTKSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IModelElement focus, boolean isPolymorphicSearch, IPath projectOrArchivePath) {
        try {
            IScriptModel model;
            IScriptProject project;
            IBuildpathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                ScriptProject focusProject = focus instanceof ArchiveProjectFragment ? (ScriptProject)focus.getParent() : (ScriptProject)focus;
                focusEntries = focusProject.getExpandedBuildpath();
            }
            if ((project = IndexSelector.getScriptProject(projectOrArchivePath, model = focus.getModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (ScriptProject)project, focusEntries);
            }
            IScriptProject[] allProjects = model.getScriptProjects();
            int i = 0;
            int length = allProjects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                ScriptProject otherProject = (ScriptProject)allProjects[i];
                IBuildpathEntry entry = otherProject.getBuildpathEntryFor(projectOrArchivePath);
                if (entry != null && entry.getEntryKind() == 1 && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                    return true;
                }
                ++i;
            }
        }
        catch (ModelException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IModelElement focus, ScriptProject scriptProject, IBuildpathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            int i;
            IPath focusPath;
            if (focus.equals(scriptProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = scriptProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    IBuildpathEntry entry = focusEntriesForPolymorphicSearch[i2];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof ArchiveProjectFragment) {
                focusPath = focus.getPath();
                IBuildpathEntry[] entries = scriptProject.getExpandedBuildpath();
                i = 0;
                int length = entries.length;
                while (i < length) {
                    IBuildpathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            focusPath = ((ScriptProject)focus).getProject().getFullPath();
            IBuildpathEntry[] entries = scriptProject.getExpandedBuildpath();
            i = 0;
            int length = entries.length;
            while (i < length) {
                IBuildpathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (ModelException e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeIndexLocations() {
        projectsAndArchives = this.searchScope.enclosingProjectsAndZips();
        manager = ModelManager.getModelManager().getIndexManager();
        locations = new SimpleSet();
        focus = MatchLocator.projectOrArchiveFocus(this.pattern);
        mix = this.mixinOnly;
        model = ModelManager.getModelManager().getModel();
        if (focus == null) {
            i = 0;
            while (i < projectsAndArchives.length) {
                if (!mix) {
                    locations.add(manager.computeIndexLocation(projectsAndArchives[i]));
                }
                this.checkSpecial(projectsAndArchives[i], manager, locations, model);
                ++i;
            }
        } else {
            try {
                length = projectsAndArchives.length;
                projectsCanSeeFocus = new ScriptProject[length];
                visitedProjects = new SimpleSet(length);
                projectIndex = 0;
                archivesToCheck = new SimpleSet(length);
                focusEntries = null;
                if (this.pattern != null && MatchLocator.isPolymorphicSearch(this.pattern)) {
                    focusProject = focus instanceof ArchiveProjectFragment != false ? (ScriptProject)focus.getParent() : (ScriptProject)focus;
                    focusEntries = focusProject.getExpandedBuildpath();
                }
                i = 0;
                while (i < length) {
                    path = projectsAndArchives[i];
                    project = (ScriptProject)IndexSelector.getScriptProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            if (!mix) {
                                locations.add(manager.computeIndexLocation(path));
                            }
                            this.checkSpecial(path, manager, locations, model);
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        archivesToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && archivesToCheck.elementSize > 0) {
                    entries = projectsCanSeeFocus[i].getResolvedBuildpath();
                    j = entries.length;
                    while (--j >= 0) {
                        entry = entries[j];
                        if (entry.getEntryKind() != 1 || !archivesToCheck.includes(path = entry.getPath())) continue;
                        if (!mix) {
                            locations.add(manager.computeIndexLocation(entry.getPath()));
                        }
                        archivesToCheck.remove(path);
                    }
                    ++i;
                }
                if (archivesToCheck.elementSize <= 0) ** GOTO lbl83
                allProjects = model.getScriptProjects();
                i = 0;
                l = allProjects.length;
                while (i < l && archivesToCheck.elementSize > 0) {
                    project = (ScriptProject)allProjects[i];
                    if (!visitedProjects.includes(project)) {
                        entries = project.getResolvedBuildpath();
                        j = entries.length;
                        while (--j >= 0) {
                            entry = entries[j];
                            if (entry.getEntryKind() != 1 || !archivesToCheck.includes(path = entry.getPath())) continue;
                            if (!mix) {
                                locations.add(manager.computeIndexLocation(entry.getPath()));
                            }
                            archivesToCheck.remove(path);
                        }
                    }
                    ++i;
                }
            }
            catch (ModelException length) {
                // empty catch block
            }
        }
lbl83:
        // 4 sources

        this.indexLocations = new IPath[locations.elementSize];
        values = locations.values;
        count = 0;
        i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = new Path((String)values[i]);
        }
    }

    private void checkSpecial(IPath projectsAndArchives, IndexManager manager, SimpleSet locations, IScriptModel model) {
        String prjPath = "#special#mixin#" + projectsAndArchives.toString();
        locations.add(manager.computeIndexLocation((IPath)new Path(prjPath)));
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IScriptProject getScriptProject(IPath path, IScriptModel model) {
        IScriptProject project = model.getScriptProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public void setMixinOnly(boolean bOnlyMixin) {
        this.mixinOnly = bOnlyMixin;
    }
}

