/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.preferences.ScriptSourcePreviewerUpdater;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.preferences.EditTemplateDialog;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.dltk.ui.text.templates.TemplateVariableProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;

public class ScriptTemplatesPage
extends AbstractTemplatesPage {
    private final TemplateVariableProcessor fTemplateProcessor;
    private final ScriptEditor fScriptEditor;
    private final ITemplateAccess fTemplateAccess;

    public ScriptTemplatesPage(ScriptEditor scriptEditor, ITemplateAccess templateAccess) {
        super((ITextEditor)scriptEditor, scriptEditor.getViewer());
        this.fScriptEditor = scriptEditor;
        this.fTemplateProcessor = new TemplateVariableProcessor();
        this.fTemplateAccess = templateAccess;
    }

    protected void insertTemplate(Template template, IDocument document) {
        String savedText;
        if (!this.fScriptEditor.validateEditorInputState()) {
            return;
        }
        ISourceViewer contextViewer = this.fScriptEditor.getViewer();
        ITextSelection textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
        if (!this.isValidTemplate(document, template, textSelection.getOffset(), textSelection.getLength())) {
            return;
        }
        this.beginCompoundChange(contextViewer);
        try {
            savedText = document.get(textSelection.getOffset(), textSelection.getLength());
            if (savedText.length() == 0) {
                String prefix = this.getIdentifierPart(document, template, textSelection.getOffset(), textSelection.getLength());
                if (prefix.length() > 0 && !template.getName().startsWith(prefix.toString())) {
                    return;
                }
                if (prefix.length() > 0) {
                    contextViewer.setSelectedRange(textSelection.getOffset() - prefix.length(), prefix.length());
                    textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
                }
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), template.getName().substring(0, 1));
        }
        catch (BadLocationException e) {
            this.endCompoundChange(contextViewer);
            return;
        }
        Position position = new Position(textSelection.getOffset() + 1, 0);
        Region region = new Region(textSelection.getOffset() + 1, 0);
        contextViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(textSelection.getOffset(), 1));
        ISourceModule compilationUnit = EditorUtility.getEditorInputModelElement((IEditorPart)this.fScriptEditor, true);
        TemplateContextType type = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
        ScriptTemplateContext context = ((ScriptTemplateContextType)type).createContext(document, position, compilationUnit);
        context.setVariable("selection", savedText);
        if (context.getKey().length() == 0) {
            try {
                document.replace(textSelection.getOffset(), 1, savedText);
            }
            catch (BadLocationException e) {
                this.endCompoundChange(contextViewer);
                return;
            }
        }
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
        this.fScriptEditor.getSite().getPage().activate((IWorkbenchPart)this.fScriptEditor);
        proposal.apply((ITextViewer)this.fScriptEditor.getViewer(), ' ', 0, region.getOffset());
        this.endCompoundChange(contextViewer);
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return this.fTemplateAccess.getContextTypeRegistry();
    }

    protected IPreferenceStore getTemplatePreferenceStore() {
        return this.fTemplateAccess.getTemplatePreferenceStore();
    }

    public TemplateStore getTemplateStore() {
        return this.fTemplateAccess.getTemplateStore();
    }

    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        String[] contextIds = this.getContextTypeIds(document, offset);
        int i = 0;
        while (i < contextIds.length) {
            if (contextIds[i].equals(template.getContextTypeId())) {
                DocumentTemplateContext context = this.getContext(document, template, offset, length);
                return context.canEvaluate(template) || this.isTemplateAllowed(context, template);
            }
            ++i;
        }
        return false;
    }

    protected SourceViewer createPatternViewer(Composite parent) {
        Document document = new Document();
        ScriptTextTools tools = this.fScriptEditor.getTextTools();
        tools.setupDocumentPartitioner((IDocument)document);
        IPreferenceStore store = this.uiToolkit().getCombinedPreferenceStore();
        ScriptSourceViewer viewer = new ScriptSourceViewer(parent, null, null, false, 768, store);
        ScriptSourceViewerConfiguration configuration = this.uiToolkit().createSourceViewerConfiguration();
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)this.fScriptEditor.getSymbolicFontName());
        viewer.getTextWidget().setFont(font);
        new ScriptSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        GridData data = new GridData(1296);
        control.setLayoutData((Object)data);
        viewer.setEditable(false);
        return viewer;
    }

    protected Image getImage(Template template) {
        return DLTKPluginImages.get("org.eclipse.dltk.ui.template_obj.png");
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.uiToolkit(), this.getSite().getShell(), template, edit, isNameModifiable, true, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected IDLTKUILanguageToolkit uiToolkit() {
        return DLTKUILanguageManager.getLanguageToolkit(this.fScriptEditor.getLanguageToolkit());
    }

    protected void updatePatternViewer(Template template) {
        if (template == null) {
            this.getPatternViewer().getDocument().set("");
            return;
        }
        String contextId = template.getContextTypeId();
        TemplateContextType type = this.getContextTypeRegistry().getContextType(contextId);
        this.fTemplateProcessor.setContextType(type);
        IDocument doc = this.getPatternViewer().getDocument();
        Object start = null;
        start = "javadoc".equals(contextId) ? "/**" + doc.getLegalLineDelimiters()[0] : "";
        doc.set((String)start + template.getPattern());
        int startLen = ((String)start).length();
        this.getPatternViewer().setDocument(doc, startLen, doc.getLength() - startLen);
    }

    protected String getPreferencePageId() {
        return this.uiToolkit().getEditorTemplatesPreferencePageId();
    }

    private void endCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().endCompoundChange();
        }
    }

    private void beginCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().beginCompoundChange();
        }
    }

    private boolean isTemplateAllowed(DocumentTemplateContext context, Template template) {
        try {
            int offset = context.getCompletionOffset();
            return offset > 0 && !this.isTemplateNamePart(context.getDocument().getChar(offset - 1));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTemplateNamePart(char ch) {
        return !Character.isWhitespace(ch) && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != ';';
    }

    private DocumentTemplateContext getContext(IDocument document, Template template, int offset, int length) {
        ScriptTemplateContextType contextType = (ScriptTemplateContextType)this.getContextTypeRegistry().getContextType(template.getContextTypeId());
        ISourceModule module = EditorUtility.getEditorInputModelElement((IEditorPart)this.fScriptEditor, true);
        return contextType.createContext(document, offset, length, module);
    }

    protected String[] getContextTypeIds(IDocument document, int offset) {
        HashSet<String> ids = new HashSet<String>();
        Iterator i = this.getContextTypeRegistry().contextTypes();
        while (i.hasNext()) {
            ids.add(((TemplateContextType)i.next()).getId());
        }
        return ids.toArray(new String[ids.size()]);
    }

    private String getIdentifierPart(IDocument document, Template template, int offset, int length) {
        return this.getContext(document, template, offset, length).getKey();
    }
}

