/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class TextEditorPropertyAction
extends Action
implements IPropertyChangeListener,
ActionFactory.IWorkbenchAction {
    private ITextViewer viewer;
    private String preferenceKey;
    private IPreferenceStore store;

    public TextEditorPropertyAction(String label, ITextViewer viewer, String preferenceKey, boolean initiallyOff) {
        super(label, 2);
        this.viewer = viewer;
        this.preferenceKey = preferenceKey;
        this.store = EditorsUI.getPreferenceStore();
        if (this.store != null) {
            this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        if (!initiallyOff) {
            this.synchronizeWithPreference();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.getPreferenceKey())) {
            this.synchronizeWithPreference();
        }
    }

    protected void synchronizeWithPreference() {
        boolean checked = false;
        if (this.store != null) {
            checked = this.store.getBoolean(this.getPreferenceKey());
        }
        if (checked != this.isChecked()) {
            this.setChecked(checked);
            this.toggleState(checked);
        } else if (checked) {
            this.toggleState(false);
            this.toggleState(true);
        }
    }

    protected String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void run() {
        this.toggleState(this.isChecked());
        if (this.store != null) {
            this.store.setValue(this.getPreferenceKey(), this.isChecked());
        }
    }

    public void dispose() {
        if (this.store != null) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected abstract void toggleState(boolean var1);

    protected ITextViewer getTextViewer() {
        return this.viewer;
    }

    protected IPreferenceStore getStore() {
        return this.store;
    }
}

