/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

public class BranchProperties
extends Properties<CDOBranch> {
    public static final IProperties<CDOBranch> INSTANCE = new BranchProperties();
    private static final String CATEGORY_BRANCH = "Branch";

    private BranchProperties() {
        super(CDOBranch.class);
        this.add((Property)new Property<CDOBranch>("id", "ID", "The ID of this branch.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                return branch.getID();
            }
        });
        this.add((Property)new Property<CDOBranch>("name", "Name", "The name of this branch.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                return branch.getName();
            }
        });
        this.add((Property)new Property<CDOBranch>("pathName", "Path Name", "The path name of this branch.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                return branch.getPathName();
            }
        });
        this.add((Property)new Property<CDOBranch>("baseBranchID", "Base Branch ID", "The base branch ID of this branch.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                CDOBranch baseBranch = branch.getBranch();
                if (baseBranch != null) {
                    return baseBranch.getID();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOBranch>("baseBranchID", "Base Branch ID", "The base branch ID of this branch.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                CDOBranch baseBranch = branch.getBranch();
                if (baseBranch != null) {
                    return baseBranch.getID();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOBranch>("baseTimeStamp", "Base Time Stamp", "The base time stamp of this branch.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                return CDOCommonUtil.formatTimeStamp(branch.getTimeStamp());
            }
        });
        this.add((Property)new Property<CDOBranch>("deleted", "Deleted", "Whether this branch is deleted.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                return branch.isDeleted();
            }
        });
        this.add((Property)new Property<CDOBranch>("local", "Local", "Whether this branch is local.", CATEGORY_BRANCH){

            protected Object eval(CDOBranch branch) {
                return branch.isLocal();
            }
        });
        this.add((Property)new Property<CDOBranch>("main"){

            protected Object eval(CDOBranch branch) {
                return branch.isMainBranch();
            }
        });
        this.add((Property)new Property<CDOBranch>("proxy"){

            protected Object eval(CDOBranch branch) {
                return ((InternalCDOBranch)branch).isProxy();
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    public static final class Tester
    extends DefaultPropertyTester<CDOBranch> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.branch";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

