/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.util.HashMap;
import org.eclipse.equinox.internal.transforms.ProxyStreamTransformer;
import org.eclipse.equinox.internal.transforms.StreamTransformer;
import org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class TransformerList
extends ServiceTracker<Object, Object> {
    private volatile boolean stale = true;
    private HashMap<String, StreamTransformer> transformers = new HashMap();
    private final EquinoxLogServices logServices;

    public TransformerList(BundleContext context, EquinoxLogServices logServices) throws InvalidSyntaxException {
        super(context, context.createFilter("(&(objectClass=" + Object.class.getName() + ")(equinox.transformerType=*))"), null);
        this.logServices = logServices;
        this.open();
    }

    public synchronized StreamTransformer getTransformer(String type) {
        if (this.stale) {
            this.rebuildTransformersMap();
        }
        return this.transformers.get(type);
    }

    public synchronized boolean hasTransformers() {
        if (this.stale) {
            this.rebuildTransformersMap();
        }
        return this.transformers.size() > 0;
    }

    private void rebuildTransformersMap() {
        this.transformers.clear();
        ServiceReference[] serviceReferences = this.getServiceReferences();
        this.stale = false;
        if (serviceReferences == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            String type = serviceReference.getProperty("equinox.transformerType").toString();
            if (type != null && this.transformers.get(type) == null) {
                Object object = this.getService(serviceReference);
                if (object instanceof StreamTransformer) {
                    this.transformers.put(type, (StreamTransformer)object);
                } else {
                    try {
                        ProxyStreamTransformer transformer = new ProxyStreamTransformer(object);
                        this.transformers.put(type, transformer);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        this.logServices.log("org.eclipse.osgi", 4, "Problem creating transformer", (Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }

    public Object addingService(ServiceReference<Object> reference) {
        try {
            Object object = super.addingService(reference);
            return object;
        }
        finally {
            this.stale = true;
        }
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
        super.modifiedService(reference, service);
        this.stale = true;
    }

    public void removedService(ServiceReference<Object> reference, Object service) {
        super.removedService(reference, service);
        this.stale = true;
    }
}

