/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.reflect;

import java.lang.reflect.Field;

public class ReflectionUtils {
    private static Field getField(Object owner, String fieldName) {
        Class<?> currentClass = owner.getClass();
        Field field = null;
        do {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                currentClass = currentClass.getSuperclass();
                if (currentClass != null) continue;
                return null;
            }
        } while (field == null);
        field.setAccessible(true);
        return field;
    }

    public static <T> T getPrivateFieldValue(Object owner, String fieldName) {
        Field field = ReflectionUtils.getField(owner, fieldName);
        try {
            return (T)field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setPrivateFieldValue(Object owner, String fieldName, T value) {
        Field field = ReflectionUtils.getField(owner, fieldName);
        try {
            field.set(owner, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

