/*
 * generated by Xtext 2.32.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.color.ColorPackage;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.ColorlistPackage;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.language.services.DotColorListGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;

@SuppressWarnings("all")
public class DotColorListSemanticSequencer extends DotColorSemanticSequencer {

	@Inject
	private DotColorListGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ColorPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ColorPackage.HSV_COLOR:
				sequence_HSVColor(context, (HSVColor) semanticObject); 
				return; 
			case ColorPackage.RGB_COLOR:
				sequence_RGBColor(context, (RGBColor) semanticObject); 
				return; 
			case ColorPackage.STRING_COLOR:
				sequence_StringColor(context, (StringColor) semanticObject); 
				return; 
			}
		else if (epackage == ColorlistPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ColorlistPackage.COLOR_LIST:
				sequence_ColorList(context, (ColorList) semanticObject); 
				return; 
			case ColorlistPackage.WC:
				sequence_WC(context, (WC) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     ColorList returns ColorList
	 *
	 * Constraint:
	 *     (colorValues+=WC colorValues+=WC*)
	 * </pre>
	 */
	protected void sequence_ColorList(ISerializationContext context, ColorList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     WC returns WC
	 *
	 * Constraint:
	 *     (color=Color weight=COLOR_NUMBER?)
	 * </pre>
	 */
	protected void sequence_WC(ISerializationContext context, WC semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
