/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.reference.ModifiableObjectReference;

public class SynchronizedObject<V>
implements ModifiableObjectReference<V>,
Cloneable,
Serializable {
    private V value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedObject(V value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedObject(V value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedObject() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean valueEquals(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return ObjectTools.equals(this.value, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean valueNotEqual(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return ObjectTools.notEquals(this.value, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean is(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.value == object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNot(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            return this.value != object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMemberOf(Predicate<? super V> predicate) {
        Object object = this.mutex;
        synchronized (object) {
            return predicate.evaluate(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotMemberOf(Predicate<? super V> predicate) {
        Object object = this.mutex;
        synchronized (object) {
            return !predicate.evaluate(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V setValue(V value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(value);
        }
    }

    private V setValue_(V v) {
        V old = this.value;
        return ObjectTools.equals(old, v) ? old : this.setValue_(v, old);
    }

    private V setChangedValue_(V v) {
        return this.setValue_(v, this.value);
    }

    private V setValue_(V v, V old) {
        this.value = v;
        this.mutex.notifyAll();
        return old;
    }

    @Override
    public V setNull() {
        return this.setValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit(V newValue, V expectedValue) {
        Object object = this.mutex;
        synchronized (object) {
            return this.commit_(newValue, expectedValue);
        }
    }

    private boolean commit_(V newValue, V expectedValue) {
        if (ObjectTools.equals(this.value, expectedValue)) {
            this.setValue_(newValue);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V swap(ModifiableObjectReference<V> other) {
        if (other == this) {
            return this.getValue();
        }
        if (other instanceof SynchronizedObject) {
            return this.swap_((SynchronizedObject)other);
        }
        Object thisValue = null;
        Object otherValue = other.getValue();
        Object object = this.mutex;
        synchronized (object) {
            thisValue = this.value;
            if (ObjectTools.notEquals(thisValue, otherValue)) {
                this.setChangedValue_(otherValue);
            }
        }
        other.setValue(thisValue);
        return otherValue;
    }

    @Override
    public V swap(SynchronizedObject<V> other) {
        return other == this ? this.getValue() : this.swap_(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V swap_(SynchronizedObject<V> other) {
        boolean thisFirst = System.identityHashCode(this) < System.identityHashCode(other);
        SynchronizedObject<V> first = thisFirst ? this : other;
        SynchronizedObject<V> second = thisFirst ? other : this;
        Object object = first.mutex;
        synchronized (object) {
            Object object2 = second.mutex;
            synchronized (object2) {
                V thisValue = this.value;
                V otherValue = other.value;
                if (ObjectTools.equals(thisValue, otherValue)) {
                    return thisValue;
                }
                super.setChangedValue_(thisValue);
                super.setChangedValue_(otherValue);
                return otherValue;
            }
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntil(Predicate<? super V> predicate) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntil_(predicate);
        }
    }

    private void waitUntil_(Predicate<? super V> predicate) throws InterruptedException {
        while (!predicate.evaluate(this.value)) {
            this.mutex.wait();
        }
    }

    public void waitUntilNot(Predicate<? super V> predicate) throws InterruptedException {
        this.waitUntil(PredicateTools.not(predicate));
    }

    public void waitUntilValueEquals(V object) throws InterruptedException {
        this.waitUntil(PredicateTools.isEqual(object));
    }

    public void waitUntilValueNotEqual(V object) throws InterruptedException {
        this.waitUntil(PredicateTools.isNotEqual(object));
    }

    public void waitUntilValueIs(V object) throws InterruptedException {
        this.waitUntil(PredicateTools.isIdentical(object));
    }

    public void waitUntilValueIsNot(V object) throws InterruptedException {
        this.waitUntil(PredicateTools.isNotIdentical(object));
    }

    public void waitUntilNull() throws InterruptedException {
        this.waitUntilValueIs(null);
    }

    public void waitUntilNotNull() throws InterruptedException {
        this.waitUntilValueIsNot(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitToSetValue(V v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntil_(PredicateTools.isNotEqual(v));
            return this.setChangedValue_(v);
        }
    }

    public V waitToSetNull() throws InterruptedException {
        return this.waitToSetValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitToCommit(V newValue, V expectedValue) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntil_(PredicateTools.isEqual(expectedValue));
            return this.setValue_(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntil(Predicate<? super V> predicate, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntil_(predicate, timeout);
        }
    }

    private boolean waitUntil_(Predicate<? super V> predicate, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntil_(predicate);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (!predicate.evaluate(this.value) && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return predicate.evaluate(this.value);
    }

    public boolean waitUntilNot(Predicate<? super V> predicate, long timeout) throws InterruptedException {
        return this.waitUntil(PredicateTools.not(predicate), timeout);
    }

    public boolean waitUntilValueEquals(V object, long timeout) throws InterruptedException {
        return this.waitUntil(PredicateTools.isEqual(object), timeout);
    }

    public boolean waitUntilValueNotEqual(V object, long timeout) throws InterruptedException {
        return this.waitUntil(PredicateTools.isNotEqual(object), timeout);
    }

    public boolean waitUntilValueIs(V object, long timeout) throws InterruptedException {
        return this.waitUntil(PredicateTools.isIdentical(object), timeout);
    }

    public boolean waitUntilValueIsNot(V object, long timeout) throws InterruptedException {
        return this.waitUntil(PredicateTools.isNotIdentical(object), timeout);
    }

    public boolean waitUntilNull(long timeout) throws InterruptedException {
        return this.waitUntilValueIs(null, timeout);
    }

    public boolean waitUntilNotNull(long timeout) throws InterruptedException {
        return this.waitUntilValueIsNot(null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(V v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntil_(PredicateTools.isNotEqual(v), timeout);
            if (success) {
                this.setChangedValue_(v);
            }
            return success;
        }
    }

    public boolean waitToSetNull(long timeout) throws InterruptedException {
        return this.waitToSetValue(null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToCommit(V newValue, V expectedValue, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntil_(PredicateTools.isEqual(expectedValue), timeout);
            if (success) {
                this.setValue_(newValue);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedObject<V> clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                SynchronizedObject clone = (SynchronizedObject)super.clone();
                return clone;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

