/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.actions.ConsoleAction;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class SaveLogAction
extends ConsoleAction
implements ScriptConsole.ScriptConsoleObserver {
    private String logFileName = null;

    public SaveLogAction(ScriptConsole consoleParam) {
        super(consoleParam, ConsoleLogPlugin.getDefault().getBundle().getEntry("icons/actions/save_log.gif"), Localization.getString("action.saveLog.name"), Localization.getString("action.saveLog.desc"), 2);
        consoleParam.addScriptConsoleObserver(this);
    }

    public void run() {
        File file = this.getFile();
        if (file != null && this.console.saveStreamAndReturnResult(file)) {
            this.logFileName = file.toString();
        }
        this.updateChecked();
    }

    private File getFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        if (this.logFileName != null) {
            Path logPath = new Path(this.logFileName);
            dialog.setFilterPath(logPath.removeLastSegments(1).toOSString());
            dialog.setFileName(logPath.lastSegment());
        }
        dialog.setText(Localization.getString(!this.isLogging() ? "SaveLogAction.OutputFile" : "SaveLogAction.OutputFileLocation"));
        dialog.setOverwrite(true);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    public void updateChecked() {
        if (this.isLogging()) {
            this.setToolTipText(MessageFormat.format(Localization.getString("action.saveLog.name2"), this.logFileName));
            this.setChecked(true);
        } else {
            this.setToolTipText(Localization.getString("action.saveLog.name"));
            this.setChecked(false);
        }
    }

    private boolean isLogging() {
        return this.logFileName != null;
    }

    @Override
    public void runningStateChanged(boolean started, boolean stopped) {
        if (started && !stopped) {
            this.logFileName = null;
            this.updateChecked();
        }
    }
}

