/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hover.config;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.hover.HoverLayer;
import org.eclipse.nebula.widgets.nattable.hover.action.ClearHoverStylingAction;
import org.eclipse.nebula.widgets.nattable.hover.action.HoverStylingAction;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;

public class SimpleHoverStylingBindings
extends AbstractUiBindingConfiguration {
    private final HoverLayer layer;

    public SimpleHoverStylingBindings(HoverLayer layer) {
        this.layer = layer;
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerFirstMouseMoveBinding(new IMouseEventMatcher(){

            @Override
            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                int width = SimpleHoverStylingBindings.this.layer.getPreferredWidth();
                int height = SimpleHoverStylingBindings.this.layer.getPreferredHeight();
                return event.x > 0 && event.x < width && event.y > 0 && event.y < height;
            }
        }, new HoverStylingAction(this.layer));
        uiBindingRegistry.registerMouseMoveBinding(new IMouseEventMatcher(){

            @Override
            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                int width = SimpleHoverStylingBindings.this.layer.getPreferredWidth();
                int height = SimpleHoverStylingBindings.this.layer.getPreferredHeight();
                return event.x < 0 || event.x > width || event.y < 0 || event.y > height;
            }
        }, new ClearHoverStylingAction());
        uiBindingRegistry.registerMouseMoveBinding(new IMouseEventMatcher(){

            @Override
            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return natTable != null && regionLabels == null;
            }
        }, new ClearHoverStylingAction());
        uiBindingRegistry.registerMouseExitBinding(new IMouseEventMatcher(){

            @Override
            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                return true;
            }
        }, new ClearHoverStylingAction());
    }
}

