/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import java.io.File;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.Messages;
import org.eclipse.oomph.util.StringUtil;

public final class JRE
implements Comparable<JRE> {
    static final String SEPARATOR = File.pathSeparator;
    private final File javaHome;
    private final Descriptor descriptor;
    private final int major;
    private final int minor;
    private final int micro;
    private final int bitness;
    private final String arch;
    private final boolean jdk;
    private final long lastModified;

    public JRE(File javaHome, int major, int minor, int micro, int bitness, boolean jdk, long lastModified) {
        this(javaHome, major, minor, micro, bitness, "", jdk, lastModified);
    }

    public JRE(File javaHome, int major, int minor, int micro, int bitness, String arch, boolean jdk, long lastModified) {
        this.javaHome = javaHome;
        this.descriptor = null;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.bitness = bitness;
        this.arch = arch;
        this.jdk = jdk;
        this.lastModified = lastModified;
    }

    JRE(Descriptor descriptor) {
        this.javaHome = null;
        this.descriptor = descriptor;
        this.major = descriptor.getMajor();
        this.minor = descriptor.getMinor();
        this.micro = descriptor.getMicro();
        this.bitness = descriptor.getBitness();
        this.arch = "";
        this.jdk = descriptor.isJDK();
        this.lastModified = -1L;
    }

    JRE(File javaHome, JRE info) {
        this.javaHome = javaHome;
        this.descriptor = null;
        this.major = info.major;
        this.minor = info.minor;
        this.micro = info.micro;
        this.bitness = info.bitness;
        this.arch = info.arch;
        this.jdk = info.jdk;
        this.lastModified = info.lastModified;
    }

    JRE(String line) {
        this.descriptor = null;
        String[] tokens = line.split(SEPARATOR);
        this.javaHome = new File(tokens[0]);
        this.major = Integer.parseInt(tokens[1]);
        this.minor = Integer.parseInt(tokens[2]);
        this.micro = Integer.parseInt(tokens[3]);
        this.bitness = Integer.parseInt(tokens[4]);
        this.jdk = Boolean.parseBoolean(tokens[5]);
        this.lastModified = Long.parseLong(tokens[6]);
        this.arch = tokens.length > 7 ? tokens[7] : "";
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public File getJavaExecutable() {
        return this.javaHome == null ? null : JRE.getExecutable(this.javaHome);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getBitness() {
        return this.bitness;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean isJDK() {
        return this.jdk;
    }

    public boolean isValid() {
        if (this.descriptor != null) {
            return true;
        }
        File executable = this.getJavaExecutable();
        return executable.isFile() && executable.lastModified() == this.lastModified;
    }

    public boolean isCurrent() {
        if (this.descriptor != null) {
            return false;
        }
        String systemJavaHome = System.getProperty("java.home");
        return this.javaHome.getPath().equals(systemJavaHome);
    }

    public boolean isMatch(JREFilter filter) {
        Integer filterBitness = filter.getBitness();
        if (filterBitness != null && this.bitness != filterBitness) {
            return false;
        }
        String filterArch = filter.getArch();
        if (!(StringUtil.isEmpty((String)filterArch) || StringUtil.isEmpty((String)this.arch) || filterArch.equals(this.arch))) {
            return false;
        }
        Boolean filterJDK = filter.isJDK();
        if (filterJDK != null && this.jdk != filterJDK) {
            return false;
        }
        Boolean filterDescriptor = filter.isDescriptor();
        if (filterDescriptor != null && this.descriptor != null != filterDescriptor) {
            return false;
        }
        Integer filterMajor = filter.getMajor();
        if (filterMajor == null) {
            return true;
        }
        if (this.major < filterMajor) {
            return false;
        }
        if (this.major > filterMajor) {
            return true;
        }
        Integer filterMinor = filter.getMinor();
        if (filterMinor == null) {
            return true;
        }
        if (this.minor < filterMinor) {
            return false;
        }
        if (this.minor > filterMinor) {
            return true;
        }
        Integer filterMicro = filter.getMicro();
        if (filterMicro == null) {
            return true;
        }
        return this.micro >= filterMicro;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaHome == null ? 0 : this.javaHome.hashCode());
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JRE other = (JRE)obj;
        if (this.javaHome == null ? other.javaHome != null : !this.javaHome.equals(other.javaHome)) {
            return false;
        }
        return !(this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor));
    }

    @Override
    public int compareTo(JRE o) {
        int result = o.major - this.major;
        if (result == 0 && (result = o.minor - this.minor) == 0 && (result = o.micro - this.micro) == 0 && (result = o.bitness - this.bitness) == 0) {
            result = (o.jdk ? 1 : 0) - (this.jdk ? 1 : 0);
        }
        return result;
    }

    public String toString() {
        if (this.descriptor != null) {
            return this.descriptor.getLabel();
        }
        return this.javaHome.getPath() + (String)(this.isCurrent() ? " " + Messages.JRE_Current_message : "");
    }

    String toLine() {
        return this.javaHome.getAbsolutePath() + SEPARATOR + this.major + SEPARATOR + this.minor + SEPARATOR + this.micro + SEPARATOR + this.bitness + SEPARATOR + this.jdk + SEPARATOR + this.lastModified + SEPARATOR + this.arch;
    }

    static File getExecutable(File javaHome) {
        return new File(javaHome, "bin/" + JREManager.JAVA_EXECUTABLE);
    }

    public static final class Descriptor {
        private String label;
        private final int major;
        private final int minor;
        private final int micro;
        private int bitness;
        private final boolean jdk;
        private final Object data;

        public Descriptor(String label, int major, int minor, int micro, int bitness, boolean jdk, Object data) {
            this.label = label;
            this.data = data;
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.bitness = bitness;
            this.jdk = jdk;
        }

        public String getLabel() {
            return this.label;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getMicro() {
            return this.micro;
        }

        public int getBitness() {
            return this.bitness;
        }

        public boolean isJDK() {
            return this.jdk;
        }

        public Object getData() {
            return this.data;
        }

        public String toString() {
            return this.label;
        }
    }
}

