/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.plugins;

import aQute.bnd.build.Project;
import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.osgi.repository.AbstractIndexingRepository;
import aQute.bnd.osgi.repository.WorkspaceRepositoryMarker;
import aQute.bnd.osgi.resource.ResourceBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Adapters;

public class EclipseWorkspaceRepository
extends AbstractIndexingRepository<IProject, File>
implements WorkspaceRepositoryMarker {
    private static final Map<IWorkspace, EclipseWorkspaceRepository> repositoryMap = new ConcurrentHashMap<IWorkspace, EclipseWorkspaceRepository>();
    private boolean initialized;
    private IWorkspace workspace;

    EclipseWorkspaceRepository(IWorkspace workspace) {
        this.workspace = workspace;
    }

    synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        List projects = Arrays.stream(this.workspace.getRoot().getProjects()).collect(Collectors.toList());
        for (IProject project : projects) {
            File target;
            File buildfiles;
            Project model = (Project)Adapters.adapt((Object)project, Project.class);
            if (model == null || !(buildfiles = new File(target = model.getTargetDir(), "buildfiles")).isFile()) continue;
            this.index(project, SupplierWithException.asSupplierOrElse(() -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader rdr = Files.newBufferedReader(buildfiles.toPath(), StandardCharsets.UTF_8);){
                    return rdr.lines().map(line -> new File(target, line.trim())).filter(File::isFile).collect(Collectors.toList());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }, Collections.emptyList()));
        }
    }

    protected boolean isValid(IProject project) {
        try {
            return project.isOpen() && Adapters.adapt((Object)project, Project.class) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected BiFunction<ResourceBuilder, File, ResourceBuilder> indexer(IProject project) {
        String name = project.getName();
        return (rb, file) -> {
            if ((rb = this.fileIndexer((ResourceBuilder)rb, (File)file)) == null) {
                return null;
            }
            rb.addWorkspaceNamespace(name);
            return rb;
        };
    }

    public String toString() {
        return "Workspace";
    }

    public static EclipseWorkspaceRepository get(IWorkspace workspace) throws Exception {
        EclipseWorkspaceRepository repository = repositoryMap.computeIfAbsent(workspace, EclipseWorkspaceRepository::new);
        repository.initialize();
        return repository;
    }
}

