/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertJarsAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbench = targetPart.getSite().getWorkbenchWindow().getWorkbench();
    }

    public void run(IAction action) {
        HashMap<Manifest, Object> filesMap = new HashMap<Manifest, Object>();
        HashSet<IProject> projectSelection = new HashSet<IProject>();
        Iterator i = this.selection.toList().iterator();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (i.hasNext()) {
            IPackageFragmentRoot pfr = (IPackageFragmentRoot)i.next();
            try {
                Throwable throwable;
                projectSelection.add(pfr.getJavaProject().getProject());
                IClasspathEntry rawClasspathEntry = pfr.getRawClasspathEntry();
                IPath path = rawClasspathEntry.getPath();
                IFile iFile = root.getFile(path);
                if (iFile.exists()) {
                    Throwable throwable2 = null;
                    throwable = null;
                    try (JarFile file = new JarFile(iFile.getLocation().toString());){
                        if (filesMap.containsKey(file.getManifest())) continue;
                        filesMap.put(file.getManifest(), iFile);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                String pathStr = path.toString();
                throwable = null;
                Object var12_16 = null;
                try (JarFile file = new JarFile(pathStr);){
                    if (filesMap.containsKey(file.getManifest())) continue;
                    filesMap.put(file.getManifest(), new File(file.getName()));
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PDEPlugin.logException(e);
            }
        }
        NewLibraryPluginProjectWizard wizard = new NewLibraryPluginProjectWizard(filesMap.values(), projectSelection);
        wizard.init(this.workbench, this.selection);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean enabled = true;
        if (s instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)s;
            if (this.selection.isEmpty()) {
                return;
            }
            for (Object obj : this.selection) {
                if (obj instanceof IPackageFragmentRoot) {
                    try {
                        IPackageFragmentRoot packageFragment = (IPackageFragmentRoot)obj;
                        if (packageFragment.getKind() == 2 && PDE.hasPluginNature((IProject)packageFragment.getJavaProject().getProject()) && packageFragment.getRawClasspathEntry().getEntryKind() == 1) {
                            continue;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                enabled = false;
                break;
            }
        } else {
            enabled = false;
            this.selection = null;
        }
        action.setEnabled(enabled);
    }
}

