/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.NoneDebuggerConfiguration;
import org.eclipse.php.internal.debug.daemon.communication.DaemonsRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class PHPDebuggersRegistry {
    public static final String NONE_DEBUGGER_ID = "org.eclipse.php.debug.core.noneDebugger";
    private static final String EXTENSION_POINT_NAME = "phpDebuggers";
    private static final String DEBUGGER_TAG = "phpDebugger";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = "debuggerConfiguration";
    private static String DEFAULT_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private static final String NONE_DEBUGGER_NAME = "<none>";
    private static PHPDebuggersRegistry instance;
    private HashMap<String, String> debuggers = new HashMap();
    private HashMap<String, AbstractDebuggerConfiguration> configurations = new HashMap();
    private AbstractDebuggerConfiguration noneDebuggerConfiguration = new NoneDebuggerConfiguration();

    private PHPDebuggersRegistry() {
        this.loadDebuggers();
    }

    private static PHPDebuggersRegistry getInstance() {
        if (instance == null) {
            instance = new PHPDebuggersRegistry();
        }
        return instance;
    }

    public static Set<String> getDebuggersIds() {
        return Collections.unmodifiableSet(PHPDebuggersRegistry.getInstance().debuggers.keySet());
    }

    public static AbstractDebuggerConfiguration getDebuggerConfiguration(String debuggerId) {
        if (NONE_DEBUGGER_ID.equals(debuggerId)) {
            return PHPDebuggersRegistry.getInstance().noneDebuggerConfiguration;
        }
        return PHPDebuggersRegistry.getInstance().configurations.get(debuggerId);
    }

    public static AbstractDebuggerConfiguration[] getDebuggersConfigurations() {
        Collection<AbstractDebuggerConfiguration> values = PHPDebuggersRegistry.getInstance().configurations.values();
        AbstractDebuggerConfiguration[] configurations = new AbstractDebuggerConfiguration[values.size()];
        return values.toArray(configurations);
    }

    public static String getDefaultDebuggerId() {
        return DEFAULT_DEBUGGER_ID;
    }

    public static void setDefaultDebuggerId(String id) throws IllegalArgumentException {
        if (!PHPDebuggersRegistry.getInstance().debuggers.containsKey(id)) {
            throw new IllegalArgumentException("No such debugger id was registered: " + id);
        }
        DEFAULT_DEBUGGER_ID = id;
    }

    public static String getDebuggerName(String debuggerID) {
        return PHPDebuggersRegistry.getInstance().debuggers.get(debuggerID);
    }

    public static boolean isNoneDebugger(String debuggerID) {
        return NONE_DEBUGGER_ID.equals(debuggerID);
    }

    private void loadDebuggers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        HashMap<String, AbstractDebuggerConfiguration> nonPDTConfigurations = new HashMap<String, AbstractDebuggerConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            final IConfigurationElement element = iConfigurationElementArray[n2];
            if (DEBUGGER_TAG.equals(element.getName())) {
                String name = element.getAttribute(NAME_ATTRIBUTE);
                final String id = element.getAttribute(ID_ATTRIBUTE);
                boolean isPDT = element.getNamespaceIdentifier().startsWith("org.eclipse.php");
                boolean filter = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                    public String getLocalId() {
                        return id;
                    }

                    public String getPluginId() {
                        return element.getNamespaceIdentifier();
                    }
                });
                if (!filter) {
                    this.debuggers.put(id, name);
                    try {
                        AbstractDebuggerConfiguration configuration = (AbstractDebuggerConfiguration)element.createExecutableExtension(CONFIGURATION_CLASS_ATTRIBUTE);
                        configuration.setDebuggerId(id);
                        configuration.setName(name);
                        try {
                            List daemons = DaemonsRegistry.getDaemons();
                            for (ICommunicationDaemon daemon : daemons) {
                                if (!daemon.isDebuggerDaemon() || !id.equals(daemon.getDebuggerID())) continue;
                                configuration.setCommunicationDaemon(daemon);
                                break;
                            }
                        }
                        catch (Exception e) {
                            configuration.setPort(-1);
                        }
                        this.configurations.put(id, configuration);
                        if (!isPDT) {
                            nonPDTConfigurations.put(id, configuration);
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
            }
            ++n2;
        }
        for (Map.Entry entry : nonPDTConfigurations.entrySet()) {
            AbstractDebuggerConfiguration configuration = (AbstractDebuggerConfiguration)entry.getValue();
            this.configurations.put((String)entry.getKey(), configuration);
            this.debuggers.put(configuration.getDebuggerId(), configuration.getName());
        }
        this.debuggers.put(NONE_DEBUGGER_ID, NONE_DEBUGGER_NAME);
    }
}

