/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.PHPSymbolicLinksCache;
import org.eclipse.php.internal.core.phar.PharArchiveFile;
import org.eclipse.php.internal.core.phar.PharPath;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.core.util.SyncObject;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.communication.RemoteFileStorage;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;

public class PHPSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private LinkSubjectFileFinder linkSubjectFileFinder = new LinkSubjectFileFinder();
    private Map<String, RemoteFileStorage> remoteStorageCache = new HashMap<String, RemoteFileStorage>();

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof PHPStackFrame) {
            return ((PHPStackFrame)((Object)object)).getSourceName();
        }
        if (object instanceof DBGpStackFrame) {
            String sourceName = ((DBGpStackFrame)((Object)object)).getSourceName();
            if (sourceName == null) {
                sourceName = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
                Path path = new Path(sourceName);
                sourceName = path.lastSegment();
            }
            return sourceName;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        try {
            Object[] sourceElements = this.getRemoteSourceElements(object, false);
            if (sourceElements != EMPTY) {
                return sourceElements;
            }
        }
        catch (CoreException sourceElements) {
            // empty catch block
        }
        try {
            Object[] result = this.getLocalSourceElements(object);
            if (result != EMPTY) {
                return result;
            }
        }
        catch (CoreException result) {
            // empty catch block
        }
        ArrayList<Object> results = new ArrayList<Object>();
        CoreException single = null;
        MultiStatus multiStatus = null;
        String name = this.getSourceName(object);
        if (name != null) {
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                block19: {
                    try {
                        ISourceContainer container = this.getDelegateContainer(containers[i]);
                        if (container == null) break block19;
                        Object[] objects = container.findSourceElements(name);
                        if (objects.length > 0) {
                            if (this.isFindDuplicates()) {
                                int j = 0;
                                while (j < objects.length) {
                                    results.add(objects[j]);
                                    ++j;
                                }
                                break block19;
                            }
                            if (objects.length == 1) {
                                return objects;
                            }
                            return new Object[]{objects[0]};
                        }
                        return this.getRemoteSourceElements(object, true);
                    }
                    catch (CoreException e) {
                        if (single == null) {
                            single = e;
                        }
                        if (multiStatus == null) {
                            multiStatus = new MultiStatus("org.eclipse.php.debug.core", 10001, new IStatus[]{single.getStatus()}, SourceLookupMessages.Source_Lookup_Error, null);
                            multiStatus.add(e.getStatus());
                        }
                        multiStatus.add(e.getStatus());
                    }
                }
                ++i;
            }
        }
        if (results.isEmpty()) {
            if (multiStatus != null) {
                throw new CoreException(multiStatus);
            }
            if (single != null) {
                throw single;
            }
            return EMPTY;
        }
        return results.toArray();
    }

    public void dispose() {
        super.dispose();
        this.remoteStorageCache.clear();
        this.remoteStorageCache = null;
    }

    private Object[] getLocalSourceElements(Object object) throws CoreException {
        Object[] sourceElements = EMPTY;
        try {
            sourceElements = super.findSourceElements(object);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (sourceElements == EMPTY) {
            String sourceFilePath = null;
            if (object instanceof PHPStackFrame) {
                sourceFilePath = ((PHPStackFrame)((Object)object)).getSourceName();
            } else if (object instanceof DBGpStackFrame) {
                sourceFilePath = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
            }
            if (sourceFilePath != null) {
                File file;
                Openable openable;
                HandleFactory handleFactory = new HandleFactory();
                IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
                IFileHandle handle = EnvironmentPathUtils.getFile((IEnvironment)LocalEnvironment.getInstance(), (IPath)new Path(sourceFilePath));
                if (handle != null && (openable = handleFactory.createOpenable(handle.getFullPath().toString(), scope)) instanceof IStorage) {
                    return new Object[]{openable};
                }
                PharPath pharPath = PharPath.getPharPath((IPath)new Path(sourceFilePath));
                if (pharPath != null && !pharPath.getFile().isEmpty()) {
                    try {
                        PharArchiveFile archiveFile = new PharArchiveFile(pharPath.getPharName());
                        IArchiveEntry entry = archiveFile.getArchiveEntry(String.valueOf(pharPath.getFolder().length() == 0 ? "" : String.valueOf(pharPath.getFolder()) + "/") + pharPath.getFile());
                        return new Object[]{new ExternalEntryFile(sourceFilePath, archiveFile, entry)};
                    }
                    catch (Exception e) {
                        PHPDebugPlugin.log(e);
                    }
                }
                if (!(file = new File(sourceFilePath)).exists()) {
                    return EMPTY;
                }
                Object linkedFile = this.linkSubjectFileFinder.find(sourceFilePath, object);
                if (linkedFile != null) {
                    return new Object[]{linkedFile};
                }
                return new Object[]{new LocalFile(file)};
            }
        }
        return sourceElements;
    }

    private Object[] getRemoteSourceElements(Object stackFrameObj, boolean forceRetrieval) throws CoreException {
        PHPStackFrame stackFrame;
        ILaunchConfiguration launchConfiguration;
        if (stackFrameObj instanceof PHPStackFrame && (launchConfiguration = (stackFrame = (PHPStackFrame)((Object)stackFrameObj)).getLaunch().getLaunchConfiguration()) != null && (forceRetrieval || launchConfiguration.getAttribute("debugNoRemote", false))) {
            PHPDebugTarget debugTarget = (PHPDebugTarget)stackFrame.getDebugTarget();
            String fileName = stackFrame.getAbsoluteFileName();
            RemoteFileStorage fileStorage = this.remoteStorageCache.get(fileName);
            if (fileStorage == null) {
                String decodedFileName;
                RemoteDebugger remoteDebugger = (RemoteDebugger)debugTarget.getRemoteDebugger();
                try {
                    decodedFileName = URLDecoder.decode(fileName, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    decodedFileName = fileName;
                }
                String originalURL = debugTarget.getLaunch().getAttribute("uriginalURL");
                fileStorage = this.getRemoteFileStorage(remoteDebugger, decodedFileName, originalURL);
                this.remoteStorageCache.put(fileName, fileStorage);
            }
            return new Object[]{fileStorage};
        }
        return EMPTY;
    }

    private RemoteFileStorage getRemoteFileStorage(RemoteDebugger remoteDebugger, String fileName, String originalURL) {
        final SyncObject syncObject = new SyncObject();
        final CountDownLatch waitForContentLatch = new CountDownLatch(1);
        if (remoteDebugger == null || !remoteDebugger.isActive()) {
            return null;
        }
        RemoteDebugger.requestRemoteFile(new IRemoteFileContentRequestor(){

            @Override
            public void fileContentReceived(byte[] content, String serverAddress, String originalURL, String fileName, int lineNumber) {
                syncObject.set((Object)new RemoteFileStorage(content, fileName, originalURL));
            }

            @Override
            public void requestCompleted(Exception e) {
                waitForContentLatch.countDown();
            }
        }, fileName, 0, originalURL);
        try {
            waitForContentLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (RemoteFileStorage)((Object)syncObject.get());
    }

    private static final class ExternalEntryFile
    extends PlatformObject
    implements IStorage {
        private String fileName;
        private IArchiveEntry entry;
        private PharArchiveFile archiveFile;

        public ExternalEntryFile(String fileName, PharArchiveFile archiveFile, IArchiveEntry entry) {
            this.fileName = fileName;
            this.entry = entry;
            this.archiveFile = archiveFile;
        }

        public InputStream getContents() throws CoreException {
            try {
                return this.archiveFile.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new ModelException((Throwable)e, 985);
            }
        }

        public IPath getFullPath() {
            return new Path(this.fileName);
        }

        public String getName() {
            return this.entry.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public String toString() {
            return "ExternalEntryFile[" + this.fileName + "]";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExternalEntryFile)) {
                return false;
            }
            ExternalEntryFile other = (ExternalEntryFile)((Object)obj);
            return this.fileName.equalsIgnoreCase(other.fileName);
        }

        public int hashCode() {
            return this.fileName.toLowerCase().hashCode();
        }
    }

    private final class LinkSubjectFileFinder {
        private LinkSubjectFileFinder() {
        }

        public Object find(final String sourceLocation, Object element) {
            final LinkedList matches = new LinkedList();
            final String sourceFileName = new Path(sourceLocation).lastSegment();
            IWorkspaceRoot project = null;
            if (element instanceof IStackFrame) {
                IDebugTarget target = ((IStackFrame)element).getDebugTarget();
                project = PHPLaunchUtilities.getProject(target);
            }
            IWorkspaceRoot scope = project != null ? project : ResourcesPlugin.getWorkspace().getRoot();
            try {
                scope.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        block6: {
                            block5: {
                                if (matches.isEmpty()) break block5;
                                return false;
                            }
                            if (resource.getType() == 1) break block6;
                            return true;
                        }
                        try {
                            if ((resource.getName().equals(sourceFileName) || resource.isLinked() || PHPSymbolicLinksCache.INSTANCE.isSymbolicLink(resource)) && resource.getLocation() != null && FileUtils.isSameFile((String)sourceLocation, (String)resource.getLocation().toOSString())) {
                                matches.add(resource);
                            }
                        }
                        catch (IOException e) {
                            PHPDebugPlugin.log(e);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                PHPDebugPlugin.log(e);
            }
            return !matches.isEmpty() ? matches.getFirst() : null;
        }
    }
}

