/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.core.engine.ProfilerDataSerializationUtil;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.wizards.AbstractSessionWizard;
import org.eclipse.php.profile.ui.wizards.ExportSessionWizardFirstPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportSessionWizard
extends AbstractSessionWizard
implements IExportWizard {
    private ExportSessionWizardFirstPage page1;

    public boolean performFinish() {
        final ProfilerDB[] sessions = this.page1.getSessions();
        final String fileName = this.page1.getTargetFile();
        Job saveJob = new Job(PHPProfileUIMessages.getString("ExportSessionWizard.0")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProfilerDataSerializationUtil.serialize((ProfilerDB[])sessions, (OutputStream)new FileOutputStream(fileName));
                }
                catch (IOException e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPProfileUIMessages.getString("ExportSessionWizard.2"), (String)NLS.bind((String)PHPProfileUIMessages.getString("ExportSessionWizard.3"), (Object)fileName));
                        }
                    });
                    ProfilerUiPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.schedule();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(PHPProfileUIMessages.getString("ExportSessionWizard.1"));
        this.initSessionFromSelection(workbench);
    }

    public void addPages() {
        this.page1 = new ExportSessionWizardFirstPage(this.getSession());
        this.addPage((IWizardPage)this.page1);
    }

    public Image getDefaultPageImage() {
        return ProfilerUIImages.get("IMG_WIZBAN_EXPORT_PROFILE_SESSIONS");
    }
}

