/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultJavaInfoPresentation;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.osgi.framework.Bundle;

public abstract class StylePresentation
extends DefaultJavaInfoPresentation {
    private static final ClassMap<Map<Integer, ImageDescriptor>> m_images = ClassMap.create();

    public StylePresentation(WidgetInfo widget) {
        super((JavaInfo)widget);
    }

    public ImageDescriptor getIcon() throws Exception {
        int style = ControlSupport.getStyle(this.m_javaInfo.getObject());
        for (Map.Entry<Integer, ImageDescriptor> entry : this.getImages().entrySet()) {
            int keyStyle = entry.getKey();
            if ((style & keyStyle) != keyStyle) continue;
            return entry.getValue();
        }
        return super.getIcon();
    }

    protected abstract void initImages() throws Exception;

    private Map<Integer, ImageDescriptor> getImages() throws Exception {
        HashMap images = (HashMap)m_images.get(((Object)((Object)this)).getClass());
        if (images == null) {
            images = new HashMap();
            m_images.put(((Object)((Object)this)).getClass(), images);
            this.initImages();
        }
        return images;
    }

    protected final void addImage(int style, String imagePath) throws Exception {
        Bundle bundle = this.m_javaInfo.getDescription().getToolkit().getBundle();
        URL imageURL = bundle.getEntry(imagePath);
        Assert.isNotNull((Object)imageURL, (String)MessageFormat.format(ModelMessages.StylePresentation_canNotFindImage, imagePath, bundle.getSymbolicName()));
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)imageURL);
        this.getImages().put(style, image);
    }
}

