/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.NamedTopLevelNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class ExternalNode
extends NamedTopLevelNode {
    String publicID;
    String systemID;

    public ExternalNode(DTDFile file, IStructuredDocumentRegion flatNode, String tagType) {
        super(file, flatNode, tagType);
    }

    public ITextRegion getNextQuotedLiteral(RegionIterator iter) {
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (!region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SINGLEQUOTED_LITERAL") && !region.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.DOUBLEQUOTED_LITERAL")) continue;
            return region;
        }
        return null;
    }

    public String getPublicID() {
        ITextRegion publicValue = this.getPublicValueRegion();
        if (publicValue != null) {
            return this.getValueFromQuotedRegion(publicValue);
        }
        return "";
    }

    public ITextRegion getPublicKeywordRegion(RegionIterator iter) {
        return this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.PUBLIC_KEYWORD");
    }

    public ITextRegion getPublicValueRegion() {
        ITextRegion quotedLiteral;
        RegionIterator iter = this.iterator();
        ITextRegion publicKeyword = this.getPublicKeywordRegion(iter);
        if (publicKeyword != null && iter.hasNext() && (quotedLiteral = this.getNextQuotedLiteral(iter)) != null) {
            return quotedLiteral;
        }
        return null;
    }

    public String getSystemID() {
        ITextRegion systemValue = this.getSystemValueRegion();
        if (systemValue != null) {
            return this.getValueFromQuotedRegion(systemValue);
        }
        return "";
    }

    public ITextRegion getSystemKeywordRegion(RegionIterator iter) {
        return this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SYSTEM_KEYWORD");
    }

    public ITextRegion getSystemValueRegion() {
        RegionIterator iter = this.iterator();
        ITextRegion systemKeyword = this.getSystemKeywordRegion(iter);
        if (systemKeyword != null && iter.hasNext()) {
            ITextRegion quotedLiteral = this.getNextQuotedLiteral(iter);
            if (quotedLiteral != null) {
                return quotedLiteral;
            }
        } else {
            ITextRegion quotedLiteral;
            iter = this.iterator();
            ITextRegion publicKeyword = this.getPublicKeywordRegion(iter);
            if (publicKeyword != null && iter.hasNext() && (quotedLiteral = this.getNextQuotedLiteral(iter)) != null && iter.hasNext() && (quotedLiteral = this.getNextQuotedLiteral(iter)) != null) {
                return quotedLiteral;
            }
        }
        return null;
    }

    public String getValueFromQuotedRegion(ITextRegion region) {
        String type = region.getType();
        if (type.equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SINGLEQUOTED_LITERAL") || type.equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.DOUBLEQUOTED_LITERAL")) {
            String text = this.getStructuredDTDDocumentRegion().getText(region);
            return text.substring(1, text.length() - 1);
        }
        return "";
    }

    public void setPublicID(Object requestor, String v) {
        if (!v.equals(this.publicID)) {
            this.publicID = v;
            ITextRegion publicValue = this.getPublicValueRegion();
            ITextRegion publicKeyword = this.getPublicKeywordRegion(this.iterator());
            ITextRegion systemKeyword = this.getSystemKeywordRegion(this.iterator());
            ITextRegion systemValue = this.getSystemValueRegion();
            if (v.equals("")) {
                if (publicKeyword != null) {
                    int startOffset = this.getStructuredDTDDocumentRegion().getStartOffset(publicKeyword);
                    String newString = "SYSTEM";
                    if (systemValue == null) {
                        newString = String.valueOf(newString) + " \"\"";
                    }
                    this.replaceText(requestor, startOffset, this.getStructuredDTDDocumentRegion().getEndOffset(publicValue) - startOffset, newString);
                }
            } else {
                String quoteChar;
                String string = quoteChar = v.indexOf("\"") == -1 ? "\"" : "'";
                if (publicValue != null) {
                    this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(publicValue), publicValue.getLength(), String.valueOf(quoteChar) + this.publicID + quoteChar);
                } else if (publicKeyword != null) {
                    this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getEndOffset(publicKeyword), 0, " " + quoteChar + v + quoteChar);
                } else if (systemKeyword != null) {
                    this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(systemKeyword), systemKeyword.getLength(), "PUBLIC " + quoteChar + v + quoteChar);
                } else {
                    ITextRegion nameRegion = this.getNameRegion();
                    this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getEndOffset(nameRegion), 0, " PUBLIC " + quoteChar + v + quoteChar);
                }
            }
        }
    }

    public void setPublicID(String v) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_EXT_NODE_PUBLIC_ID_CHG);
        this.setPublicID((Object)this, v);
        this.endRecording((Object)this);
    }

    public void setSystemID(Object requestor, String v) {
        if (!v.equals(this.systemID) || this.getPublicKeywordRegion(this.iterator()) == null && this.getSystemKeywordRegion(this.iterator()) == null) {
            this.systemID = v;
            String quoteChar = v.indexOf("\"") == -1 ? "\"" : "'";
            ITextRegion systemValue = this.getSystemValueRegion();
            if (systemValue != null) {
                this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(systemValue), systemValue.getLength(), String.valueOf(quoteChar) + this.systemID + quoteChar);
            } else {
                ITextRegion systemKeyword = this.getSystemKeywordRegion(this.iterator());
                if (systemKeyword != null) {
                    this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getEndOffset(systemKeyword), 0, " " + quoteChar + v + quoteChar);
                } else {
                    ITextRegion publicKeyword = this.getPublicKeywordRegion(this.iterator());
                    if (publicKeyword == null) {
                        ITextRegion nameRegion = this.getNameRegion();
                        this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getEndOffset(nameRegion), 0, " SYSTEM " + quoteChar + v + quoteChar);
                    } else {
                        ITextRegion publicValueRegion = this.getPublicValueRegion();
                        this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getEndOffset(publicValueRegion), 0, " " + quoteChar + v + quoteChar);
                    }
                }
            }
        }
    }

    public void setSystemID(String v) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_EXT_NODE_SYSTEM_ID_CHG);
        this.setSystemID((Object)this, v);
        this.endRecording((Object)this);
    }
}

