/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentassist.contentmodel;

import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentModelGenerator;
import org.w3c.dom.Node;

public class XSLContentModelGenerator
extends AbstractContentModelGenerator {
    public void generateAttribute(CMAttributeDeclaration attrDecl, StringBuffer buffer) {
        if (attrDecl == null || buffer == null) {
            return;
        }
        int usage = attrDecl.getUsage();
        if (usage == 2) {
            buffer.append(" ");
            this.generateRequiredAttribute(null, attrDecl, buffer);
        }
    }

    protected void generateEndTag(String tagName, Node parentNode, CMElementDeclaration elementDecl, StringBuffer buffer) {
        if (elementDecl == null) {
            return;
        }
        if (elementDecl.getContentType() != 1) {
            buffer.append("</" + tagName + ">");
        }
    }

    public void generateRequiredAttribute(Node ownerNode, CMAttributeDeclaration attrDecl, StringBuffer buffer) {
        if (attrDecl == null || buffer == null) {
            return;
        }
        String attributeName = this.getRequiredName(ownerNode, (CMNode)attrDecl);
        CMDataType attrType = attrDecl.getAttrType();
        String defaultValue = null;
        buffer.append(String.valueOf(attributeName) + "=");
        if (attrType != null) {
            if (attrType.getImpliedValueKind() != 1 && attrType.getImpliedValue() != null) {
                defaultValue = attrType.getImpliedValue();
            } else if (attrType.getEnumeratedValues() != null && attrType.getEnumeratedValues().length > 0) {
                defaultValue = attrType.getEnumeratedValues()[0];
            }
        }
        char attrQuote = '\"';
        if (defaultValue != null && defaultValue.indexOf(attrQuote) >= 0) {
            attrQuote = '\'';
        }
        buffer.append(attrQuote);
        buffer.append(defaultValue != null ? defaultValue : "");
        buffer.append(attrQuote);
    }

    protected void generateStartTag(String tagName, Node parentNode, CMElementDeclaration elementDecl, StringBuffer buffer) {
        if (elementDecl == null || buffer == null) {
            return;
        }
        buffer.append("<" + tagName);
        this.generateAttributes(elementDecl, buffer);
        buffer.append(this.getStartTagClose(parentNode, elementDecl));
    }

    public int getMinimalStartTagLength(Node node, CMElementDeclaration elementDecl) {
        if (elementDecl == null) {
            return 0;
        }
        if (this.requiresAttributes(elementDecl)) {
            return this.getRequiredName(node, (CMNode)elementDecl).length() + 2;
        }
        return 1 + this.getRequiredName(node, (CMNode)elementDecl).length() + this.getStartTagClose(node, elementDecl).length();
    }

    protected String getOtherClose(Node notATagNode) {
        return null;
    }

    public String getStartTagClose(Node parentNode, CMElementDeclaration elementDecl) {
        String other = this.getOtherClose(parentNode);
        if (other != null) {
            return other;
        }
        if (elementDecl == null) {
            return ">";
        }
        if (elementDecl.getContentType() == 1) {
            return "/>";
        }
        return ">";
    }
}

