/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelEntityRelationshipFactory
extends AbstractStylingModelFactory {
    public GraphModelEntityRelationshipFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        if (!(viewer.getContentProvider() instanceof IGraphEntityRelationshipContentProvider)) {
            throw new IllegalArgumentException("Expected IGraphEntityRelationshipContentProvider");
        }
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object[] nodes = this.getContentProvider().getElements(this.getViewer().getInput());
        nodes = this.filter(this.getViewer().getInput(), nodes);
        this.createModelNodes(model, nodes);
        this.createModelRelationships(model);
    }

    /*
     * WARNING - void declaration
     */
    private void createModelRelationships(Graph model) {
        GraphNode[] modelNodes = GraphModelEntityRelationshipFactory.getNodesArray(model);
        ArrayList<GraphNode> listOfNodes = new ArrayList<GraphNode>();
        Collections.addAll(listOfNodes, modelNodes);
        int i = 0;
        while (i < listOfNodes.size()) {
            GraphNode node = (GraphNode)((Object)listOfNodes.get(i));
            GraphNode graphNode = node;
            if (graphNode instanceof GraphContainer) {
                void container;
                GraphContainer cfr_ignored_0 = (GraphContainer)graphNode;
                GraphContainer cfr_ignored_1 = (GraphContainer)graphNode;
                List<GraphNode> childNodes = container.getNodes();
                listOfNodes.addAll(childNodes);
            }
            ++i;
        }
        modelNodes = listOfNodes.toArray(new GraphNode[listOfNodes.size()]);
        IGraphEntityRelationshipContentProvider content = this.getCastedContent();
        GraphNode[] graphNodeArray = modelNodes;
        int n = modelNodes.length;
        int n2 = 0;
        while (n2 < n) {
            GraphNode modelNode = graphNodeArray[n2];
            GraphNode[] graphNodeArray2 = modelNodes;
            int n3 = modelNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                GraphNode modelNode2 = graphNodeArray2[n4];
                Object[] rels = content.getRelationships(modelNode.getData(), modelNode2.getData());
                if (rels != null) {
                    Object[] objectArray = rels = this.filter(this.getViewer().getInput(), rels);
                    int n5 = rels.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Object rel = objectArray[n6];
                        this.createConnection(model, rel, modelNode.getData(), modelNode2.getData());
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createModelNodes(Graph model, Object[] nodes) {
        Object[] objectArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.createNode(model, node);
            ++n2;
        }
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    @Override
    public void refresh(Graph graph, Object element, boolean updateLabels) {
        this.refreshGraph(graph);
    }

    private IGraphEntityRelationshipContentProvider getCastedContent() {
        return (IGraphEntityRelationshipContentProvider)this.getContentProvider();
    }
}

