/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.zest.core.widgets.internal.XYScaledGraphics;

public class AspectRatioFreeformLayer
extends FreeformLayer
implements ScalableFigure,
FreeformFigure {
    private double widthScale = 1.0;
    private double heigthScale = 1.0;

    public AspectRatioFreeformLayer(String debugLabel) {
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setBorder((Border)new MarginBorder(5));
    }

    protected boolean isValidationRoot() {
        return true;
    }

    public void setScale(double wScale, double hScale) {
        this.widthScale = wScale;
        this.heigthScale = hScale;
    }

    public double getWidthScale() {
        return this.widthScale;
    }

    public double getHeightScale() {
        return this.heigthScale;
    }

    public double getScale() {
        throw new RuntimeException("Operation not supported");
    }

    public void setScale(double scale) {
        this.widthScale = scale;
        this.heigthScale = scale;
        this.revalidate();
        this.repaint();
    }

    public Rectangle getClientArea(Rectangle rect) {
        rect.width = (int)((double)rect.width / this.widthScale);
        rect.height = (int)((double)rect.height / this.heigthScale);
        rect.x = (int)((double)rect.x / this.widthScale);
        rect.y = (int)((double)rect.y / this.heigthScale);
        return rect;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.widthScale, this.heigthScale).expand(w, h);
    }

    /*
     * WARNING - void declaration
     */
    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        Translatable translatable = t;
        if (translatable instanceof PrecisionRectangle) {
            void r;
            PrecisionRectangle precisionRectangle = (PrecisionRectangle)translatable;
            PrecisionRectangle cfr_ignored_0 = (PrecisionRectangle)translatable;
            r.setPreciseX(r.preciseX() * (1.0 / this.widthScale));
            r.setPreciseY(r.preciseY() * (1.0 / this.heigthScale));
            r.setPreciseWidth(r.preciseWidth() * (1.0 / this.widthScale));
            r.setPreciseHeight(r.preciseHeight() * (1.0 / this.heigthScale));
        } else {
            Translatable translatable2 = t;
            if (translatable2 instanceof Rectangle) {
                void r;
                Rectangle rectangle = (Rectangle)translatable2;
                Rectangle cfr_ignored_1 = (Rectangle)translatable2;
                r.scale(1.0 / this.widthScale, 1.0 / this.heigthScale);
            } else {
                Translatable translatable3 = t;
                if (translatable3 instanceof CaretInfo) {
                    void c;
                    CaretInfo caretInfo = (CaretInfo)translatable3;
                    CaretInfo cfr_ignored_2 = (CaretInfo)translatable3;
                    c.performScale(1.0 / this.heigthScale);
                } else {
                    Translatable translatable4 = t;
                    if (translatable4 instanceof PrecisionDimension) {
                        void d;
                        PrecisionDimension precisionDimension = (PrecisionDimension)translatable4;
                        PrecisionDimension cfr_ignored_3 = (PrecisionDimension)translatable4;
                        d.setPreciseWidth(d.preciseWidth() * (1.0 / this.widthScale));
                        d.setPreciseHeight(d.preciseHeight() * (1.0 / this.heigthScale));
                    } else {
                        Translatable translatable5 = t;
                        if (translatable5 instanceof Dimension) {
                            void d;
                            Dimension dimension = (Dimension)translatable5;
                            Dimension cfr_ignored_4 = (Dimension)translatable5;
                            d.scale(1.0 / this.widthScale, 1.0 / this.heigthScale);
                        } else {
                            Translatable translatable6 = t;
                            if (translatable6 instanceof PrecisionPoint) {
                                void p;
                                PrecisionPoint precisionPoint = (PrecisionPoint)translatable6;
                                PrecisionPoint cfr_ignored_5 = (PrecisionPoint)translatable6;
                                p.setPreciseX(p.preciseX() * (1.0 / this.widthScale));
                                p.setPreciseY(p.preciseY() * (1.0 / this.heigthScale));
                            } else {
                                Translatable translatable7 = t;
                                if (translatable7 instanceof Point) {
                                    void p;
                                    Point point = (Point)translatable7;
                                    Point cfr_ignored_6 = (Point)translatable7;
                                    p.scale(1.0 / this.widthScale, 1.0 / this.heigthScale);
                                } else {
                                    if (t instanceof PointList) {
                                        throw new RuntimeException("PointList not supported in AspectRatioScale");
                                    }
                                    throw new RuntimeException(t.toString() + " not supported in AspectRatioScale");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void translateToParent(Translatable t) {
        Translatable translatable = t;
        if (translatable instanceof PrecisionRectangle) {
            void r;
            PrecisionRectangle precisionRectangle = (PrecisionRectangle)translatable;
            PrecisionRectangle cfr_ignored_0 = (PrecisionRectangle)translatable;
            r.setPreciseX(r.preciseX() * this.widthScale);
            r.setPreciseY(r.preciseY() * this.heigthScale);
            r.setPreciseWidth(r.preciseWidth() * this.widthScale);
            r.setPreciseHeight(r.preciseHeight() * this.heigthScale);
        } else {
            Translatable translatable2 = t;
            if (translatable2 instanceof Rectangle) {
                void r;
                Rectangle rectangle = (Rectangle)translatable2;
                Rectangle cfr_ignored_1 = (Rectangle)translatable2;
                r.scale(this.widthScale, this.heigthScale);
            } else {
                Translatable translatable3 = t;
                if (translatable3 instanceof CaretInfo) {
                    void c;
                    CaretInfo caretInfo = (CaretInfo)translatable3;
                    CaretInfo cfr_ignored_2 = (CaretInfo)translatable3;
                    c.performScale(this.heigthScale);
                } else {
                    Translatable translatable4 = t;
                    if (translatable4 instanceof PrecisionDimension) {
                        void d;
                        PrecisionDimension precisionDimension = (PrecisionDimension)translatable4;
                        PrecisionDimension cfr_ignored_3 = (PrecisionDimension)translatable4;
                        d.setPreciseWidth(d.preciseWidth() * this.widthScale);
                        d.setPreciseHeight(d.preciseHeight() * this.heigthScale);
                    } else {
                        Translatable translatable5 = t;
                        if (translatable5 instanceof Dimension) {
                            void d;
                            Dimension dimension = (Dimension)translatable5;
                            Dimension cfr_ignored_4 = (Dimension)translatable5;
                            d.scale(this.widthScale, this.heigthScale);
                        } else {
                            Translatable translatable6 = t;
                            if (translatable6 instanceof PrecisionPoint) {
                                void p;
                                PrecisionPoint precisionPoint = (PrecisionPoint)translatable6;
                                PrecisionPoint cfr_ignored_5 = (PrecisionPoint)translatable6;
                                p.setPreciseX(p.preciseX() * this.widthScale);
                                p.setPreciseY(p.preciseY() * this.heigthScale);
                            } else {
                                Translatable translatable7 = t;
                                if (translatable7 instanceof Point) {
                                    void p;
                                    Point point = (Point)translatable7;
                                    Point cfr_ignored_6 = (Point)translatable7;
                                    p.scale(this.widthScale, this.heigthScale);
                                } else {
                                    if (t instanceof PointList) {
                                        throw new RuntimeException("PointList not supported in AspectRatioScale");
                                    }
                                    throw new RuntimeException(t.toString() + " not supported in AspectRatioScale");
                                }
                            }
                        }
                    }
                }
            }
        }
        super.translateToParent(t);
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        XYScaledGraphics g = null;
        boolean disposeGraphics = false;
        if (graphics instanceof XYScaledGraphics) {
            g = (XYScaledGraphics)graphics;
        } else {
            g = new XYScaledGraphics(graphics);
            disposeGraphics = true;
        }
        if (!this.optimizeClip()) {
            g.clipRect(this.getBounds().getShrinked(this.getInsets()));
        }
        g.scale(this.widthScale, this.heigthScale);
        g.pushState();
        this.paintChildren((Graphics)g);
        g.popState();
        if (disposeGraphics) {
            g.dispose();
            graphics.restoreState();
        }
    }
}

