/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.mapping;

import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttribute;
import org.eclipse.jpt.jpa.annotate.mapping.AnnotationAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

public class EntityPropertyElem {
    private String _fqClassName;
    private Table _dbTable;
    private String _propertyName;
    private String _propertyType;
    private String _tagName;
    private boolean _unmapped;
    private Column _column;
    private ColumnAttributes _columnAnnotationAttrs;
    private AnnotationAttributes _annotationAttrs;

    public EntityPropertyElem(String fqClassName, Table table) {
        this._fqClassName = fqClassName;
        this._dbTable = table;
        this._columnAnnotationAttrs = null;
        this._annotationAttrs = new AnnotationAttributes();
    }

    public EntityPropertyElem(String fqClassName, Table table, String propName, String propType) {
        this(fqClassName, table);
        this._propertyName = propName;
        this._propertyType = propType;
    }

    public EntityPropertyElem(EntityPropertyElem another) {
        this(another.getClassName(), another.getDBTable());
        this._propertyName = another._propertyName;
        this._propertyType = another._propertyType;
        this._tagName = another._tagName;
        this._unmapped = another._unmapped;
        this._column = another._column;
        if (another._columnAnnotationAttrs != null) {
            this._columnAnnotationAttrs = new ColumnAttributes(another._columnAnnotationAttrs);
        }
        if (another._annotationAttrs != null) {
            this._annotationAttrs = new AnnotationAttributes(another._annotationAttrs);
        }
    }

    public String getClassName() {
        return this._fqClassName;
    }

    public Table getDBTable() {
        return this._dbTable;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public void setPropertyName(String propName) {
        this._propertyName = propName;
    }

    public String getPropertyType() {
        return this._propertyType;
    }

    public void setPropertyType(String propType) {
        this._propertyType = propType;
    }

    public String getTagName() {
        return this._tagName;
    }

    public void setTagName(String tagName) {
        this._tagName = tagName;
    }

    public boolean isUnmapped() {
        return this._unmapped;
    }

    public void setUnmapped(boolean unmapped) {
        this._unmapped = unmapped;
    }

    public void setColumnAnnotationAttrs(ColumnAttributes columnAnnotationAttrs) {
        this._columnAnnotationAttrs = columnAnnotationAttrs;
    }

    public ColumnAttributes getColumnAnnotationAttrs() {
        return this._columnAnnotationAttrs;
    }

    public void setAnnotationAttr(AnnotationAttribute attr) {
        this._annotationAttrs.setAnnotationAttribute(attr);
    }

    public AnnotationAttributes getAnnotationAttrs() {
        return this._annotationAttrs;
    }

    public AnnotationAttribute[] getAnnotationAttrs(String[] attrNames) {
        return this._annotationAttrs.getAnnotationAttributes(attrNames);
    }

    public AnnotationAttribute getAnnotationAttribute(String attrName) {
        return this._annotationAttrs.getAnnotationAttribute(attrName);
    }

    public void setDBColumn(Column column) {
        this._column = column;
    }

    public Column getDBColumn() {
        return this._column;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._fqClassName == null ? 0 : this._fqClassName.hashCode());
        result = 31 * result + (this._propertyName == null ? 0 : this._propertyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityPropertyElem)) {
            return false;
        }
        EntityPropertyElem other = (EntityPropertyElem)obj;
        if (this._fqClassName == null ? other._fqClassName != null : !this._fqClassName.equals(other._fqClassName)) {
            return false;
        }
        return !(this._propertyName == null ? other._propertyName != null : !this._propertyName.equals(other._propertyName));
    }
}

