/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.UpgradeOperation;

public class UpgradeStatus
extends Status {
    private final boolean upgradeOccurred;
    private UpgradeOperation upgradeOperation;

    public UpgradeStatus() {
        super(0, JSFCorePlugin.getDefault().getPluginID(), Messages.UpgradeStatus_OK);
        this.upgradeOccurred = false;
    }

    public UpgradeStatus(int severity, boolean upgradeOccurred, String message) {
        super(severity, JSFCorePlugin.getDefault().getPluginID(), message);
        this.upgradeOccurred = upgradeOccurred;
    }

    public boolean isUpgradeOccurred() {
        return this.upgradeOccurred;
    }

    protected UpgradeOperation getUpgradeOperation() {
        return this.upgradeOperation;
    }

    void setUpgradeOperation(UpgradeOperation upgradeOperation) {
        this.upgradeOperation = upgradeOperation;
    }

    public IStatus commit() {
        if (this.upgradeOperation != null) {
            try {
                return this.upgradeOperation.commit();
            }
            catch (ExecutionException e) {
                return new Status(4, JSFCorePlugin.getDefault().getPluginID(), Messages.UpgradeStatus_Error, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus rollback() {
        if (this.upgradeOperation != null) {
            try {
                return this.upgradeOperation.undo((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                return new Status(4, JSFCorePlugin.getDefault().getPluginID(), Messages.UpgradeStatus_Error, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }
}

